/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BinaryTestWriter {
    private static final TestDescription[] noTests = new TestDescription[0];
    private PrintStream log = System.out;
    static /* synthetic */ Class class$com$sun$javatest$finder$BinaryTestWriter;

    public static void main(String[] stringArray) {
        try {
            BinaryTestWriter binaryTestWriter = new BinaryTestWriter();
            binaryTestWriter.run(stringArray);
        }
        catch (BadArgs badArgs) {
            System.err.println("Bad Arguments: " + badArgs.getMessage());
            BinaryTestWriter.usage(System.err);
            System.exit(1);
        }
        catch (Fault fault) {
            System.err.println("Error: " + fault.getMessage());
            System.exit(2);
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
            System.exit(3);
        }
    }

    private static void usage(PrintStream printStream) {
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$finder$BinaryTestWriter == null ? (class$com$sun$javatest$finder$BinaryTestWriter = BinaryTestWriter.class$("com.sun.javatest.finder.BinaryTestWriter")) : class$com$sun$javatest$finder$BinaryTestWriter).getName());
        printStream.println("Usage:");
        printStream.println("  " + string + " [options]  test-suite [tests...]");
        printStream.println("Options:");
        printStream.println("  -finder finderClass finderArgs... -end");
        printStream.println("  -o output-file");
    }

    public void run(String[] stringArray) throws BadArgs, Fault, IOException {
        File file = null;
        String string = "com.sun.javatest.finder.TagTestFinder";
        String[] stringArray2 = new String[]{};
        File file2 = null;
        File[] fileArray = null;
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            if (stringArray[n].equalsIgnoreCase("-finder") && n + 1 < stringArray.length) {
                string = stringArray[++n];
                n2 = ++n;
                while (n < stringArray.length - 1 && !stringArray[n].equalsIgnoreCase("-end")) {
                    ++n;
                }
                stringArray2 = new String[n - n2];
                System.arraycopy(stringArray, n2, stringArray2, 0, stringArray2.length);
            } else {
                if (!stringArray[n].equalsIgnoreCase("-o") || n + 1 >= stringArray.length) {
                    if (stringArray[n].startsWith("-")) {
                        throw new BadArgs(stringArray[n]);
                    }
                    file = new File(stringArray[n++]);
                    if (n >= stringArray.length) break;
                    fileArray = new File[stringArray.length - n];
                    n2 = 0;
                    while (n2 < fileArray.length) {
                        fileArray[n2] = new File(stringArray[n + n2]);
                        ++n2;
                    }
                    break;
                }
                file2 = new File(stringArray[++n]);
            }
            ++n;
        }
        if (file == null) {
            throw new BadArgs("testsuite.html file not specified");
        }
        TestFinder testFinder = this.initializeTestFinder(string, stringArray2, file);
        if (fileArray == null) {
            fileArray = new File[]{testFinder.getRoot()};
        }
        if (file2 == null) {
            file2 = new File(testFinder.getRootDir(), "testsuite.jtd");
        }
        StringTable stringTable = new StringTable();
        TestTable testTable = new TestTable(stringTable);
        TestTree testTree = new TestTree(testTable);
        if (this.log != null) {
            this.log.println("Reading tests...");
        }
        this.read(testFinder, fileArray, testTree);
        if (testTree.getSize() == 0) {
            throw new Fault("No tests found -- check arguments.");
        }
        if (this.log != null) {
            this.log.println("Writing " + file2);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        zipOutputStream.setMethod(8);
        zipOutputStream.setLevel(9);
        ZipEntry zipEntry = stringTable.write(zipOutputStream);
        ZipEntry zipEntry2 = testTable.write(zipOutputStream);
        ZipEntry zipEntry3 = testTree.write(zipOutputStream);
        zipOutputStream.close();
        if (this.log != null) {
            this.log.println("strings: " + stringTable.getSize() + " entries, " + this.zipStats(zipEntry));
            this.log.println("tests: " + testTable.getSize() + " tests, " + this.zipStats(zipEntry2));
            this.log.println("tree: " + testTree.getSize() + " nodes, " + this.zipStats(zipEntry3));
        }
    }

    private TestFinder initializeTestFinder(String string, String[] stringArray, File file) throws Fault {
        TestFinder testFinder;
        if (file == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> clazz = Class.forName(string);
            testFinder = (TestFinder)clazz.newInstance();
            testFinder.init(stringArray, file, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault("Error: Can't find class for test finder specified: " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new Fault("Error: Can't create new instance of test finder: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("Error: Can't access test finder: " + illegalAccessException);
        }
        catch (TestFinder.Fault fault) {
            throw new Fault("Error: Can't initialize test-finder: " + fault.getMessage());
        }
        return testFinder;
    }

    private File getTestSuiteFile(String string) throws Fault {
        File file = new File(string);
        if (file.isFile()) {
            return file;
        }
        File file2 = new File(file, "testsuite.html");
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(file, "tests/testsuite.html");
        if (file3.exists()) {
            return file3;
        }
        throw new Fault("Bad input. " + string + " is not a JCK");
    }

    private String zipStats(ZipEntry zipEntry) {
        long l = zipEntry.getSize();
        long l2 = zipEntry.getCompressedSize();
        return l + " bytes (" + l2 + " compressed, " + l2 * 100L / l + "%)";
    }

    /*
     * Unable to fully structure code
     */
    void read(TestFinder var1_1, File[] var2_2, TestTree var3_3) throws Fault {
        if (var2_2.length < 1) {
            throw new IllegalArgumentException();
        }
        var4_4 = var1_1.getRootDir();
        var5_5 = null;
        var6_6 = 0;
        while (var6_6 < var2_2.length) {
            block5: {
                var7_7 = var2_2[var6_6];
                if (!var7_7.isAbsolute()) {
                    var7_7 = new File(var4_4, var7_7.getPath());
                }
                if ((var8_8 = this.read0(var1_1, var7_7, var3_3)) != null) ** GOTO lbl17
                break block5;
lbl-1000:
                // 1 sources

                {
                    var7_7 = var7_7.getParentFile();
                    v0 = var3_3;
                    v0.getClass();
                    var8_8 = v0.new TestTree.Node(var7_7.getName(), BinaryTestWriter.noTests, new TestTree.Node[]{var8_8});
lbl17:
                    // 2 sources

                    ** while (!var7_7.equals((Object)var4_4))
                }
lbl18:
                // 1 sources

                var5_5 = var5_5 == null ? var8_8 : var5_5.merge(var8_8);
            }
            ++var6_6;
        }
        if (var5_5 == null) {
            throw new Fault("No tests found");
        }
        var3_3.setRoot(var5_5);
    }

    private TestTree.Node read0(TestFinder testFinder, File file, TestTree testTree) {
        Object object;
        testFinder.read(file);
        TestDescription[] testDescriptionArray = testFinder.getTests();
        Object[] objectArray = testFinder.getFiles();
        if (testDescriptionArray.length == 0 && objectArray.length == 0) {
            return null;
        }
        Arrays.sort(objectArray);
        Arrays.sort(testDescriptionArray, new Comparator(){

            public int compare(Object object, Object object2) {
                TestDescription testDescription = (TestDescription)object;
                TestDescription testDescription2 = (TestDescription)object2;
                return testDescription.getRootRelativeURL().compareTo(testDescription2.getRootRelativeURL());
            }
        });
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < objectArray.length) {
            object = this.read0(testFinder, (File)objectArray[n], testTree);
            if (object != null) {
                vector.addElement((Object[])object);
            }
            ++n;
        }
        object = new TestTree.Node[vector.size()];
        vector.copyInto((Object[])object);
        TestTree testTree2 = testTree;
        testTree2.getClass();
        return testTree2.new TestTree.Node(file.getName(), testDescriptionArray, (TestTree.Node[])object);
    }

    private static void writeInt(DataOutputStream dataOutputStream, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        boolean bl = true;
        int n2 = 28;
        while (n2 > 0) {
            int n3 = n >> n2 & 0x7F;
            boolean bl2 = bl = bl && n3 == 0;
            if (!bl) {
                dataOutputStream.writeByte(0x80 | n3);
            }
            n2 -= 7;
        }
        dataOutputStream.writeByte(n & 0x7F);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TestTree {
        private Node root;
        private TestTable testTable;

        TestTree(TestTable testTable) {
            this.testTable = testTable;
        }

        void setRoot(Node node) {
            this.root = node;
        }

        int getSize() {
            return this.root == null ? 0 : this.root.getSize();
        }

        ZipEntry write(ZipOutputStream zipOutputStream) throws IOException {
            ZipEntry zipEntry = new ZipEntry("tree");
            zipOutputStream.putNextEntry(zipEntry);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            this.write(dataOutputStream);
            dataOutputStream.flush();
            zipOutputStream.closeEntry();
            return zipEntry;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            this.root.write(dataOutputStream);
        }

        class Node {
            private String name;
            private TestDescription[] tests;
            private Node[] children;

            Node(String string, TestDescription[] testDescriptionArray, Node[] nodeArray) {
                this.name = string;
                this.tests = testDescriptionArray;
                this.children = nodeArray;
                int n = 0;
                while (n < testDescriptionArray.length) {
                    TestTree.this.testTable.add(testDescriptionArray[n]);
                    ++n;
                }
            }

            int getSize() {
                int n = 1;
                if (this.children != null) {
                    int n2 = 0;
                    while (n2 < this.children.length) {
                        n += this.children[n2].getSize();
                        ++n2;
                    }
                }
                return n;
            }

            Node merge(Node node) {
                TestDescription[] testDescriptionArray;
                Node[] nodeArray;
                if (!node.name.equals(this.name)) {
                    throw new IllegalArgumentException(this.name + ":" + node.name);
                }
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                int n = 0;
                while (n < this.children.length) {
                    Node node2 = this.children[n];
                    treeMap.put(node2.name, node2);
                    ++n;
                }
                int n2 = 0;
                while (n2 < node.children.length) {
                    nodeArray = node.children[n2];
                    testDescriptionArray = (TestDescription[])treeMap.get(nodeArray.name);
                    treeMap.put(nodeArray.name, testDescriptionArray == null ? nodeArray : nodeArray.merge((Node)testDescriptionArray));
                    ++n2;
                }
                nodeArray = treeMap.values().toArray(new Node[treeMap.size()]);
                if (this.tests.length + node.tests.length == 0) {
                    testDescriptionArray = noTests;
                } else {
                    testDescriptionArray = new TestDescription[this.tests.length + node.tests.length];
                    System.arraycopy(this.tests, 0, testDescriptionArray, 0, this.tests.length);
                    System.arraycopy(node.tests, 0, testDescriptionArray, this.tests.length, node.tests.length);
                }
                return new Node(this.name, testDescriptionArray, nodeArray);
            }

            void write(DataOutputStream dataOutputStream) throws IOException {
                dataOutputStream.writeUTF(this.name);
                BinaryTestWriter.writeInt(dataOutputStream, this.tests.length);
                int n = 0;
                while (n < this.tests.length) {
                    BinaryTestWriter.writeInt(dataOutputStream, TestTree.this.testTable.getIndex(this.tests[n]));
                    ++n;
                }
                BinaryTestWriter.writeInt(dataOutputStream, this.children.length);
                int n2 = 0;
                while (n2 < this.children.length) {
                    this.children[n2].write(dataOutputStream);
                    ++n2;
                }
            }
        }
    }

    static class TestTable {
        private HashMap testMap = new HashMap();
        private Vector tests = new Vector();
        private StringTable stringTable;

        TestTable(StringTable stringTable) {
            this.stringTable = stringTable;
        }

        void add(TestDescription testDescription) {
            this.tests.addElement(testDescription);
            this.testMap.put(testDescription, new Entry());
            this.stringTable.add(testDescription);
        }

        int getSize() {
            return this.tests.size();
        }

        int getIndex(TestDescription testDescription) {
            Entry entry = (Entry)this.testMap.get(testDescription);
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            return entry.index;
        }

        ZipEntry write(ZipOutputStream zipOutputStream) throws IOException {
            ZipEntry zipEntry = new ZipEntry("tests");
            zipOutputStream.putNextEntry(zipEntry);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            this.write(dataOutputStream);
            dataOutputStream.flush();
            zipOutputStream.closeEntry();
            return zipEntry;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            BinaryTestWriter.writeInt(dataOutputStream, this.tests.size());
            int n = 0;
            while (n < this.tests.size()) {
                TestDescription testDescription = (TestDescription)this.tests.elementAt(n);
                Entry entry = (Entry)this.testMap.get(testDescription);
                entry.index = dataOutputStream.size();
                this.write(testDescription, dataOutputStream);
                ++n;
            }
        }

        private void write(TestDescription testDescription, DataOutputStream dataOutputStream) throws IOException {
            BinaryTestWriter.writeInt(dataOutputStream, testDescription.getParameterCount());
            Iterator iterator = testDescription.getParameterKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = testDescription.getParameter(string);
                this.stringTable.writeRef(string, dataOutputStream);
                this.stringTable.writeRef(string2, dataOutputStream);
            }
        }

        class Entry {
            int index = -1;

            Entry() {
            }
        }
    }

    static class StringTable {
        private TreeMap map = new TreeMap();
        private int writtenSize;

        StringTable() {
        }

        void add(String string) {
            Entry entry = (Entry)this.map.get(string);
            if (entry == null) {
                entry = new Entry();
                this.map.put(string, entry);
            }
            ++entry.useCount;
        }

        void add(TestDescription testDescription) {
            Iterator iterator = testDescription.getParameterKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = testDescription.getParameter(string);
                this.add(string);
                this.add(string2);
            }
        }

        int getSize() {
            return this.map.size();
        }

        int getWrittenSize() {
            return this.writtenSize;
        }

        int getIndex(String string) {
            Entry entry = (Entry)this.map.get(string);
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            return entry.index;
        }

        ZipEntry write(ZipOutputStream zipOutputStream) throws IOException {
            ZipEntry zipEntry = new ZipEntry("strings");
            zipOutputStream.putNextEntry(zipEntry);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            this.write(dataOutputStream);
            dataOutputStream.flush();
            zipOutputStream.closeEntry();
            return zipEntry;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            Vector<String> vector = new Vector<String>(this.map.size());
            vector.addElement("");
            int n = 1;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Entry entry2 = (Entry)entry.getValue();
                if (!entry2.isFrequent()) continue;
                entry2.index = n++;
                vector.addElement(string);
            }
            BinaryTestWriter.writeInt(dataOutputStream, vector.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                dataOutputStream.writeUTF((String)vector.elementAt(n2));
                ++n2;
            }
            this.writtenSize = n;
        }

        void writeRef(String string, DataOutputStream dataOutputStream) throws IOException {
            Entry entry = (Entry)this.map.get(string);
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            if (entry.isFrequent()) {
                BinaryTestWriter.writeInt(dataOutputStream, entry.index);
            } else {
                BinaryTestWriter.writeInt(dataOutputStream, 0);
                dataOutputStream.writeUTF(string);
            }
        }

        static class Entry {
            int useCount = 0;
            int index = 0;

            Entry() {
            }

            boolean isFrequent() {
                return this.useCount > 1;
            }
        }
    }

    public class Fault
    extends Exception {
        Fault(String string) {
            super(string);
        }
    }

    public class BadArgs
    extends Exception {
        BadArgs(String string) {
            super(string);
        }
    }
}

