/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TT_Renderer;
import com.sun.javatest.exec.TestPanel;
import com.sun.javatest.exec.TestTree;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.Deck;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class TestTreePanel
extends JSplitPane {
    private UIFactory uif;
    private Harness harness;
    private FilterSelectionHandler filterHandler;
    private ExecModel execModel;
    private JComponent parent;
    private Thread bgThread;
    private boolean disposed;
    private PanelModel pm;
    private TestTree tree;
    private TT_Renderer treeRend;
    private TestPanel testPanel;
    private BranchPanel brPanel;
    private JPopupMenu popup;
    private TreePath lastPopupPath;
    private JMenuItem refreshMI;
    private JMenuItem purgeMI;
    private JMenuItem runMI;
    private String activeTest;
    private TestTreeModel treeModel;
    private Deck deck;
    private JPanel deckPanel;
    private JTextField titleField;
    private Listener listener;
    private TestSuite lastTs;
    private Parameters params;
    private static final int WAIT_DIALOG_DELAY = 3000;
    protected static boolean debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$exec$TestTreePanel == null ? (class$com$sun$javatest$exec$TestTreePanel = TestTreePanel.class$("com.sun.javatest.exec.TestTreePanel")) : class$com$sun$javatest$exec$TestTreePanel).getName());
    static /* synthetic */ Class class$com$sun$javatest$exec$TestTreePanel;

    public TestTreePanel(UIFactory uIFactory, Harness harness, ExecModel execModel, FilterSelectionHandler filterSelectionHandler, JComponent jComponent) {
        this.uif = uIFactory;
        this.harness = harness;
        this.filterHandler = filterSelectionHandler;
        this.execModel = execModel;
        this.parent = jComponent;
        this.pm = new PanelModel();
        this.harness.addObserver(this.pm);
        this.initGUI();
        uIFactory.setAccessibleInfo(this, "treep");
    }

    public TestResultTable getTestResultTable() {
        return this.treeModel.getTestResultTable();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public TreePanelModel getTreePanelModel() {
        return this.pm;
    }

    public void dispose() {
        this.disposed = true;
        if (this.treeModel != null) {
            this.treeModel.dispose();
            this.treeModel = null;
        }
        if (this.brPanel != null) {
            this.brPanel.dispose();
            this.brPanel = null;
        }
        if (this.bgThread != null && this.bgThread.isAlive()) {
            this.bgThread.interrupt();
        }
        this.popup = null;
        this.lastPopupPath = null;
    }

    void setParameters(Parameters parameters) {
        if (parameters == null) {
            return;
        }
        TreePath[] treePathArray = null;
        this.params = parameters;
        if (this.tree != null) {
            treePathArray = this.tree.snapshotOpenPaths();
        }
        if (this.treeModel != null) {
            this.treeModel.setParameters(this.params);
        }
        if (this.tree != null) {
            this.tree.setParameters(this.params);
            this.treeRend.setParameters(this.params);
        }
        if (this.testPanel != null) {
            this.testPanel.setTestSuite(this.params.getTestSuite());
        }
        if (this.brPanel != null) {
            this.brPanel.setParameters(this.params);
        }
        TestResultTable testResultTable = this.getTestResultTable();
        if (treePathArray != null && testResultTable != null) {
            MenuElement[] menuElementArray;
            Object[] objectArray = new TreePath[]{};
            int n = 0;
            while (n < treePathArray.length) {
                Object[] objectArray2;
                Object object;
                String string;
                menuElementArray = treePathArray[n].getLastPathComponent();
                if (menuElementArray instanceof TestResult) {
                    string = ((TestResult)menuElementArray).getTestName();
                    object = testResultTable.lookup(TestResult.getWorkRelativePath(string));
                    if (object != null) {
                        objectArray2 = TestResultTable.getObjectPath((TestResult)object);
                        Object[] objectArray3 = new Object[objectArray2.length + 1];
                        System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray2.length);
                        objectArray3[objectArray3.length - 1] = object;
                        objectArray = (TreePath[])DynamicArray.append(objectArray, new TreePath(objectArray3));
                    }
                } else {
                    string = TestResultTable.getRootRelativePath((TestResultTable.TreeNode)menuElementArray);
                    object = TestResultTable.findNode(testResultTable.getRoot(), string);
                    objectArray2 = TestResultTable.getObjectPath((TestResultTable.TreeNode)object);
                    if (objectArray2 != null && objectArray2.length > 0) {
                        objectArray = (TreePath[])DynamicArray.append(objectArray, new TreePath(objectArray2));
                    }
                }
                ++n;
            }
            TestTreePanel.restore((TreePath[])objectArray, this.tree);
            if (this.popup != null && (menuElementArray = this.popup.getSubElements()) != null) {
                boolean bl = parameters.getWorkDirectory() != null;
                this.purgeMI.setEnabled(bl);
                this.refreshMI.setEnabled(parameters.getTestSuite() != null);
                this.runMI.setEnabled(bl);
            }
        }
    }

    void save(Map map) {
    }

    private void setPopupItemsEnabled(boolean bl) {
        if (bl) {
            boolean bl2 = this.params != null && this.params.getWorkDirectory() != null;
            this.purgeMI.setEnabled(bl2);
            this.refreshMI.setEnabled(this.params != null && this.params.getTestSuite() != null);
            this.runMI.setEnabled(bl2);
        } else {
            this.purgeMI.setEnabled(false);
            this.refreshMI.setEnabled(false);
            this.runMI.setEnabled(false);
        }
    }

    private void clearNode(TreePath treePath) {
        int n;
        Object object;
        final WorkDirectory workDirectory = this.execModel.getWorkDirectory();
        boolean bl = false;
        String string = null;
        if (workDirectory == null) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantPurgeNoWd.msg"), this.uif.getI18NString("treep.cantPurgeNoWd.title"), 2);
            return;
        }
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantPurgeRunning.msg"), this.uif.getI18NString("treep.cantPurgeRunning.title"), 2);
            return;
        }
        if (treePath.getLastPathComponent() instanceof TestResult) {
            object = (TestResult)treePath.getLastPathComponent();
            n = JOptionPane.showConfirmDialog(this.parent, this.uif.getI18NString("treep.purgeTestSure.msg", ((TestResult)object).getTestName()), this.uif.getI18NString("treep.purgeTestSure.title"), 0, 3);
            if (n == 1) {
                return;
            }
            bl = true;
            string = ((TestResult)object).getWorkRelativePath();
        } else {
            object = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            n = 0;
            n = object.isRoot() ? JOptionPane.showConfirmDialog(this.parent, this.uif.getI18NString("treep.purgeRootSure.msg", TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object)), this.uif.getI18NString("treep.purgeRootSure.title"), 0, 3) : JOptionPane.showConfirmDialog(this.parent, this.uif.getI18NString("treep.purgeNodeSure.msg", TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object)), this.uif.getI18NString("treep.purgeNodeSure.title"), 0, 3);
            if (n == 1) {
                return;
            }
            if (object.isRoot()) {
                bl = true;
                string = "";
            } else {
                bl = true;
                string = TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object);
            }
        }
        if (bl) {
            object = this.uif.createWaitDialog("treep.waitPurge", this);
            final String string2 = string;
            this.setPopupItemsEnabled(false);
            final Thread thread = new Thread((JDialog)object){
                private final /* synthetic */ JDialog val$d;
                {
                    this.val$d = jDialog;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block12: {
                        workDirectory.purge(string2);
                        Object var4_1 = null;
                        try {
                            EventQueue.invokeAndWait(new Runnable(this){
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    if (1.access$100(this.this$1).isShowing()) {
                                        1.access$100(this.this$1).hide();
                                    }
                                    TestTreePanel.access$300(1.access$200(this.this$1), true);
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                        break block12;
                        {
                            catch (WorkDirectory.PurgeFault purgeFault) {
                                I18NResourceBundle i18NResourceBundle = TestTreePanel.this.uif.getI18NResourceBundle();
                                workDirectory.log(i18NResourceBundle, "treep.purgeFail.err", purgeFault);
                                Object var4_2 = null;
                                try {
                                    EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (InvocationTargetException invocationTargetException) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_3 = null;
                            try {
                                EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }

                static /* synthetic */ JDialog access$100(1 var0) {
                    return var0.val$d;
                }

                static /* synthetic */ TestTreePanel access$200(1 var0) {
                    return var0.TestTreePanel.this;
                }
            };
            ActionListener actionListener = new ActionListener((JDialog)object){
                private final /* synthetic */ JDialog val$d;
                {
                    this.val$d = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (thread == null) {
                        return;
                    }
                    if (thread.isAlive() && !this.val$d.isVisible()) {
                        this.val$d.show();
                    } else if (!thread.isAlive() && this.val$d.isVisible()) {
                        this.val$d.hide();
                    }
                }
            };
            this.bgThread = thread;
            Timer timer = new Timer(3000, actionListener);
            timer.setRepeats(false);
            timer.start();
            thread.start();
        }
    }

    private void showNodeInfoDialog(TreePath treePath) {
        if (treePath.getLastPathComponent() instanceof TestResultTable.TreeNode) {
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            Debug.println("info for this node not implemented" + treeNode.getName() + " (" + treeNode + ")");
        }
    }

    private void runNode(TreePath treePath) {
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantRunRunning.msg"), this.uif.getI18NString("treep.cantRunRunning.title"), 2);
            return;
        }
        if (treePath.getLastPathComponent() instanceof TestResult) {
            TestResult testResult = (TestResult)treePath.getLastPathComponent();
            String[] stringArray = new String[]{testResult.getTestName()};
            this.execModel.runTests(stringArray);
        } else {
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            String[] stringArray = new String[]{TestResultTable.getRootRelativePath(treeNode)};
            this.execModel.runTests(stringArray);
        }
    }

    private static void restore(final TreePath[] treePathArray, final TestTree testTree) {
        if (treePathArray == null || testTree == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                testTree.restorePaths(treePathArray);
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private void refreshNode(TreePath treePath) {
        int n;
        Object object;
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantRefreshRunning.msg"), this.uif.getI18NString("treep.cantRefreshRunning.title"), 2);
            return;
        }
        final TestResultTable testResultTable = this.treeModel.getTestResultTable();
        boolean bl = false;
        Object object2 = null;
        if (treePath.getLastPathComponent() instanceof TestResult) {
            object = (TestResult)treePath.getLastPathComponent();
            n = JOptionPane.showConfirmDialog(this.parent, this.uif.getI18NString("treep.refreshTestSure.msg", ((TestResult)object).getTestName()), this.uif.getI18NString("treep.refreshTestSure.title"), 0, 3);
            if (n == 1) {
                return;
            }
            bl = true;
            object2 = ((TestResult)object).getTestName();
        } else {
            object = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            n = 1;
            n = object.isRoot() ? JOptionPane.showConfirmDialog(this.parent, this.uif.getI18NString("treep.refreshRootSure.msg"), this.uif.getI18NString("treep.refreshRootSure.title"), 0, 3) : JOptionPane.showConfirmDialog(this.parent, this.uif.getI18NString("treep.refreshNodeSure.msg", TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object)), this.uif.getI18NString("treep.refreshNodeSure.title"), 0, 3);
            if (n == 1) {
                return;
            }
            bl = true;
            object2 = object;
        }
        if (bl) {
            object = this.uif.createWaitDialog("treep.waitRef", this);
            final Object object3 = object2;
            this.setPopupItemsEnabled(false);
            final Thread thread = new Thread((JDialog)object){
                private final /* synthetic */ JDialog val$d;
                {
                    this.val$d = jDialog;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block15: {
                        block13: {
                            if (object3 instanceof String) {
                                testResultTable.refreshIfNeeded((String)object3);
                                break block13;
                            }
                            testResultTable.refreshIfNeeded((TestResultTable.TreeNode)object3);
                        }
                        Object var5_1 = null;
                        try {
                            EventQueue.invokeAndWait(new Runnable(this){
                                private final /* synthetic */ 5 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    if (5.access$500(this.this$1).isShowing()) {
                                        5.access$500(this.this$1).hide();
                                    }
                                    TestTreePanel.access$300(5.access$600(this.this$1), true);
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                        break block15;
                        {
                            catch (TestResultTable.Fault fault) {
                                WorkDirectory workDirectory = TestTreePanel.this.execModel.getWorkDirectory();
                                if (workDirectory != null) {
                                    I18NResourceBundle i18NResourceBundle = TestTreePanel.this.uif.getI18NResourceBundle();
                                    workDirectory.log(i18NResourceBundle, "treep.refFail", new Object[]{object3 instanceof String ? object3 : TestResultTable.getRootRelativePath((TestResultTable.TreeNode)object3), fault.getMessage()});
                                }
                                Object var5_2 = null;
                                try {
                                    EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (InvocationTargetException invocationTargetException) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_3 = null;
                            try {
                                EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }

                static /* synthetic */ JDialog access$500(5 var0) {
                    return var0.val$d;
                }

                static /* synthetic */ TestTreePanel access$600(5 var0) {
                    return var0.TestTreePanel.this;
                }
            };
            ActionListener actionListener = new ActionListener((JDialog)object){
                private final /* synthetic */ JDialog val$d;
                {
                    this.val$d = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (thread == null) {
                        return;
                    }
                    if (thread.isAlive() && !this.val$d.isVisible()) {
                        this.val$d.show();
                    } else if (!thread.isAlive() && this.val$d.isVisible()) {
                        this.val$d.hide();
                    }
                }
            };
            this.bgThread = thread;
            Timer timer = new Timer(3000, actionListener);
            timer.setRepeats(true);
            timer.start();
            thread.start();
        }
    }

    void updateGUI() {
        if (debug) {
            Debug.println("TTP.updateGUI()");
        }
        if (this.disposed) {
            return;
        }
        this.tree.updateGUI();
        this.brPanel.updateGUI();
    }

    private void initGUI() {
        block3: {
            this.setName("testTree");
            this.setOrientation(1);
            this.listener = new Listener();
            this.treeModel = new TestTreeModel(this.params, this.filterHandler, this.uif);
            this.treeRend = new TT_Renderer(this.uif, this.filterHandler, this.pm);
            this.tree = new TestTree(this.uif, this.pm, this.filterHandler, this.treeModel);
            this.tree.setTreeModel(this.treeModel);
            this.tree.setCellRenderer(this.treeRend);
            this.tree.addTreeSelectionListener(this.listener);
            this.tree.addTreeExpansionListener(this.listener);
            this.tree.addMouseListener(this.listener);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.getInputMap(1).put(KeyStroke.getKeyStroke(121, 1, false), "triggerPopup");
            this.tree.getActionMap().put("triggerPopup", new TreePopupAction(this.uif.getI18NResourceBundle(), "treep.popup"));
            this.uif.setAccessibleInfo(this.tree, "treep.tree");
            JPanel jPanel = this.uif.createPanel("tree", new BorderLayout(), false);
            jPanel.add((Component)this.uif.createScrollPane(this.tree, 20, 30), "Center");
            jPanel.add((Component)this.filterHandler.getFilterSelector(), "South");
            this.setLeftComponent(jPanel);
            this.deck = new Deck(){

                public Dimension getPreferredSize() {
                    int n = TestTreePanel.this.uif.getDotsPerInch();
                    return new Dimension(6 * n, 4 * n);
                }
            };
            this.testPanel = new TestPanel(this.uif, this.harness);
            this.brPanel = new BranchPanel(this.uif, this.pm, this.harness, this.filterHandler, this.treeModel);
            this.deck.add(this.testPanel);
            this.deck.add(this.brPanel);
            this.deckPanel = this.uif.createPanel("main", false);
            this.deckPanel.setLayout(new BorderLayout());
            this.deckPanel.add((Component)this.deck, "Center");
            this.titleField = this.uif.createOutputField("treep.title");
            this.titleField.setBorder(null);
            this.titleField.setText(this.uif.getI18NString("treep.title.noSelection.txt"));
            this.titleField.setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
            this.titleField.setForeground(MetalLookAndFeel.getWindowBackground());
            FontUIResource fontUIResource = MetalLookAndFeel.getSystemTextFont();
            this.titleField.setFont(new Font(fontUIResource.getName(), fontUIResource.getStyle(), fontUIResource.getSize() * 5 / 4));
            this.titleField.setEnabled(true);
            this.titleField.setEditable(false);
            this.deckPanel.add((Component)this.titleField, "North");
            this.setRightComponent(this.deckPanel);
            this.testPanel.setVisible(false);
            this.brPanel.setVisible(false);
            this.deck.setVisible(true);
            this.deckPanel.setVisible(true);
            this.setDividerLocation(200);
            if (this.tree.getSelectionPath() == null) {
                TreeModel treeModel = this.tree.getModel();
                try {
                    TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treeModel.getRoot();
                    this.tree.setRootVisible(true);
                    EventQueue.invokeLater(new Selector(treeNode, new TreePath(treeNode)));
                }
                catch (ClassCastException classCastException) {
                    if (!debug) break block3;
                    classCastException.printStackTrace(Debug.getWriter());
                }
            }
        }
        this.popup = this.uif.createPopupMenu("treep.popup.mnu");
        this.runMI = this.uif.createMenuItem("treep.popup", "run", this.listener);
        this.popup.add(this.runMI);
        this.popup.addSeparator();
        this.refreshMI = this.uif.createMenuItem("treep.popup", "refresh", this.listener);
        this.popup.add(this.refreshMI);
        this.purgeMI = this.uif.createMenuItem("treep.popup", "clear", this.listener);
        this.popup.add(this.purgeMI);
        this.runMI.setEnabled(false);
        this.refreshMI.setEnabled(false);
        this.purgeMI.setEnabled(false);
    }

    private void selectTest(TestResult testResult, TreePath treePath) {
        if (debug) {
            Debug.println("TTP showing: " + testResult);
            Debug.println("   -> path provided is " + treePath.getPathCount() + " components long.");
        }
        if (this.disposed) {
            if (debug) {
                Debug.println("TTP - selectTest() not running, panel is disposed.");
            }
            return;
        }
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display a leaf. No action.");
            }
            return;
        }
        this.brPanel.setVisible(false);
        this.deck.show(this.testPanel);
        if (!this.tree.isPathSelected(treePath)) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(treePath);
        }
        if (!this.tree.isVisible(treePath)) {
            this.tree.scrollPathToVisible(treePath);
        }
        if (testResult != this.testPanel.getTest()) {
            this.testPanel.setTest(testResult);
            this.activeTest = testResult.getTestName();
        }
        this.titleField.setText(this.uif.getI18NString("treep.test", testResult.getTestName()));
        this.testPanel.setVisible(true);
        this.tree.repaint();
        this.deckPanel.repaint();
    }

    private void selectBranch(TestResultTable.TreeNode treeNode, TreePath treePath) {
        if (debug) {
            Debug.println("TTP showing: " + treeNode.getName());
            Debug.println("   -> " + treeNode);
            Debug.println("   -> path provided is " + treePath.getPathCount() + " components long.");
        }
        if (this.disposed) {
            if (debug) {
                Debug.println("TTP - selectTest() not running, panel is disposed.");
            }
            return;
        }
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display a branch. No action.");
            }
            return;
        }
        if (this.deck.getCurrentCard() != this.brPanel) {
            this.deck.show(this.brPanel);
            this.testPanel.setVisible(false);
            this.activeTest = null;
        }
        if (!this.tree.isPathSelected(treePath)) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(treePath);
        }
        if (!this.tree.isVisible(treePath)) {
            this.tree.scrollPathToVisible(treePath);
        }
        if (treeNode != this.brPanel.getNode()) {
            this.brPanel.setNode(treeNode);
            this.treeModel.setActiveNode(treeNode);
        }
        if (treeNode.isRoot()) {
            TestSuite testSuite = this.params.getTestSuite();
            String string = testSuite.getName();
            if (string != null) {
                this.titleField.setText(this.uif.getI18NString("treep.ts", string));
            } else {
                this.titleField.setText(this.uif.getI18NString("treep.ts", testSuite.getPath()));
            }
        } else {
            String string = TestResultTable.getRootRelativePath(treeNode);
            this.titleField.setText(this.uif.getI18NString("treep.node", string));
        }
        if (!this.brPanel.isVisible()) {
            this.brPanel.setVisible(true);
        }
        this.deckPanel.repaint();
        this.tree.repaint();
    }

    private boolean isPopulated() {
        return this.params != null && this.params.getTestSuite() != null;
    }

    static /* synthetic */ void access$300(TestTreePanel testTreePanel, boolean bl) {
        testTreePanel.setPopupItemsEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PanelModel
    implements TreePanelModel,
    Harness.Observer {
        private Hashtable runningTests;
        private Hashtable activeNodes;
        private Integer ONE = new Integer(1);

        PanelModel() {
            this.runningTests = new Hashtable();
            this.activeNodes = new Hashtable();
        }

        public void nodeSelected(Object object, TreePath treePath) {
        }

        public void testSelected(TestResult testResult, TreePath treePath) {
        }

        public void nodeUnSelected(Object object, TreePath treePath) {
        }

        public void testUnSelected(TestResult testResult, TreePath treePath) {
        }

        public void showNode(Object object, TreePath treePath) {
            TestTreePanel.this.selectBranch((TestResultTable.TreeNode)object, treePath);
        }

        public void showNode(String string) {
            TestResultTable testResultTable = this.getTestResultTable();
            if (testResultTable == null) {
                return;
            }
            TestResultTable.TreeNode treeNode = TestResultTable.findNode(testResultTable.getRoot(), string);
            if (treeNode != null) {
                TestTreePanel.this.selectBranch(treeNode, new TreePath(TestResultTable.getObjectPath(treeNode)));
            }
        }

        public void showTest(TestResult testResult, TreePath treePath) {
            TestTreePanel.this.selectTest(testResult, treePath);
        }

        public void showTest(TestResult testResult) {
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult);
            Object[] objectArray = new Object[treeNodeArray.length + 1];
            System.arraycopy(treeNodeArray, 0, objectArray, 0, treeNodeArray.length);
            objectArray[objectArray.length - 1] = testResult;
            this.showTest(testResult, new TreePath(objectArray));
        }

        public void showTest(String string) {
            TestResultTable testResultTable = this.getTestResultTable();
            if (testResultTable == null) {
                return;
            }
            TestResult testResult = testResultTable.lookup(TestResult.getWorkRelativePath(string));
            if (testResult != null) {
                this.showTest(testResult);
            }
        }

        public void hideNode(Object object, TreePath treePath) {
        }

        public void hideTest(TestResult testResult, TreePath treePath) {
        }

        public TestResultTable getTestResultTable() {
            return TestTreePanel.this.treeModel.getTestResultTable();
        }

        public String getSelectedTest() {
            return TestTreePanel.this.activeTest;
        }

        public boolean isActive(TestResult testResult) {
            return this.runningTests.containsKey(testResult.getTestName());
        }

        public boolean isActive(TestResultTable.TreeNode treeNode) {
            return this.activeNodes.containsKey(treeNode);
        }

        public void startingTestRun(Parameters parameters) {
        }

        public void startingTest(TestResult testResult) {
            if (TestTreePanel.this.treeModel == null) {
                return;
            }
            this.runningTests.put(testResult.getTestName(), testResult);
            TestResult testResult2 = TestTreePanel.this.treeModel.getTestResultTable().lookup(testResult.getWorkRelativePath());
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult2);
            int n = 0;
            while (n < treeNodeArray.length) {
                Object v = this.activeNodes.get(treeNodeArray[n]);
                if (v == null) {
                    this.activeNodes.put(treeNodeArray[n], this.ONE);
                } else {
                    this.activeNodes.put(treeNodeArray[n], new Integer(1 + (Integer)v));
                }
                ++n;
            }
            TestTreePanel.this.tree.repaint();
        }

        public void finishedTest(TestResult testResult) {
            if (TestTreePanel.this.treeModel == null) {
                return;
            }
            this.runningTests.remove(testResult.getTestName());
            TestResult testResult2 = TestTreePanel.this.treeModel.getTestResultTable().lookup(testResult.getWorkRelativePath());
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult2);
            if (testResult.getTestName().equals(TestTreePanel.this.activeTest)) {
                Object[] objectArray = new Object[treeNodeArray.length + 1];
                System.arraycopy(treeNodeArray, 0, objectArray, 0, treeNodeArray.length);
                objectArray[objectArray.length - 1] = testResult;
                TestTreePanel.this.selectTest(testResult, new TreePath(objectArray));
            }
            if (treeNodeArray != null) {
                int n = 0;
                while (n < treeNodeArray.length) {
                    Object v = this.activeNodes.get(treeNodeArray[n]);
                    if (v != null) {
                        if (v == this.ONE) {
                            this.activeNodes.remove(treeNodeArray[n]);
                        } else {
                            Integer n2;
                            int n3 = (Integer)v;
                            TestResultTable.TreeNode treeNode = treeNodeArray[n];
                            if (n3 == 2) {
                                n2 = this.ONE;
                            } else {
                                Integer n4 = new Integer(--n3);
                                n2 = n4;
                            }
                            this.activeNodes.put(treeNode, n2);
                        }
                    }
                    ++n;
                }
            }
            TestTreePanel.this.tree.repaint();
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
            this.runningTests.clear();
            this.activeNodes.clear();
            TestTreePanel.this.tree.repaint();
        }

        public void error(String string) {
        }
    }

    private class TreePopupAction
    extends AbstractAction {
        private String name;
        private String desc;

        TreePopupAction(I18NResourceBundle i18NResourceBundle, String string) {
            this.desc = i18NResourceBundle.getString(string + ".desc");
            this.name = i18NResourceBundle.getString(string + ".act");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TestTreePanel.this.disposed) {
                return;
            }
            TestTreePanel.this.lastPopupPath = TestTreePanel.this.tree.getSelectionPath();
            Rectangle rectangle = TestTreePanel.this.tree.getPathBounds(TestTreePanel.this.lastPopupPath);
            if (rectangle == null) {
                return;
            }
            TestTreePanel.this.popup.show(TestTreePanel.this.tree, rectangle.x + (int)rectangle.getWidth(), rectangle.y + (int)rectangle.getHeight());
        }

        public Object getValue(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (string.equals("Name")) {
                return this.name;
            }
            if (string.equals("ShortDescription")) {
                return this.desc;
            }
            return null;
        }
    }

    class Selector
    implements Runnable {
        private TreePath tp;
        private TestResult tr;
        private TestResultTable.TreeNode tn;

        Selector(TestResult testResult, TreePath treePath) {
            this.tr = testResult;
            this.tp = treePath;
        }

        Selector(TestResultTable.TreeNode treeNode, TreePath treePath) {
            this.tn = treeNode;
            this.tp = treePath;
        }

        public void run() {
            if (this.tr != null) {
                TestTreePanel.this.selectTest(this.tr, this.tp);
            } else {
                TestTreePanel.this.selectBranch(this.tn, this.tp);
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    TreeSelectionListener,
    TreeExpansionListener {
        private int lastX;
        private int lastY;

        private Listener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.getSource() == TestTreePanel.this.tree && treeSelectionEvent.isAddedPath()) {
                TreePath treePath = treeSelectionEvent.getPath();
                TestTree testTree = (TestTree)treeSelectionEvent.getSource();
                this.dispatchSelection(testTree, treePath);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TestResult[] testResultArray;
            if (TestTreePanel.this.disposed) {
                return;
            }
            TreePath treePath = treeExpansionEvent.getPath();
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            TestResultTable.TreeNode[] treeNodeArray = treeNode.getTreeNodes();
            if (treeNodeArray != null) {
                int n = 0;
                while (n < treeNodeArray.length) {
                    TestTreePanel.this.treeModel.removeRelevantNode(treeNodeArray[n]);
                    ++n;
                }
            }
            if ((testResultArray = treeNode.getTestResults()) != null) {
                int n = 0;
                while (n < testResultArray.length) {
                    TestTreePanel.this.treeModel.removeRelevantTest(testResultArray[n]);
                    ++n;
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TestResult[] testResultArray;
            if (TestTreePanel.this.disposed) {
                return;
            }
            TreePath treePath = treeExpansionEvent.getPath();
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)treePath.getLastPathComponent();
            TestResultTable.TreeNode[] treeNodeArray = treeNode.getTreeNodes();
            if (treeNodeArray != null) {
                int n = 0;
                while (n < treeNodeArray.length) {
                    TestTreePanel.this.treeModel.addRelevantNode(treeNodeArray[n]);
                    ++n;
                }
            }
            if ((testResultArray = treeNode.getTestResults()) != null) {
                int n = 0;
                while (n < testResultArray.length) {
                    TestTreePanel.this.treeModel.addRelevantTest(testResultArray[n]);
                    ++n;
                }
            }
        }

        private void dispatchSelection(TestTree testTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof TestResult) {
                TestTreePanel.this.selectTest((TestResult)object, treePath);
            } else if (object instanceof TestResultTable.TreeNode) {
                TestTreePanel.this.selectBranch((TestResultTable.TreeNode)object, treePath);
            } else if (debug) {
                Debug.println("Unknown node click target in TestTreePanel: ");
                Debug.println("   => " + object);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getComponent() == TestTreePanel.this.tree) {
                this.lastX = mouseEvent.getX();
                this.lastY = mouseEvent.getY();
                TreePath treePath = TestTreePanel.this.tree.getPathForLocation(this.lastX, this.lastY);
                if (treePath != null) {
                    TestTreePanel.this.lastPopupPath = treePath;
                    TestTreePanel.this.popup.show(mouseEvent.getComponent(), this.lastX, this.lastY);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("clear")) {
                TestTreePanel.this.clearNode(TestTreePanel.this.lastPopupPath);
            } else if (actionEvent.getActionCommand().equals("info")) {
                TestTreePanel.this.showNodeInfoDialog(TestTreePanel.this.lastPopupPath);
            } else if (actionEvent.getActionCommand().equals("run")) {
                TestTreePanel.this.runNode(TestTreePanel.this.lastPopupPath);
            } else if (actionEvent.getActionCommand().equals("refresh")) {
                TestTreePanel.this.refreshNode(TestTreePanel.this.lastPopupPath);
            }
        }
    }
}

