/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import java.awt.EventQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class TestTreeModel
implements TreeModel,
TestResultTable.TreeObserver {
    private UIFactory uif;
    private TestResultTable trt;
    private Parameters params;
    private FilterSelectionHandler filterHandler;
    private TestFilter lastFilter;
    private TreeModelListener[] treeModelListeners = new TreeModelListener[0];
    private boolean statsForwarded;
    private boolean disposed;
    private CacheWorker cacheWorker;
    private FilterWatcher watcher;
    private Set relevantNodes;
    private Set relevantTests;
    protected Hashtable cache;
    protected LinkedList cacheQueue;
    protected LinkedList suspendedQueue;
    protected final Object htLock = new Object();
    private static final int CACHE_THREAD_PRI = 1;
    private static final int CACHE_NOTI_THR_PRI = 1;
    protected static int debug = Debug.getInt(class$com$sun$javatest$exec$TestTreeModel == null ? (class$com$sun$javatest$exec$TestTreeModel = TestTreeModel.class$("com.sun.javatest.exec.TestTreeModel")) : class$com$sun$javatest$exec$TestTreeModel);
    static /* synthetic */ Class class$com$sun$javatest$exec$TestTreeModel;

    TestTreeModel(Parameters parameters, FilterSelectionHandler filterSelectionHandler, UIFactory uIFactory) {
        this.filterHandler = filterSelectionHandler;
        this.uif = uIFactory;
        this.cache = new Hashtable();
        this.cacheQueue = new LinkedList();
        this.suspendedQueue = new LinkedList();
        this.cacheWorker = new CacheWorker();
        this.cacheWorker.setPriority(2);
        this.cacheWorker.start();
        this.setParameters(parameters);
        this.watcher = new FilterWatcher();
        filterSelectionHandler.addObserver(this.watcher);
        this.lastFilter = filterSelectionHandler.getActiveFilter();
    }

    synchronized void dispose() {
        this.disposed = true;
        if (this.trt != null) {
            this.trt.removeObserver(this);
            this.trt = null;
        }
        this.filterHandler.removeObserver(this.watcher);
        if (this.cacheWorker != null) {
            this.cacheWorker.interrupt();
            this.cacheWorker = null;
        }
        this.params = null;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners = (TreeModelListener[])DynamicArray.append(this.treeModelListeners, treeModelListener);
    }

    public Object getChild(Object object, int n) {
        if (object instanceof TestResultTable.TreeNode) {
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
            return treeNode.getChild(n);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof TestResultTable.TreeNode) {
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
            return treeNode.getChildCount();
        }
        if (object instanceof TestResult) {
            return 0;
        }
        return -1;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (!(object instanceof TestResultTable.TreeNode)) {
            throw new IllegalArgumentException(this.uif.getI18NString("tree.badParent"));
        }
        TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
        return treeNode.getIndex(object2);
    }

    public Object getRoot() {
        if (this.disposed) {
            if (debug > 0) {
                Debug.println("TTM - getRoot() ignored, model has been disposed.");
            }
            return null;
        }
        return this.trt.getRoot();
    }

    public boolean isLeaf(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof TestResultTable.TreeNode) {
            return false;
        }
        if (object instanceof TestResult) {
            return true;
        }
        throw new IllegalArgumentException(this.uif.getI18NString("tree.badType"));
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners = (TreeModelListener[])DynamicArray.remove((Object[])this.treeModelListeners, treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.err.println(this.getClass().getName() + ": VFPC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void nodeInserted(TestResultTable.TreeNode[] treeNodeArray, Object object, int n) {
        int[] nArray = new int[]{n};
        Object[] objectArray = new Object[]{object};
        if (object instanceof TestResultTable.TreeNode) {
            if (!this.relevantNodes.contains(treeNodeArray[treeNodeArray.length - 1])) {
                return;
            }
            if (debug > 0) {
                Debug.println("TTM - Node " + object + " inserted, path len=" + treeNodeArray.length);
            }
            TreeModelEvent treeModelEvent = treeNodeArray == null || treeNodeArray.length == 0 ? new TreeModelEvent((Object)this, new TreePath(object)) : new TreeModelEvent((Object)this, treeNodeArray, nArray, objectArray);
            this.notifyInserted(treeModelEvent);
        } else {
            TestResult testResult = (TestResult)object;
            if (this.relevantNodes.contains(treeNodeArray[treeNodeArray.length - 1])) {
                if (debug > 0) {
                    Debug.println("TTM - Node " + object + " inserted, path len=" + treeNodeArray.length);
                    Debug.println("   -> inserting " + testResult.getTestName());
                    Debug.println("   -> mutable " + testResult.isMutable());
                    Debug.println("   -> status " + testResult.getStatus().getType());
                    Debug.println("   -> into " + treeNodeArray[0].getEnclosingTable());
                }
                this.notifyInserted(this.makeEvent(treeNodeArray, object, n));
            }
            int n2 = treeNodeArray.length - 1;
            while (n2 >= 0) {
                boolean bl;
                TT_NodeCache tT_NodeCache = null;
                Object object2 = this.htLock;
                synchronized (object2) {
                    tT_NodeCache = (TT_NodeCache)this.cache.get(treeNodeArray[n2]);
                }
                if (tT_NodeCache != null && (bl = tT_NodeCache.add(treeNodeArray, (TestResult)object, n)) && this.relevantNodes.contains(treeNodeArray[n2])) {
                    TreeModelEvent treeModelEvent = treeNodeArray[n2].isRoot() ? new TreeModelEvent((Object)this, new TreePath(treeNodeArray[n2])) : this.makeEvent(TestResultTable.getObjectPath(treeNodeArray[n2 - 1]), treeNodeArray[n2], treeNodeArray[n2 - 1].getIndex(treeNodeArray[n2]));
                    this.notifyChanged(treeModelEvent);
                }
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void nodeChanged(TestResultTable.TreeNode[] treeNodeArray, Object object, int n, Object object2) {
        if (object instanceof TestResultTable.TreeNode) {
            if (this.relevantNodes.contains(treeNodeArray[treeNodeArray.length - 1])) {
                if (debug > 0) {
                    Debug.println("TTM - nodeChanged: " + object);
                }
                this.notifyChanged(this.makeEvent(treeNodeArray, object, n));
                this.notifyStructure(new TreeModelEvent((Object)this, treeNodeArray, null, null));
            }
        } else {
            if (this.relevantTests.contains(object2) && object2 != object) {
                if (debug > 0) {
                    Debug.println("TTM - nodeChanged: " + object);
                }
                this.relevantTests.remove(object2);
                this.relevantTests.add(object);
            }
            int n2 = treeNodeArray.length - 1;
            while (n2 >= 0) {
                TT_NodeCache tT_NodeCache = null;
                Object object3 = this.htLock;
                synchronized (object3) {
                    tT_NodeCache = (TT_NodeCache)this.cache.get(treeNodeArray[n2]);
                }
                if (tT_NodeCache != null) {
                    boolean bl = tT_NodeCache.replace(treeNodeArray, (TestResult)object, n, (TestResult)object2);
                    if (!bl || this.relevantNodes.contains(treeNodeArray[n2])) {
                        // empty if block
                    }
                    if (this.relevantTests.contains((TestResult)object)) {
                        this.notifyChanged(this.makeEvent(treeNodeArray, object, n));
                    }
                }
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void nodeRemoved(TestResultTable.TreeNode[] treeNodeArray, Object object, int n) {
        if (object instanceof TestResultTable.TreeNode) {
            if (this.relevantNodes.contains(treeNodeArray[treeNodeArray.length - 1])) {
                if (debug > 0) {
                    Debug.println("TTM - Node " + object + " removed, path len=" + treeNodeArray.length);
                }
                this.notifyRemoved(this.makeEvent(treeNodeArray, object, n));
            }
        } else {
            TestResult testResult = (TestResult)object;
            this.relevantTests.remove(testResult);
            if (this.relevantNodes.contains(treeNodeArray[treeNodeArray.length - 1])) {
                if (debug > 0) {
                    Debug.println("TTM - Node " + object + " removed, path len=" + treeNodeArray.length);
                    Debug.println("    -> Removing " + testResult.getTestName());
                }
                this.notifyRemoved(this.makeEvent(treeNodeArray, object, n));
            }
            int n2 = treeNodeArray.length - 1;
            while (n2 >= 0) {
                boolean bl;
                TT_NodeCache tT_NodeCache = null;
                Object object2 = this.htLock;
                synchronized (object2) {
                    tT_NodeCache = (TT_NodeCache)this.cache.get(treeNodeArray[n2]);
                }
                if (tT_NodeCache == null || !(bl = tT_NodeCache.remove(treeNodeArray, (TestResult)object, n)) || this.relevantNodes.contains(treeNodeArray[n2])) {
                    // empty if block
                }
                --n2;
            }
        }
    }

    void addRelevantNode(TestResultTable.TreeNode treeNode) {
        this.relevantNodes.add(treeNode);
    }

    void removeRelevantNode(TestResultTable.TreeNode treeNode) {
        this.relevantNodes.remove(treeNode);
    }

    void addRelevantTest(TestResult testResult) {
        this.relevantTests.add(testResult);
    }

    void removeRelevantTest(TestResult testResult) {
        if (this.relevantTests != null && testResult != null) {
            this.relevantTests.remove(testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActiveNode(TestResultTable.TreeNode treeNode) {
        TT_NodeCache tT_NodeCache = null;
        Object object = this.htLock;
        synchronized (object) {
            tT_NodeCache = (TT_NodeCache)this.cache.get(treeNode);
        }
        if (tT_NodeCache != null) {
            this.cacheWorker.requestActiveNode(tT_NodeCache);
        }
    }

    private TreeModelEvent makeEvent(Object[] objectArray, Object object, int n) {
        int[] nArray = new int[]{n};
        Object[] objectArray2 = new Object[]{object};
        if (debug > 1) {
            Debug.println("TTM Broadcasing " + object + " change message...");
            Debug.println("   -> Path len=" + objectArray.length);
            Debug.println("   -> Index = " + n);
            Debug.println("   -> TRT = " + this.trt);
        }
        return new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
    }

    void setParameters(Parameters parameters) {
        if (parameters != null) {
            this.params = parameters;
            this.init();
        } else {
            TestResultTable testResultTable = new TestResultTable();
            this.setTestResultTable(testResultTable);
            if (debug > 0) {
                Debug.println("TTM - dummy TRT, root = " + testResultTable.getRoot());
            }
        }
    }

    private synchronized void init() {
        if (this.params == null) {
            return;
        }
        WorkDirectory workDirectory = this.params.getWorkDirectory();
        TestSuite testSuite = this.params.getTestSuite();
        if (workDirectory != null) {
            if (debug > 0) {
                Debug.println("TTM - initializing with workdir");
            }
            TestResultTable testResultTable = workDirectory.getTestResultTable();
            this.setTestResultTable(testResultTable);
        } else if (testSuite != null) {
            if (this.trt.getTestFinder() == null) {
                this.trt.setTestFinder(testSuite.getTestFinder());
                this.setTestResultTable(this.trt);
                if (debug > 0) {
                    Debug.println("TTM - params set, no WD; setting finder on temp. TRT");
                }
            } else if (debug > 0) {
                Debug.println("TTM - temp. TRT already has finder");
            }
        } else if (debug > 0) {
            Debug.println("TTM - params set, no WD or TS");
        }
    }

    private void setTestResultTable(TestResultTable testResultTable) {
        TestResult[] testResultArray;
        if (TestTreeModel.isCompatible(this.trt, testResultTable)) {
            this.swapTables(testResultTable);
        } else {
            if (this.trt != null) {
                this.trt.removeObserver(this);
            }
            this.trt = testResultTable;
            this.trt.addObserver(this);
        }
        this.relevantNodes = Collections.synchronizedSet(new HashSet());
        this.relevantTests = Collections.synchronizedSet(new HashSet());
        this.addRelevantNode(this.trt.getRoot());
        TestResultTable.TreeNode[] treeNodeArray = this.trt.getRoot().getTreeNodes();
        if (treeNodeArray != null) {
            int n = 0;
            while (n < treeNodeArray.length) {
                this.addRelevantNode(treeNodeArray[n]);
                ++n;
            }
        }
        if ((testResultArray = this.trt.getRoot().getTestResults()) != null) {
            int n = 0;
            while (n < testResultArray.length) {
                this.addRelevantTest(testResultArray[n]);
                ++n;
            }
        }
        this.notifyFullStructure();
        if (debug > 0) {
            Debug.println("TTM - Model watching " + this.trt);
            if (this.trt.getWorkDir() != null) {
                Debug.println("   -> Workdir=" + this.trt.getWorkDir());
                Debug.println("   -> Workdir path=" + this.trt.getWorkDir().getPath());
                Debug.println("   -> root = " + this.trt.getRoot());
            }
        }
    }

    static boolean isCompatible(TestResultTable testResultTable, TestResultTable testResultTable2) {
        if (testResultTable == null || testResultTable2 == null || testResultTable.getTestSuiteRoot() == null || testResultTable2.getTestSuiteRoot() == null || testResultTable.getTestFinder() == null || testResultTable2.getTestFinder() == null) {
            if (debug > 1) {
                Debug.println("TTM - isCompatible() failed because one or both TRTs are incomplete.");
                if (testResultTable != null && testResultTable2 != null) {
                    Debug.println("t1 root = " + testResultTable.getTestSuiteRoot());
                    Debug.println("t2 root = " + testResultTable2.getTestSuiteRoot());
                    Debug.println("t1 finder= " + testResultTable.getTestFinder());
                    Debug.println("t2 finder= " + testResultTable2.getTestFinder());
                }
            }
            return false;
        }
        if (!testResultTable.getTestSuiteRoot().getPath().equals(testResultTable2.getTestSuiteRoot().getPath())) {
            if (debug > 1) {
                Debug.println("TTM - isCompatible() failed because testsuite paths differ.");
            }
            return false;
        }
        if (testResultTable.getTestFinder() != testResultTable2.getTestFinder()) {
            if (debug > 1) {
                Debug.println("TTM - isCompatible() failed because TestFinders differ.");
            }
            return false;
        }
        return true;
    }

    TestResultTable getTestResultTable() {
        return this.trt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TT_NodeCache getNodeInfo(TestResultTable.TreeNode treeNode, boolean bl) {
        TT_NodeCache tT_NodeCache = null;
        boolean bl2 = false;
        TestFilter testFilter = this.filterHandler.getActiveFilter();
        Object object = this.htLock;
        synchronized (object) {
            int n;
            tT_NodeCache = (TT_NodeCache)this.cache.get(treeNode);
            if (tT_NodeCache == null) {
                tT_NodeCache = new TT_NodeCache(treeNode, testFilter);
                this.cache.put(treeNode, tT_NodeCache);
                if (!bl) {
                    this.cacheQueue.addFirst(tT_NodeCache);
                }
                bl2 = true;
            } else if (bl && (n = this.cacheQueue.indexOf(tT_NodeCache)) >= 0) {
                this.cacheQueue.remove(n);
            }
        }
        if (bl) {
            this.cacheWorker.requestActiveNode(tT_NodeCache);
            bl2 = true;
        }
        if (!this.statsForwarded && treeNode.isRoot() && tT_NodeCache.isComplete()) {
            WorkDirectory workDirectory;
            int[] nArray = tT_NodeCache.getStats();
            int n = 0;
            int n2 = 0;
            while (n2 < nArray.length) {
                n += nArray[n2];
                ++n2;
            }
            n += tT_NodeCache.getRejectCount();
            if (this.params != null && (workDirectory = this.params.getWorkDirectory()) != null) {
                workDirectory.setTestSuiteTestCount(n);
                this.statsForwarded = true;
            }
        }
        if (bl2) {
            CacheWorker cacheWorker = this.cacheWorker;
            synchronized (cacheWorker) {
                this.cacheWorker.notify();
            }
        }
        return tT_NodeCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateNodeInfo(TestResultTable.TreeNode[] treeNodeArray) {
        Object object = this.htLock;
        synchronized (object) {
            int n = 0;
            while (n < treeNodeArray.length) {
                TT_NodeCache tT_NodeCache = (TT_NodeCache)this.cache.get(treeNodeArray[n]);
                if (tT_NodeCache != null) {
                    if (debug > 1) {
                        Debug.println("TTM - halting thread and removed from node cache");
                        Debug.println("   -> " + treeNodeArray[n]);
                        Debug.println("   -> " + tT_NodeCache);
                    }
                    tT_NodeCache.halt();
                    this.cache.remove(tT_NodeCache);
                    boolean bl = this.cacheQueue.remove(tT_NodeCache);
                    tT_NodeCache = new TT_NodeCache(tT_NodeCache.getNode(), this.filterHandler.getActiveFilter());
                    this.cache.put(tT_NodeCache.getNode(), tT_NodeCache);
                    this.cacheQueue.addFirst(tT_NodeCache);
                }
                ++n;
            }
        }
        CacheWorker cacheWorker = this.cacheWorker;
        synchronized (cacheWorker) {
            this.cacheWorker.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateNodeInfo() {
        Object object;
        Object object2 = this.htLock;
        synchronized (object2) {
            object = this.cache.keys();
            while (object.hasMoreElements()) {
                ((TT_NodeCache)this.cache.get(object.nextElement())).invalidate();
            }
            this.cache = new Hashtable();
            this.cacheQueue = new LinkedList();
            this.suspendedQueue = new LinkedList();
        }
        object = this.relevantNodes.iterator();
        while (object.hasNext()) {
            this.getNodeInfo((TestResultTable.TreeNode)object.next(), false);
        }
    }

    void invalidateNodeInfo(TestResultTable.TreeNode treeNode) {
        this.invalidateNodeInfo(new TestResultTable.TreeNode[]{treeNode});
    }

    void swapTables(TestResultTable testResultTable) {
        if (testResultTable == this.trt || testResultTable == null) {
            return;
        }
        if (debug > 1) {
            Debug.println("Swapping TRTs under the covers.");
            Debug.println("   -> OLD=" + this.trt);
            Debug.println("   -> NEW=" + testResultTable);
        }
        this.trt.removeObserver(this);
        this.trt = testResultTable;
        this.trt.addObserver(this);
    }

    private void notifyInserted(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            EventQueue.invokeLater(new Notifier(2, this.treeModelListeners, treeModelEvent, this.uif));
        }
    }

    private void notifyChanged(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            EventQueue.invokeLater(new Notifier(0, this.treeModelListeners, treeModelEvent, this.uif));
        }
    }

    private void notifyRemoved(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            EventQueue.invokeLater(new Notifier(3, this.treeModelListeners, treeModelEvent, this.uif));
        }
    }

    private void notifyStructure(TreeModelEvent treeModelEvent) {
        if (this.treeModelListeners != null) {
            EventQueue.invokeLater(new Notifier(1, this.treeModelListeners, treeModelEvent, this.uif));
        }
    }

    private void notifyFullStructure() {
        if (debug > 0) {
            Debug.println("TTM - sending full structure change event to model listeners.");
        }
        this.invalidateNodeInfo();
        Object[] objectArray = new Object[]{this.trt.getRoot()};
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray);
        this.notifyStructure(treeModelEvent);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.trt != null) {
            this.trt.removeObserver(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FilterWatcher
    implements FilterSelectionHandler.Observer {
        private FilterWatcher() {
        }

        public void filterUpdated(TestFilter testFilter) {
            TestTreeModel.this.invalidateNodeInfo();
        }

        public void filterSelected(TestFilter testFilter) {
            if (!TestTreeModel.this.lastFilter.equals(testFilter)) {
                TestTreeModel.this.invalidateNodeInfo();
            }
            TestTreeModel.this.lastFilter = testFilter;
        }

        public void filterAdded(TestFilter testFilter) {
        }

        public void filterRemoved(TestFilter testFilter) {
        }
    }

    private static class Notifier
    implements Runnable {
        TreeModelListener[] l;
        int type;
        TreeModelEvent e;
        UIFactory uif;
        static final int CHANGE = 0;
        static final int STRUCT = 1;
        static final int INS = 2;
        static final int DEL = 3;

        Notifier(int n, TreeModelListener[] treeModelListenerArray, TreeModelEvent treeModelEvent, UIFactory uIFactory) {
            this.type = n;
            this.e = treeModelEvent;
            this.uif = uIFactory;
            TreeModelListener[] treeModelListenerArray2 = new TreeModelListener[treeModelListenerArray.length];
            System.arraycopy(treeModelListenerArray, 0, treeModelListenerArray2, 0, treeModelListenerArray.length);
            this.l = treeModelListenerArray2;
        }

        public void run() {
            switch (this.type) {
                case 0: {
                    int n = 0;
                    while (n < this.l.length) {
                        this.l[n].treeNodesChanged(this.e);
                        ++n;
                    }
                    break;
                }
                case 1: {
                    int n = 0;
                    while (n < this.l.length) {
                        this.l[n].treeStructureChanged(this.e);
                        ++n;
                    }
                    break;
                }
                case 2: {
                    int n = 0;
                    while (n < this.l.length) {
                        this.l[n].treeNodesInserted(this.e);
                        ++n;
                    }
                    break;
                }
                case 3: {
                    int n = 0;
                    while (n < this.l.length) {
                        this.l[n].treeNodesRemoved(this.e);
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new JavaTestError(this.uif.getI18NString("tree.noEType"));
                }
            }
        }
    }

    private class CacheWorker
    extends Thread {
        private volatile boolean stopping;
        private volatile TT_NodeCache priorityUnit;
        private volatile TT_NodeCache currentUnit;
        private static final int QUEUE = 0;
        private static final int DEPTH = 1;
        private static final int SCHEDULING_ALGO = 1;

        CacheWorker() {
            super("Test Tree Cache Worker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                var1_1 = this;
                synchronized (var1_1) {
                    this.wait();
                    if (true) ** GOTO lbl25
                }
            }
            catch (InterruptedException var1_2) {
                return;
            }
            do {
                this.currentUnit = this.getNextUnit();
                if (this.currentUnit == null) {
                    try {
                        var1_1 = this;
                        synchronized (var1_1) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException var1_3) {
                        this.stopping = true;
                    }
                    continue;
                }
                if (!this.currentUnit.canRun()) continue;
                if (TestTreeModel.debug > 0) {
                    Debug.println("TTM cache processing " + this.currentUnit.getNode().getName());
                }
                this.currentUnit.run();
                if (this.currentUnit.isPaused() || !this.currentUnit.isValid()) continue;
                this.finishJob(this.currentUnit);
lbl25:
                // 6 sources

            } while (!this.stopping);
        }

        public TT_NodeCache getActiveNode() {
            return this.currentUnit;
        }

        synchronized void requestActiveNode(TT_NodeCache tT_NodeCache) {
            if (tT_NodeCache != null && this.currentUnit != tT_NodeCache && tT_NodeCache.canRun()) {
                this.priorityUnit = tT_NodeCache;
                if (this.currentUnit != null) {
                    this.currentUnit.pause();
                    TestTreeModel.this.suspendedQueue.addFirst(this.currentUnit);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TT_NodeCache getNextUnit() {
            boolean bl = false;
            TT_NodeCache tT_NodeCache = null;
            Object object = TestTreeModel.this.htLock;
            synchronized (object) {
                if (this.priorityUnit != null) {
                    bl = true;
                    tT_NodeCache = this.priorityUnit;
                    this.priorityUnit = null;
                } else {
                    switch (1) {
                        case 0: {
                            tT_NodeCache = this.selectByQueuing();
                            break;
                        }
                        case 1: {
                            tT_NodeCache = this.selectByDepth();
                            break;
                        }
                        default: {
                            tT_NodeCache = this.selectByQueuing();
                        }
                    }
                }
                if (tT_NodeCache != null && !tT_NodeCache.canRun()) {
                    return this.getNextUnit();
                }
                return tT_NodeCache;
            }
        }

        private TT_NodeCache selectByQueuing() {
            TT_NodeCache tT_NodeCache = null;
            if (TestTreeModel.this.suspendedQueue.size() > 0) {
                tT_NodeCache = (TT_NodeCache)TestTreeModel.this.suspendedQueue.removeLast();
            } else if (TestTreeModel.this.cacheQueue.size() > 0) {
                tT_NodeCache = (TT_NodeCache)TestTreeModel.this.cacheQueue.removeLast();
            }
            if (tT_NodeCache != null && tT_NodeCache.getNode().isRoot() && (TestTreeModel.this.cacheQueue.size() > 0 || TestTreeModel.this.suspendedQueue.size() > 0)) {
                TestTreeModel.this.cacheQueue.addFirst(tT_NodeCache);
                return this.selectByQueuing();
            }
            return tT_NodeCache;
        }

        private TT_NodeCache selectByDepth() {
            TT_NodeCache tT_NodeCache = null;
            int n = -1;
            LinkedList linkedList = TestTreeModel.this.cacheQueue;
            boolean bl = true;
            int n2 = 0;
            if (TestTreeModel.this.cacheQueue.size() == 0) {
                if (TestTreeModel.this.suspendedQueue.size() == 0) {
                    bl = false;
                } else {
                    linkedList = TestTreeModel.this.suspendedQueue;
                }
            }
            while (bl) {
                TT_NodeCache tT_NodeCache2 = (TT_NodeCache)linkedList.get(n2);
                int n3 = TestResultTable.getObjectPath(tT_NodeCache2.getNode()).length;
                if (n3 > n) {
                    linkedList.remove(n2);
                    if (tT_NodeCache != null) {
                        TestTreeModel.this.cacheQueue.addFirst(tT_NodeCache);
                        if (linkedList == TestTreeModel.this.cacheQueue) {
                            ++n2;
                        }
                    }
                    n = n3;
                    tT_NodeCache = tT_NodeCache2;
                }
                if (++n2 < linkedList.size()) continue;
                if (linkedList == TestTreeModel.this.suspendedQueue) {
                    bl = false;
                    continue;
                }
                if (TestTreeModel.this.suspendedQueue.size() != 0) {
                    linkedList = TestTreeModel.this.suspendedQueue;
                    n2 = 0;
                    continue;
                }
                bl = false;
            }
            return tT_NodeCache;
        }

        private synchronized void finishJob(TT_NodeCache tT_NodeCache) {
            if (!TestTreeModel.this.relevantNodes.contains(tT_NodeCache.getNode())) {
                return;
            }
            TreeModelEvent treeModelEvent = null;
            TestResultTable.TreeNode treeNode = tT_NodeCache.getNode();
            if (treeNode.isRoot()) {
                treeModelEvent = new TreeModelEvent((Object)this, new Object[]{treeNode}, (int[])null, (Object[])null);
            } else {
                TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(treeNode);
                Object[] objectArray = new TestResultTable.TreeNode[treeNodeArray.length - 1];
                System.arraycopy(treeNodeArray, 0, objectArray, 0, treeNodeArray.length - 1);
                int n = 0;
                if (objectArray.length > 1) {
                    n = objectArray[objectArray.length - 1].getIndex(treeNode);
                }
                treeModelEvent = TestTreeModel.this.makeEvent(objectArray, treeNode, n);
            }
            TestTreeModel.this.notifyChanged(treeModelEvent);
        }
    }
}

