/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class TestTree
extends JTree {
    private UIFactory uif;
    private TestTreeModel currModel;
    private TreePanelModel tpm;
    private FilterSelectionHandler filterHandler;
    private EventWatcher watcher = new EventWatcher();
    private static int debug = Debug.getInt("debug." + (class$com$sun$javatest$exec$TestTree == null ? (class$com$sun$javatest$exec$TestTree = TestTree.class$("com.sun.javatest.exec.TestTree")) : class$com$sun$javatest$exec$TestTree).getName());
    static /* synthetic */ Class class$com$sun$javatest$exec$TestTree;

    public TestTree(UIFactory uIFactory, TreePanelModel treePanelModel, FilterSelectionHandler filterSelectionHandler, TestTreeModel testTreeModel) {
        this.uif = uIFactory;
        this.tpm = treePanelModel;
        this.filterHandler = filterSelectionHandler;
        this.filterHandler.addObserver(this.watcher);
        this.currModel = testTreeModel;
        this.setModel(this.currModel);
        this.setLargeModel(true);
        this.setScrollsOnExpand(true);
        this.setName("tree");
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void updateGUI() {
        this.repaint();
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        treeModel.addTreeModelListener(this.watcher);
    }

    void setParameters(Parameters parameters) {
    }

    void setTreeModel(TestTreeModel testTreeModel) {
        if (this.currModel != null) {
            this.currModel.removeTreeModelListener(this.watcher);
        }
        this.currModel = testTreeModel;
        this.setModel(this.currModel);
    }

    TestResultTable getTestResultTable() {
        return this.currModel.getTestResultTable();
    }

    TreePath[] snapshotOpenPaths() {
        if (this.currModel == null) {
            return null;
        }
        Object[] objectArray = new TreePath[]{};
        Enumeration<TreePath> enumeration = this.getDescendantToggledPaths(new TreePath(this.currModel.getRoot()));
        while (enumeration != null && enumeration.hasMoreElements()) {
            TreePath treePath = enumeration.nextElement();
            if (!this.isVisible(treePath) || !this.isExpanded(treePath)) continue;
            objectArray = (TreePath[])DynamicArray.append(objectArray, treePath);
        }
        return objectArray;
    }

    void restorePaths(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < treePathArray.length) {
            this.setExpandedState(treePathArray[n], true);
            this.makeVisible(treePathArray[n]);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EventWatcher
    implements TreeModelListener,
    FilterSelectionHandler.Observer {
        private EventWatcher() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getPath()[0] == TestTree.this.getModel().getRoot() && treeModelEvent.getPath().length == 1) {
                TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)TestTree.this.getModel().getRoot();
                TestTree.this.tpm.showNode(treeNode, new TreePath(treeNode));
            }
        }

        public void filterUpdated(TestFilter testFilter) {
            TestTree.this.updateGUI();
        }

        public void filterSelected(TestFilter testFilter) {
            TestTree.this.updateGUI();
        }

        public void filterAdded(TestFilter testFilter) {
        }

        public void filterRemoved(TestFilter testFilter) {
        }
    }
}

