/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestFinder;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

class TestSuiteErrorsDialog
extends ToolDialog {
    private TestSuite testSuite;
    private JEditorPane body;

    TestSuiteErrorsDialog(Component component, UIFactory uIFactory) {
        super(component, uIFactory, "tse");
    }

    public void show(TestSuite testSuite) {
        this.testSuite = testSuite;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body style=\"font-family: SansSerif; font-size: 12pt\">");
        if (this.testSuite == null) {
            stringBuffer.append(this.uif.getI18NString("tse.head.noTestSuite"));
        } else {
            TestFinder testFinder = this.testSuite.getTestFinder();
            if (testFinder.getErrorCount() == 0) {
                stringBuffer.append(this.uif.getI18NString("tse.head.noErrs"));
            } else {
                stringBuffer.append(this.uif.getI18NString("tse.head.errs"));
                stringBuffer.append("<ul>");
                String[] stringArray = testFinder.getErrors();
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append("<li>");
                    stringBuffer.append(this.escape(stringArray[n]));
                    ++n;
                }
                stringBuffer.append("</ul>");
            }
        }
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        if (this.body == null) {
            this.initGUI();
        }
        this.body.setText(stringBuffer.toString());
        this.setVisible(true);
    }

    protected void initGUI() {
        this.setHelp("browse.testSuiteErrors.csh");
        this.setI18NTitle("tse.title");
        this.body = new JEditorPane();
        this.body.setName("tse");
        this.body.setContentType("text/html");
        this.body.setEditable(false);
        this.body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = this.uif.createScrollPane(this.body);
        int n = this.uif.getDotsPerInch();
        jScrollPane.setPreferredSize(new Dimension(6 * n, 3 * n));
        this.setBody(jScrollPane);
        JButton jButton = this.uif.createHelpButton("tse.help", "browse.testSuiteErrors.csh");
        JButton jButton2 = this.uif.createCloseButton("tse.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
    }

    private String escape(String string) {
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '&': 
                case '<': 
                case '>': {
                    StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
                    int n2 = 0;
                    while (n2 < string.length()) {
                        char c = string.charAt(n2);
                        switch (c) {
                            case '<': {
                                stringBuffer.append("&lt;");
                                break;
                            }
                            case '>': {
                                stringBuffer.append("&gt;");
                                break;
                            }
                            case '&': {
                                stringBuffer.append("&amp;");
                                break;
                            }
                            default: {
                                stringBuffer.append(c);
                            }
                        }
                        ++n2;
                    }
                    return stringBuffer.toString();
                }
            }
            ++n;
        }
        return string;
    }
}

