/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.TP_DescSubpanel;
import com.sun.javatest.exec.TP_EnvSubpanel;
import com.sun.javatest.exec.TP_FilesSubpanel;
import com.sun.javatest.exec.TP_OutputSubpanel;
import com.sun.javatest.exec.TP_ResultsSubpanel;
import com.sun.javatest.exec.TP_Subpanel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Map;
import javax.help.CSH;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TestPanel
extends JPanel {
    static final String lineSeparator = System.getProperty("line.separator");
    private UIFactory uif;
    private TP_Subpanel[] panels;
    private JTabbedPane tabs;
    private TP_DescSubpanel descPanel;
    private TP_FilesSubpanel filesPanel;
    private TP_ResultsSubpanel resultPanel;
    private TP_EnvSubpanel envPanel;
    private TP_OutputSubpanel outputPanel;
    private JTextField statusField;
    private Harness harness;
    private TestResult currTest;
    private TP_Subpanel currPanel;
    private TestDescription currDesc;
    private boolean needToUpdateGUIWhenShown = true;
    private boolean updatePending = false;
    private final Observer observer = new Observer();

    TestPanel(UIFactory uIFactory, Harness harness) {
        this.uif = uIFactory;
        this.harness = harness;
        this.initGUI();
    }

    public Dimension getPreferredSize() {
        int n = this.uif.getDotsPerInch();
        return new Dimension(5 * n, 4 * n);
    }

    void setTestSuite(TestSuite testSuite) {
        int n = 0;
        while (n < this.panels.length) {
            this.panels[n].setTestSuite(testSuite);
            ++n;
        }
    }

    TestResult getTest() {
        return this.currTest;
    }

    void setTest(TestResult testResult) {
        this.updatePanel(testResult, this.currPanel);
    }

    private synchronized void updatePanel(TestResult testResult, TP_Subpanel tP_Subpanel) {
        if (testResult != this.currTest) {
            this.currTest = testResult;
            this.currDesc = null;
        }
        if (tP_Subpanel != this.currPanel) {
            CSH.setHelpIDString(this.tabs, CSH.getHelpIDString(tP_Subpanel));
            this.currPanel = tP_Subpanel;
        }
        if (EventQueue.isDispatchThread()) {
            this.updateGUIWhenVisible();
        } else if (!this.updatePending && !this.needToUpdateGUIWhenShown) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    TestPanel testPanel = TestPanel.this;
                    synchronized (testPanel) {
                        TestPanel.this.updateGUIWhenVisible();
                        TestPanel.this.updatePending = false;
                    }
                }
            });
            this.updatePending = true;
        }
    }

    private void updateGUIWhenVisible() {
        if (this.isVisible()) {
            this.updateGUI();
        } else {
            this.needToUpdateGUIWhenShown = true;
        }
    }

    private synchronized void updateGUI() {
        if (this.currTest == null) {
            int n = 0;
            while (n < this.tabs.getComponentCount()) {
                this.tabs.setEnabledAt(n, false);
                ++n;
            }
            this.statusField.setEnabled(false);
        } else {
            boolean bl;
            try {
                if (this.currDesc == null) {
                    this.currDesc = this.currTest.getDescription();
                }
            }
            catch (TestResult.Fault fault) {
                JavaTestError.unexpectedException(fault);
            }
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.descPanel), true);
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.filesPanel), true);
            try {
                Map map = this.currTest.getEnvironment();
                bl = map != null && map.size() > 0;
            }
            catch (TestResult.Fault fault) {
                bl = false;
            }
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.envPanel), bl);
            boolean bl2 = this.currTest.getPropertyNames().hasMoreElements();
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.resultPanel), bl2);
            boolean bl3 = this.currTest.getSectionCount() > 0;
            this.tabs.setEnabledAt(this.tabs.indexOfComponent(this.outputPanel), bl3);
            this.updateStatus();
            if (this.currPanel.isUpdateRequired(this.currTest)) {
                this.currPanel.updateSubpanel(this.currTest);
            }
        }
    }

    private void updateStatus() {
        if (this.isShowing()) {
            Status status = this.currTest.getStatus();
            this.statusField.setText(I18NUtils.getStatusMessage(status));
            Color color = I18NUtils.getStatusBarColor(status.getType());
            this.statusField.setBackground(color);
            this.statusField.setEnabled(true);
        }
    }

    private void initGUI() {
        this.setName("test");
        this.descPanel = new TP_DescSubpanel(this.uif);
        this.filesPanel = new TP_FilesSubpanel(this.uif);
        this.resultPanel = new TP_ResultsSubpanel(this.uif);
        this.envPanel = new TP_EnvSubpanel(this.uif);
        this.outputPanel = new TP_OutputSubpanel(this.uif);
        this.panels = new TP_Subpanel[]{this.descPanel, this.filesPanel, this.envPanel, this.resultPanel, this.outputPanel};
        this.tabs = this.uif.createTabbedPane("test", this.panels);
        this.tabs.setTabPlacement(1);
        this.tabs.setName("testTabs");
        this.tabs.setSelectedComponent(this.outputPanel);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = TestPanel.this.tabs.getSelectedComponent();
                if (component instanceof TP_Subpanel) {
                    TestPanel.this.updatePanel(TestPanel.this.currTest, (TP_Subpanel)component);
                }
            }
        });
        this.currPanel = this.outputPanel;
        CSH.setHelpIDString(this.tabs, CSH.getHelpIDString(this.currPanel));
        this.statusField = this.uif.createOutputField("test.status");
        this.statusField.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.statusField, "South");
        ComponentListener componentListener = new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (TestPanel.this.needToUpdateGUIWhenShown) {
                    TestPanel.this.updateGUI();
                    TestPanel.this.needToUpdateGUIWhenShown = false;
                }
                TestPanel.this.harness.addObserver(TestPanel.this.observer);
            }

            public void componentHidden(ComponentEvent componentEvent) {
                TestPanel.this.harness.removeObserver(TestPanel.this.observer);
            }
        };
        this.addComponentListener(componentListener);
    }

    private class Observer
    implements Harness.Observer,
    TestResult.Observer {
        private Observer() {
        }

        public void startingTestRun(Parameters parameters) {
        }

        public void startingTest(TestResult testResult) {
            try {
                if (testResult.getDescription() == TestPanel.this.currDesc) {
                    TestPanel.this.updatePanel(testResult, TestPanel.this.currPanel);
                }
            }
            catch (TestResult.Fault fault) {}
        }

        public void finishedTest(TestResult testResult) {
            if (testResult == TestPanel.this.currTest) {
                TestPanel.this.updatePanel(testResult, TestPanel.this.currPanel);
            }
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
        }

        public void error(String string) {
        }

        public void completed(TestResult testResult) {
            testResult.removeObserver(this);
            TestPanel.this.updateStatus();
        }

        public void createdSection(TestResult testResult, TestResult.Section section) {
        }

        public void completedSection(TestResult testResult, TestResult.Section section) {
        }

        public void createdOutput(TestResult testResult, TestResult.Section section, String string) {
        }

        public void completedOutput(TestResult testResult, TestResult.Section section, String string) {
        }

        public void updatedOutput(TestResult testResult, TestResult.Section section, String string, int n, int n2, String string2) {
        }

        public void updatedProperty(TestResult testResult, String string, String string2) {
        }
    }
}

