/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class TT_Renderer
extends DefaultTreeCellRenderer {
    private Parameters params;
    private FilterSelectionHandler filterHandler;
    private TreePanelModel tpm;
    private UIFactory uif;
    private static Icon unknownIcon;
    private static final int[] stateOrdering;
    private static final int debug;
    static /* synthetic */ Class class$com$sun$javatest$exec$TT_Renderer;

    TT_Renderer(UIFactory uIFactory, FilterSelectionHandler filterSelectionHandler, TreePanelModel treePanelModel) {
        this.uif = uIFactory;
        this.filterHandler = filterSelectionHandler;
        this.tpm = treePanelModel;
        if (stateOrdering.length != 4) {
            throw new JavaTestError(uIFactory.getI18NString("tree.unmatched"));
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.setIcon(this.getIcon(object, (TestTreeModel)jTree.getModel()));
        this.setText(this.getLabelText(object));
        this.setToolTipText(this.getTipText(object));
        return this;
    }

    void setParameters(Parameters parameters) {
        this.params = parameters;
    }

    private Icon getIcon(Object object, TestTreeModel testTreeModel) {
        TestFilter testFilter = this.filterHandler.getActiveFilter();
        if (this.params == null || this.params.getTestSuite() == null) {
            return IconFactory.getTestFolderIcon(3, false, true);
        }
        if (object instanceof TestResult) {
            TestResult testResult = (TestResult)object;
            if (debug > 0) {
                Debug.println("TT Rend - rendering TR " + testResult);
                Debug.println("   -> " + testResult.getTestName());
                Debug.println("   -> " + testResult.getStatus().toString());
                Debug.println("   -> " + testResult.isMutable());
            }
            if (this.isFilteredOut(testResult, testFilter)) {
                return IconFactory.getTestIcon(4, false, true);
            }
            if (this.isRunning(testResult)) {
                return IconFactory.getTestIcon(testResult.getStatus().getType(), true, true);
            }
            return IconFactory.getTestIcon(testResult.getStatus().getType(), false, true);
        }
        TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
        TT_NodeCache tT_NodeCache = testTreeModel.getNodeInfo(treeNode, false);
        int[] nArray = tT_NodeCache.getStats();
        if (nArray == null) {
            return unknownIcon;
        }
        boolean bl = !tT_NodeCache.isValid() || tT_NodeCache.isActive() || tT_NodeCache.isValid() && !tT_NodeCache.isComplete();
        return IconFactory.getTestFolderIcon(TT_Renderer.selectBranchIconIndex(nArray, bl), this.tpm.isActive(treeNode) || bl, true);
    }

    private String getLabelText(Object object) {
        if (object instanceof TestResult) {
            TestResult testResult = (TestResult)object;
            String string = testResult.getTestName();
            int n = string.lastIndexOf("/");
            return n != -1 ? string.substring(n + 1) : string;
        }
        TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
        if (treeNode.isRoot()) {
            if (this.params == null || this.params.getTestSuite() == null) {
                return this.uif.getI18NString("tree.noTs");
            }
            return this.uif.getI18NString("tree.rootName");
        }
        return treeNode.getName();
    }

    private String getTipText(Object object) {
        if (object instanceof TestResult) {
            return ((TestResult)object).getTestName();
        }
        if (object instanceof TestResultTable.TreeNode) {
            if (this.params == null || this.params.getTestSuite() == null) {
                return this.uif.getI18NString("tree.noRootName.tip");
            }
            TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
            if (treeNode.isRoot()) {
                return this.uif.getI18NString("tree.rootName.tip", this.params.getTestSuite().getName());
            }
            return TestResultTable.getRootRelativePath(treeNode);
        }
        return null;
    }

    private boolean isFilteredOut(TestResult testResult, TestFilter testFilter) {
        block9: {
            TestDescription testDescription;
            if (testFilter == null) {
                return false;
            }
            if (debug > 1) {
                Debug.println("TT - Checking filter for: " + testResult.getTestName() + " (TR status=" + testResult.getStatus().getType() + ")");
            }
            try {
                testDescription = testResult.getDescription();
            }
            catch (TestResult.Fault fault) {
                if (debug > 0) {
                    fault.printStackTrace(Debug.getWriter());
                }
                return false;
            }
            try {
                if (!testFilter.accepts(testDescription)) {
                    if (debug > 1) {
                        Debug.println("TT - Filter " + testFilter + " rejected: " + testResult.getWorkRelativePath());
                    }
                    return true;
                }
            }
            catch (TestFilter.Fault fault) {
                if (debug <= 0) break block9;
                fault.printStackTrace(Debug.getWriter());
            }
        }
        return false;
    }

    private boolean isRunning(TestResult testResult) {
        return this.tpm.isActive(testResult);
    }

    private static int selectBranchIconIndex(int[] nArray, boolean bl) {
        int n = 0;
        while (n != stateOrdering.length) {
            if (nArray[stateOrdering[n]] > 0) {
                return stateOrdering[n];
            }
            ++n;
        }
        if (!bl) {
            return 4;
        }
        return 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        stateOrdering = new int[]{2, 1, 3, 0};
        debug = Debug.getInt(class$com$sun$javatest$exec$TT_Renderer == null ? (class$com$sun$javatest$exec$TT_Renderer = TT_Renderer.class$("com.sun.javatest.exec.TT_Renderer")) : class$com$sun$javatest$exec$TT_Renderer);
    }
}

