/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestResult;
import com.sun.javatest.exec.TP_Subpanel;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.text.View;

abstract class TP_PropertySubpanel
extends TP_Subpanel {
    private Table table;

    protected TP_PropertySubpanel(UIFactory uIFactory, String string) {
        super(uIFactory, string);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JTextField jTextField = uIFactory.createHeading("test." + string + ".caption");
        jTextField.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.add((Component)jTextField, "North");
        this.table = new Table(uIFactory);
        JScrollPane jScrollPane = uIFactory.createScrollPane(this.table);
        jScrollPane.getViewport().setViewPosition(new Point(0, 0));
        jScrollPane.getViewport().setBackground(Color.white);
        this.add((Component)jScrollPane, "Center");
    }

    void setHead(String string, String string2) {
        this.table.setHead(string, string2);
    }

    protected void updateSubpanel(TestResult testResult) {
        super.updateSubpanel(testResult);
        this.table.reset();
    }

    protected void updateEntries(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.table.updateEntry(string, string2);
        }
    }

    protected void updateEntry(String string, String string2) {
        this.table.updateEntry(string, string2);
    }

    private static class Table
    extends JPanel
    implements ComponentListener,
    Scrollable {
        private SortedMap entries;
        private int maxNameStringWidth = 100;
        private JTextField nameLabel;
        private JTextField valueLabel;
        private Border headBorder;
        private Border bodyBorder;
        private boolean inScrollPane;
        private boolean pendingValidate;

        Table(UIFactory uIFactory) {
            this.addComponentListener(this);
            this.setLayout(null);
            this.setBackground(Color.white);
            this.entries = new TreeMap();
            Border border = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, Color.lightGray);
            this.headBorder = BorderFactory.createCompoundBorder(matteBorder, border);
            MatteBorder matteBorder2 = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray);
            this.bodyBorder = BorderFactory.createCompoundBorder(matteBorder2, border);
            this.nameLabel = uIFactory.createHeading("test.table.name");
            this.nameLabel.setBorder(this.headBorder);
            this.valueLabel = uIFactory.createHeading("test.table.value");
            this.valueLabel.setBorder(this.headBorder);
        }

        void setHead(String string, String string2) {
            this.nameLabel.setText(string);
            this.valueLabel.setText(string2);
        }

        void updateEntry(String string, String string2) {
            Entry entry = (Entry)this.entries.get(string);
            if (entry == null) {
                entry = new Entry(string, string2);
                this.entries.put(string, entry);
                this.maxNameStringWidth = Math.max(this.maxNameStringWidth, this.getFontMetrics(this.getFont()).stringWidth(string));
            } else {
                entry.valueText.setText(string2);
            }
            this.revalidate();
        }

        void reset() {
            this.entries.clear();
            this.removeAll();
            this.maxNameStringWidth = 100;
            if (!this.inScrollPane) {
                this.add(this.nameLabel);
                this.add(this.valueLabel);
            }
            this.revalidate();
        }

        public void addNotify() {
            super.addNotify();
            this.configureEnclosingScrollPane();
        }

        public void removeNotify() {
            super.removeNotify();
            this.unconfigureEnclosingScrollPane();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void revalidate() {
            if (this.inScrollPane) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    if (!this.pendingValidate) {
                        this.invalidate();
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ Table this$0;
                            {
                                this.this$0 = table;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Object object = this.this$0.getTreeLock();
                                synchronized (object) {
                                    this.this$0.validate();
                                    Table.access$002(this.this$0, false);
                                }
                            }
                        });
                        this.pendingValidate = true;
                    }
                }
            } else {
                super.revalidate();
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.revalidate();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLayout() {
            Object object = this.getTreeLock();
            synchronized (object) {
                Insets insets = this.bodyBorder.getBorderInsets(this);
                int n = insets.left + this.maxNameStringWidth + 10 + insets.right;
                int n2 = Math.max(this.getWidth() - n, 200);
                int n3 = this.nameLabel.getPreferredSize().height;
                this.nameLabel.setBounds(0, 0, n, n3);
                this.valueLabel.setBounds(n, 0, n2, n3);
                int n4 = this.inScrollPane ? 0 : n3;
                Iterator iterator = this.entries.values().iterator();
                while (iterator.hasNext()) {
                    Entry entry = (Entry)iterator.next();
                    Insets insets2 = entry.valueText.getInsets();
                    View view = entry.valueText.getUI().getRootView(entry.valueText);
                    view.setSize(n2, 2.1474836E9f);
                    n3 = insets2.top + (int)view.getPreferredSpan(1) + insets2.bottom;
                    entry.nameField.setBounds(0, n4, n, n3);
                    entry.valueText.setBounds(n, n4, n2, n3);
                    n4 += n3;
                }
            }
        }

        public Dimension getMinimumSize() {
            int n = this.inScrollPane ? 0 : this.nameLabel.getPreferredSize().height;
            Iterator iterator = this.entries.values().iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                n += entry.valueText.getMinimumSize().height;
            }
            return new Dimension(this.maxNameStringWidth + 400, n);
        }

        public Dimension getPreferredSize() {
            int n = this.inScrollPane ? 0 : this.nameLabel.getPreferredSize().height;
            Iterator iterator = this.entries.values().iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                n += entry.valueText.getPreferredSize().height;
            }
            return new Dimension(this.maxNameStringWidth + 400, n);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            switch (n) {
                case 1: {
                    return rectangle.height / 10;
                }
                case 0: {
                    return rectangle.width / 10;
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + n);
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            switch (n) {
                case 1: {
                    return rectangle.height;
                }
                case 0: {
                    return rectangle.width;
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + n);
        }

        private void configureEnclosingScrollPane() {
            Container container;
            Container container2 = this.getParent();
            if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container;
                JViewport jViewport = jScrollPane.getViewport();
                if (jViewport == null || jViewport.getView() != this) {
                    return;
                }
                this.inScrollPane = true;
                jScrollPane.setColumnHeaderView(new Header());
                JPanel jPanel = new JPanel();
                jPanel.setBackground(Color.white);
                jPanel.setBorder(this.headBorder);
                jScrollPane.setCorner("UPPER_RIGHT_CORNER", jPanel);
            }
        }

        private void unconfigureEnclosingScrollPane() {
            Container container;
            Container container2 = this.getParent();
            if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container;
                JViewport jViewport = jScrollPane.getViewport();
                if (jViewport == null || jViewport.getView() != this) {
                    return;
                }
                this.inScrollPane = false;
                jScrollPane.setColumnHeaderView(null);
            }
        }

        static /* synthetic */ boolean access$002(Table table, boolean bl) {
            table.pendingValidate = bl;
            return table.pendingValidate;
        }

        private class Header
        extends JPanel {
            Header() {
                this.setLayout(null);
                this.setOpaque(true);
                this.setBackground(Color.white);
                this.add(Table.this.nameLabel);
                this.add(Table.this.valueLabel);
            }

            public Dimension getMinumumSize() {
                return new Dimension(Table.this.getMinimumSize().width, ((Table)Table.this).nameLabel.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(Table.this.getPreferredSize().width, ((Table)Table.this).nameLabel.getPreferredSize().height);
            }
        }

        private class Entry {
            String name;
            JTextField nameField;
            String value;
            JTextArea valueText;

            Entry(String string, String string2) {
                this.name = string;
                this.value = string2;
                this.nameField = new JTextField(string);
                this.nameField.setBorder(Table.this.bodyBorder);
                this.nameField.setEditable(false);
                this.nameField.setOpaque(false);
                Table.this.add(this.nameField);
                int n = Math.max(Table.this.getWidth() - Table.this.maxNameStringWidth, 200);
                this.valueText = new JTextArea(string2);
                this.valueText.setBorder(Table.this.bodyBorder);
                this.valueText.setEditable(false);
                this.valueText.setLineWrap(true);
                Table.this.add(this.valueText);
            }
        }
    }
}

