/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.exec.ProgressMeter;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.UIFactory;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;

class RunProgressMonitor
extends Monitor
implements MonitorState.Observer {
    private volatile ProgressMeter smMeter;

    RunProgressMonitor(MonitorState monitorState, UIFactory uIFactory) {
        super(monitorState, uIFactory);
        monitorState.addObserver(this);
    }

    public String getSmallMonitorName() {
        return this.uif.getI18NString("runprog.smName");
    }

    public Icon getSmallMonitorIcon() {
        return null;
    }

    public JComponent getSmallMonitor() {
        if (this.smMeter == null) {
            Color[] colorArray = new Color[]{I18NUtils.getStatusBarColor(0), I18NUtils.getStatusBarColor(1), I18NUtils.getStatusBarColor(2), I18NUtils.getStatusBarColor(3)};
            this.smMeter = new ProgressMeter(colorArray, this.state);
            this.smMeter.setToolTipText(this.uif.getI18NString("runprog.smName.tip"));
        }
        if (this.state.isRunning()) {
            this.smMeter.start();
        } else {
            this.smMeter.update();
        }
        return this.smMeter;
    }

    public String getLargeMonitorName() {
        return this.uif.getI18NString("runprog.lgName");
    }

    public Icon getLargeMonitorIcon() {
        return null;
    }

    public JComponent getLargeMonitor() {
        return null;
    }

    public void starting() {
        if (this.smMeter != null) {
            this.smMeter.start();
        }
    }

    public void postProcessing() {
        this.stopAll();
    }

    public void stopping() {
    }

    public void finished(boolean bl) {
    }

    private void stopAll() {
        if (this.smMeter != null) {
            this.smMeter.update();
            this.smMeter.stop();
        }
    }
}

