/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.FilesPane;
import com.sun.javatest.exec.ReportHandler;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

class ReportBrowser
extends ToolDialog {
    private ReportHandler reportHandler;
    private FilesPane fp;
    private File reportFile;

    public ReportBrowser(JComponent jComponent, UIFactory uIFactory, ReportHandler reportHandler) {
        super(jComponent, uIFactory, "rb");
        this.reportHandler = reportHandler;
    }

    void show(File file) {
        try {
            this.setSelectedFile(file);
            this.setVisible(true);
        }
        catch (IOException iOException) {
            this.uif.showError("rb.load.error", new Object[]{file, iOException});
        }
    }

    void setSelectedFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.reportFile = file;
        this.setI18NTitle("rb.title", file);
        if (this.fp == null) {
            this.initGUI();
        }
        this.fp.setBaseDirectory(file);
        this.fp.setFile(file.toURL());
    }

    File getSelectedFile() {
        return this.reportFile;
    }

    protected void initGUI() {
        this.setHelp("report.reportBrowser.csh");
        this.fp = new FilesPane(this.uif);
        int n = this.uif.getDotsPerInch();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = Math.min(7 * n, dimension.width * 9 / 10);
        int n3 = Math.min(9 * n, dimension.height * 9 / 10);
        this.fp.setPreferredSize(new Dimension(n2, n3));
        this.setBody(this.fp);
        JMenuBar jMenuBar = this.uif.createMenuBar("rb.menubar");
        jMenuBar.add(this.createFileMenu(this.reportHandler));
        jMenuBar.add(this.uif.createHorizontalGlue("rb.pad"));
        jMenuBar.add(this.createHelpMenu());
        this.setJMenuBar(jMenuBar);
        if (this.reportFile == null) {
            this.setI18NTitle("rb.title");
        } else {
            this.setI18NTitle("rb.title_file", this.reportFile);
            this.fp.setBaseDirectory(this.reportFile);
            try {
                this.fp.setFile(this.reportFile.toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    private JMenu createFileMenu(ReportHandler reportHandler) {
        Action action = reportHandler.getNewReportAction();
        Action action2 = reportHandler.getOpenReportAction();
        ToolAction toolAction = new ToolAction(this.uif, "rb.file.close"){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportBrowser.this.setVisible(false);
            }
        };
        Action[] actionArray = new Action[]{action, action2, toolAction};
        JMenu jMenu = this.uif.createMenu("rb.file", actionArray);
        return jMenu;
    }

    private JMenu createHelpMenu() {
        JMenu jMenu = this.uif.createMenu("rb.help");
        JMenuItem jMenuItem = this.uif.createHelpMenuItem("rb.help.rb", "report.reportBrowser.csh");
        jMenu.add(jMenuItem);
        return jMenu;
    }
}

