/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.WizPrint;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class QuestionLogBrowser
extends ToolDialog {
    private InterviewParameters params;
    private JScrollPane scrollPane;
    private JEditorPane body;
    private Listener listener;

    QuestionLogBrowser(JComponent jComponent, InterviewParameters interviewParameters, UIFactory uIFactory) {
        super(jComponent, uIFactory, "qlb");
        if (interviewParameters == null) {
            throw new NullPointerException();
        }
        this.params = interviewParameters;
        this.listener = new Listener();
    }

    protected void initGUI() {
        this.setHelp("quLog.window.csh");
        this.body = new JEditorPane();
        this.body.setContentType("text/html");
        this.body.setText("");
        this.body.setEditable(false);
        this.body.addHyperlinkListener(this.listener);
        this.body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.body.setName("qlb.body");
        this.uif.setAccessibleName(this.body, "qlb.body");
        this.uif.setToolTip(this.body, "qlb");
        this.scrollPane = this.uif.createScrollPane(this.body);
        int n = this.uif.getDotsPerInch();
        this.scrollPane.setPreferredSize(new Dimension(6 * n, 9 * n));
        this.setBody(this.scrollPane);
        JButton jButton = this.uif.createHelpButton("qlb.help", "quLog.window.csh");
        JButton jButton2 = this.uif.createCloseButton("qlb.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
        this.setComponentListener(this.listener);
    }

    private void updateContent() {
        File file;
        if (this.body == null) {
            this.initGUI();
        }
        if ((file = this.params.getFile()) == null) {
            this.setI18NTitle("qlb.title");
        } else {
            this.setI18NTitle("qlb.titleWithFile", file);
        }
        try {
            WizPrint wizPrint = new WizPrint(this.params);
            wizPrint.setShowResponses(true);
            wizPrint.setShowResponseTypes(false);
            wizPrint.setShowTags(true);
            StringWriter stringWriter = new StringWriter();
            wizPrint.write(stringWriter);
            this.body.setText(stringWriter.toString());
            this.body.getCaret().setDot(0);
        }
        catch (IOException iOException) {}
    }

    private class Listener
    extends ComponentAdapter
    implements HyperlinkListener,
    Interview.Observer {
        private Listener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getDescription();
                if (!string.startsWith("#")) {
                    return;
                }
                QuestionLogBrowser.this.body.scrollToReference(string.substring(1));
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            QuestionLogBrowser.this.params.addObserver(this);
            QuestionLogBrowser.this.updateContent();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            QuestionLogBrowser.this.params.removeObserver(this);
        }

        public void currentQuestionChanged(Question question) {
        }

        public void pathUpdated() {
            QuestionLogBrowser.this.updateContent();
        }
    }
}

