/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.Timer;

class ProgressMeter
extends JComponent
implements Accessible {
    private boolean indet;
    private Timer indetTimer;
    private Color[] colors;
    private String[] actions;
    private int[] values;
    private static final int SCALE = 1024;
    private ActionListener actionListener;
    private MouseListener mouseListener;
    private MonitorState state;
    private PM_AccessibleContext ac;
    private volatile Thread myThread;
    private static I18NResourceBundle i18n;

    ProgressMeter(Color[] colorArray, MonitorState monitorState) {
        this(colorArray);
        this.state = monitorState;
        this.values = new int[colorArray.length];
    }

    ProgressMeter(Color[] colorArray, MonitorState monitorState, String[] stringArray) {
        this(colorArray);
        this.actions = stringArray;
        this.state = monitorState;
        this.values = new int[colorArray.length];
    }

    ProgressMeter(Color[] colorArray) {
        this.colors = colorArray;
        this.values = new int[colorArray.length];
    }

    public AccessibleContext getAccessibleContext() {
        if (this.ac == null) {
            this.ac = new PM_AccessibleContext(this);
        }
        return this.ac;
    }

    public void setIndeterminate(boolean bl) {
        this.indet = bl;
    }

    public void start() {
        if (!this.indet) {
            this.myThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (ProgressMeter.this.myThread == Thread.currentThread()) {
                        try {
                            Thread thread = ProgressMeter.this.myThread;
                            synchronized (thread) {
                                ProgressMeter.this.update();
                                if (ProgressMeter.this.myThread == null) {
                                    break;
                                }
                                ProgressMeter.this.myThread.wait(5000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.myThread.setPriority(3);
            this.myThread.start();
        } else {
            this.clear();
            this.indetTimer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.err.println("updating, width=" + ProgressMeter.this.getSize().width);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.myThread == null) {
            return;
        }
        if (!this.indet) {
            Thread thread = this.myThread;
            Thread thread2 = this.myThread;
            synchronized (thread2) {
                this.myThread = null;
            }
            Thread thread3 = thread;
            synchronized (thread3) {
                thread.notify();
            }
        }
        this.indetTimer.stop();
        this.clear();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        if (this.actionListener != null && this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = ProgressMeter.this.resolve(mouseEvent.getX(), mouseEvent.getY());
                    if (n == -1) {
                        n = ProgressMeter.this.actions.length - 1;
                    }
                    if (n != -1) {
                        ActionEvent actionEvent = new ActionEvent(ProgressMeter.this, 1001, ProgressMeter.this.actions[n]);
                        ProgressMeter.this.actionListener.actionPerformed(actionEvent);
                    }
                }
            };
            this.addMouseListener(this.mouseListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
        if (this.actionListener == null) {
            this.removeMouseListener(this.mouseListener);
        }
    }

    public void clear() {
        this.values = new int[this.colors.length];
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return new Dimension(30, 8);
    }

    public Dimension getPreferredSize() {
        return new Dimension(50, 15);
    }

    public synchronized void set(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2];
            ++n2;
        }
        this.set(nArray, n);
    }

    public synchronized void update() {
        int[] nArray = this.state.getStats();
        this.set(nArray, this.state.getTestsFoundCount());
    }

    public synchronized void set(int[] nArray, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4;
            int n5 = n4 = n == 0 ? 0 : (n2 += nArray[n3]) * 1024 / n;
            if (this.values[n3] != n4) {
                this.values[n3] = n4;
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            this.repaint(100L);
            if (this.ac != null) {
                this.ac.notifyNewStats();
            }
        }
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(Color.white);
        graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
        int n = 0;
        int n2 = 0;
        while (n2 < this.values.length) {
            int n3 = this.values[n2] * (dimension.width - 2) / 1024;
            graphics.setColor(this.colors[n2]);
            graphics.fillRect(1 + n, 1, n3 - n, dimension.height - 2);
            n = n3;
            ++n2;
        }
    }

    int resolve(int n, int n2) {
        Dimension dimension = this.getSize();
        if (n > 0) {
            int n3 = 0;
            while (n3 < this.values.length) {
                int n4 = this.values[n3] * (dimension.width - 2) / 1024;
                if (n < n4) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    private class PM_AccessibleContext
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private ProgressMeter pm;

        PM_AccessibleContext(ProgressMeter progressMeter2) {
            super(ProgressMeter.this);
            this.pm = progressMeter2;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            if (string == null) {
                return this.pm.getToolTipText();
            }
            if (i18n == null) {
                i18n = I18NResourceBundle.getBundleForClass(this.getClass());
            }
            return i18n.getString("pmtr.desc");
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null) {
                if (i18n == null) {
                    i18n = I18NResourceBundle.getBundleForClass(this.getClass());
                }
                return i18n.getString("pmtr.name");
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            int n = 0;
            int[] nArray = ProgressMeter.this.state.getStats();
            int n2 = 0;
            while (n2 < nArray.length - 1) {
                n += nArray[n2];
                ++n2;
            }
            return new Integer(n);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(ProgressMeter.this.state.getTestsFoundCount());
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        void notifyNewStats() {
        }
    }
}

