/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class PrefsPane
extends Preferences.Pane {
    private UIFactory uif = new UIFactory(this);
    private JCheckBox toolBarChk;
    private ConfigEditorPane configEditorPane;
    private Preferences.Pane[] childPanes;

    PrefsPane() {
        this.initGUI();
    }

    public Preferences.Pane[] getChildPanes() {
        if (this.configEditorPane == null) {
            this.configEditorPane = new ConfigEditorPane();
        }
        if (this.childPanes == null) {
            this.childPanes = new Preferences.Pane[]{this.configEditorPane};
        }
        return this.childPanes;
    }

    public String getText() {
        return this.uif.getI18NString("ep.title");
    }

    public void load(Map map) {
        super.load(map);
        String string = (String)map.get("exec.toolbar");
        this.toolBarChk.setSelected(string == null || string.equals("true"));
    }

    public void save(Map map) {
        super.save(map);
        map.put("exec.toolbar", String.valueOf(this.toolBarChk.isSelected()));
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.createToolBarPanel(), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    private JPanel createToolBarPanel() {
        JPanel jPanel = this.uif.createPanel("exec.prefs", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.setBorder(this.uif.createTitledBorder("ep.toolbar"));
        this.toolBarChk = this.uif.createCheckBox("ep.toolbar", true);
        this.uif.setAccessibleName(this.toolBarChk, "ep.toolbar");
        jPanel.add((Component)this.toolBarChk, gridBagConstraints);
        return jPanel;
    }

    private class ConfigEditorPane
    extends Preferences.Pane {
        private JRadioButton fullBtn;
        private JRadioButton stdBtn;
        private JCheckBox moreInfoChk;

        ConfigEditorPane() {
            this.initGUI();
        }

        public String getText() {
            return PrefsPane.this.uif.getI18NString("ep.ce.title");
        }

        public void load(Map map) {
            String string = (String)map.get("exec.config.view");
            if (string != null && string.equals("std")) {
                this.stdBtn.setSelected(true);
            } else {
                this.fullBtn.setSelected(true);
            }
            String string2 = (String)map.get("exec.config.moreInfo");
            this.moreInfoChk.setSelected(string2 == null || string2.equals("true"));
        }

        public void save(Map map) {
            map.put("exec.config.view", this.stdBtn.isSelected() ? "std" : "full");
            map.put("exec.config.moreInfo", String.valueOf(this.moreInfoChk.isSelected()));
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.createDefaultViewPanel(), gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            this.add(Box.createVerticalGlue(), gridBagConstraints);
        }

        private JPanel createDefaultViewPanel() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(PrefsPane.this.uif.createTitledBorder("ep.ce.defView"));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.fullBtn = PrefsPane.this.uif.createRadioButton("ep.ce.defView.full", buttonGroup);
            jPanel.add((Component)this.fullBtn, gridBagConstraints);
            this.stdBtn = PrefsPane.this.uif.createRadioButton("ep.ce.defView.std", buttonGroup);
            jPanel.add((Component)this.stdBtn, gridBagConstraints);
            this.moreInfoChk = PrefsPane.this.uif.createCheckBox("ep.ce.moreInfo", true);
            PrefsPane.this.uif.setAccessibleName(this.moreInfoChk, "ep.ce.moreInfo");
            gridBagConstraints.insets.top = 10;
            jPanel.add((Component)this.moreInfoChk, gridBagConstraints);
            return jPanel;
        }
    }
}

