/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InitialUrlFilter;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;

class ParameterFilter
extends ObservableTestFilter {
    private InitialUrlFilter iurlFilter;
    private boolean rmInitFiles = true;
    private TestFilter[] filters;
    private String[] initUrls;
    private Parameters params;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$exec$ParameterFilter == null ? (class$com$sun$javatest$exec$ParameterFilter = ParameterFilter.class$("com.sun.javatest.exec.ParameterFilter")) : class$com$sun$javatest$exec$ParameterFilter);
    static /* synthetic */ Class class$com$sun$javatest$exec$ParameterFilter;

    ParameterFilter() {
    }

    public void setFilterTests(boolean bl) {
        this.rmInitFiles = bl;
    }

    public boolean isTestsFiltered() {
        return this.rmInitFiles;
    }

    public String getName() {
        return i18n.getString("pFilter.name");
    }

    public String getDescription() {
        return i18n.getString("pFilter.desc");
    }

    public String getReason() {
        return i18n.getString("pFilter.reason");
    }

    public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
        if (this.filters == null || this.filters.length == 0) {
            if (this.iurlFilter == null) {
                return true;
            }
            return this.iurlFilter.accepts(testDescription);
        }
        int n = 0;
        while (n < this.filters.length) {
            if (!this.filters[n].accepts(testDescription)) {
                return false;
            }
            ++n;
        }
        return !this.rmInitFiles || this.iurlFilter == null || this.iurlFilter.accepts(testDescription);
    }

    public TestFilter[] getTestFilters() {
        TestFilter[] testFilterArray = null;
        testFilterArray = this.rmInitFiles && this.iurlFilter != null ? new TestFilter[this.filters.length + 1] : new TestFilter[this.filters.length];
        System.arraycopy(this.filters, 0, testFilterArray, 0, this.filters.length);
        if (this.rmInitFiles) {
            testFilterArray[testFilterArray.length - 1] = this.iurlFilter;
        }
        return testFilterArray;
    }

    void update(Parameters parameters) {
        Object[] objectArray;
        if (parameters == null) {
            return;
        }
        boolean bl = false;
        if (this.params == null) {
            this.params = parameters;
            this.filters = parameters.getFilters();
            bl = true;
        } else if (parameters != this.params) {
            this.params = parameters;
            this.filters = parameters.getFilters();
            bl = true;
        } else {
            objectArray = parameters.getFilters();
            if (objectArray != null || this.filters != null) {
                if (objectArray == null && this.filters != null || this.filters == null && objectArray != null) {
                    this.filters = objectArray;
                    bl = true;
                } else if (objectArray.length == this.filters.length) {
                    if (!CompositeFilter.equals((TestFilter[])objectArray, this.filters)) {
                        this.filters = objectArray;
                        bl = true;
                    }
                } else {
                    this.filters = objectArray;
                    bl = true;
                }
            }
        }
        objectArray = ParameterFilter.stringsToFiles(parameters.getTests());
        this.iurlFilter = new InitialUrlFilter((File[])objectArray);
        if (bl) {
            this.notifyUpdated(this);
        }
    }

    private static File[] stringsToFiles(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

