/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.ReportBrowser;
import com.sun.javatest.report.Report;
import com.sun.javatest.tool.ReportDirChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class NewReportDialog
extends ToolDialog {
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                Object object;
                block6: {
                    object = actionEvent.getSource();
                    if (object != NewReportDialog.this.browseBtn) break block6;
                    NewReportDialog.this.showReportChooserDialog();
                    break block7;
                }
                if (object != NewReportDialog.this.okBtn) break block7;
                String string = (String)NewReportDialog.this.dirBox.getSelectedItem();
                if (string == null || string.length() == 0) {
                    NewReportDialog.this.uif.showError("nrd.emptyInput");
                    return;
                }
                NewReportDialog.this.reportDir = new File(string);
                try {
                    if (!NewReportDialog.this.reportDir.isDirectory()) {
                        NewReportDialog.this.reportDir.mkdirs();
                    } else if (!Report.isReportDirectory(NewReportDialog.this.reportDir) && !NewReportDialog.this.isEmptyDirectory(NewReportDialog.this.reportDir)) {
                        NewReportDialog.this.uif.showError("nrd.cantUse", NewReportDialog.this.reportDir);
                        return;
                    }
                    NewReportDialog.this.setVisible(false);
                    this.doBgReport();
                }
                catch (SecurityException securityException) {
                    NewReportDialog.this.uif.showError("nrd.cantCreate", securityException.getMessage());
                }
            }
        }

        private void doBgReport() {
            JDialog jDialog = NewReportDialog.this.uif.createWaitDialog("nrd.wait", SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = NewReportDialog.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, NewReportDialog.this.parent));
            Thread thread = new Thread(this, jDialog){
                private final /* synthetic */ JDialog val$d;
                private final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$d = jDialog;
                }

                public void run() {
                    try {
                        NewReportDialog.access$1300(2.access$1200(this.this$1));
                        2.access$1400(this.this$1, this.val$d);
                    }
                    catch (IOException iOException) {
                        2.access$1500(this.this$1, "nrd.cantWrite", iOException.getMessage(), this.val$d);
                    }
                    catch (SecurityException securityException) {
                        2.access$1500(this.this$1, "nrd.cantCreate", securityException.getMessage(), this.val$d);
                    }
                }
            };
            ActionListener actionListener = new ActionListener(this, thread, jDialog){
                private final /* synthetic */ Thread val$t;
                private final /* synthetic */ JDialog val$d;
                private final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$t = thread;
                    this.val$d = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$t.isAlive()) {
                        this.val$d.show();
                    }
                }
            };
            Timer timer = new Timer(3000, actionListener);
            timer.setRepeats(false);
            timer.start();
            thread.start();
        }

        private void finishReport(JDialog jDialog) {
            EventQueue.invokeLater(new Runnable(this, jDialog){
                private final /* synthetic */ JDialog val$waitDialog;
                private final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$waitDialog = jDialog;
                }

                public void run() {
                    this.val$waitDialog.hide();
                    int n = NewReportDialog.access$1600(2.access$1200(this.this$1)).showYesNoDialog("nrd.showReport");
                    switch (n) {
                        case 0: {
                            2.access$1200(this.this$1).showReportBrowser(NewReportDialog.access$600(2.access$1200(this.this$1)));
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    2.access$1200(this.this$1).notifyUpdate(2.access$1200(this.this$1).getLastState());
                }
            });
        }

        private void showError(String string, String string2, JDialog jDialog) {
            EventQueue.invokeLater(new Runnable(this, jDialog, string, string2){
                private final /* synthetic */ JDialog val$waitDialog;
                private final /* synthetic */ String val$uiKey;
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                    this.val$waitDialog = jDialog;
                    this.val$uiKey = string;
                    this.val$msg = string2;
                }

                public void run() {
                    this.val$waitDialog.hide();
                    NewReportDialog.access$1700(2.access$1200(this.this$1)).showError(this.val$uiKey, this.val$msg);
                }
            });
        }

        static /* synthetic */ NewReportDialog access$1200(2 var0) {
            return var0.NewReportDialog.this;
        }

        static /* synthetic */ void access$1400(2 var0, JDialog jDialog) {
            var0.finishReport(jDialog);
        }

        static /* synthetic */ void access$1500(2 var0, String string, String string2, JDialog jDialog) {
            var0.showError(string, string2, jDialog);
        }
    };
    private Observer[] obs = new Observer[0];
    private ReportDirChooser reportDirChooser;
    private File reportDir;
    private JButton browseBtn;
    private JButton okBtn;
    private JComboBox dirBox;
    private ReportBrowser reportBrowser;
    private InterviewParameters interviewParams;
    private FilterSelectionHandler filterHandler;
    static final String REPORT_DIR = "reportDir";
    private static final String FILTER = "filter";
    private static final int WAIT_DIALOG_DELAY = 3000;
    static /* synthetic */ Class class$javax$swing$JFrame;

    NewReportDialog(Component component, UIFactory uIFactory, FilterConfig filterConfig, ReportBrowser reportBrowser) {
        super(component, uIFactory, "nrd");
        this.filterHandler = filterConfig.createFilterSelectionHandler();
        this.reportBrowser = reportBrowser;
    }

    public void setInterviewParameters(InterviewParameters interviewParameters) {
        this.interviewParams = interviewParameters;
    }

    void setLastState(Map map) {
        String string = (String)map.get(REPORT_DIR);
        String string2 = (String)map.get(FILTER);
        if (this.dirBox == null) {
            this.initGUI();
        }
        this.dirBox.removeAllItems();
        if (string != null && string.length() > 0) {
            this.dirBox.addItem(string);
        } else {
            this.dirBox.addItem("");
        }
        if (string2 != null && string2.length() > 0) {
            this.filterHandler.setFilter(string2);
        }
    }

    Map getLastState() {
        String string = (String)this.dirBox.getSelectedItem();
        String string2 = this.filterHandler.getActiveFilter().getName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null && string.length() > 0) {
            hashMap.put(REPORT_DIR, string);
        }
        if (string2 != null && string2.length() > 0) {
            hashMap.put(FILTER, string2);
        }
        return hashMap;
    }

    void addObserver(Observer observer) {
        this.obs = (Observer[])DynamicArray.append(this.obs, observer);
    }

    void removeObserver(Observer observer) {
        this.obs = (Observer[])DynamicArray.remove((Object[])this.obs, observer);
    }

    void notifyUpdate(Map map) {
        int n = 0;
        while (n < this.obs.length) {
            this.obs[n].update(map);
            ++n;
        }
    }

    protected void initGUI() {
        JComponent jComponent;
        JComponent jComponent2;
        this.setHelp("report.newReport.csh");
        this.setI18NTitle("nrd.title");
        JPanel jPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = NewReportDialog.this.uif.getDotsPerInch();
                return new Dimension(Math.max(dimension.width, 5 * n), dimension.height);
            }
        };
        jPanel.setName("nrd.body");
        jPanel.setFocusable(false);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int n = this.uif.getDotsPerInch();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 10;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        JLabel jLabel = this.uif.createLabel("nrd.dir", true);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.dirBox = this.uif.createChoice("nrd.dir.choice", true, jLabel);
        this.dirBox.setMaximumRowCount(1);
        jPanel.add((Component)this.dirBox, gridBagConstraints2);
        this.browseBtn = this.uif.createButton("nrd.browse", this.listener);
        this.browseBtn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 0.0;
        jPanel.add((Component)this.browseBtn, gridBagConstraints2);
        if (this.filterHandler != null) {
            jComponent2 = this.uif.createLabel("nrd.filter", true);
            jPanel.add((Component)jComponent2, gridBagConstraints);
            jComponent = this.filterHandler.getFilterSelector();
            jComponent2.setLabelFor(jComponent);
            gridBagConstraints2.weightx = 1.0;
            jPanel.add((Component)jComponent, gridBagConstraints2);
        }
        this.setBody(jPanel);
        this.okBtn = this.uif.createButton("nrd.ok", this.listener);
        jComponent2 = this.uif.createCancelButton("nrd.cancel");
        jComponent = this.uif.createHelpButton("nrd.help", "report.newReport.csh");
        this.setButtons(new JButton[]{this.okBtn, jComponent2, jComponent}, (JButton)jComponent2);
    }

    private void showReportChooserDialog() {
        ReportDirChooser reportDirChooser = this.getReportDirChooser();
        reportDirChooser.setMode(0);
        int n = reportDirChooser.showDialog(this.dirBox);
        if (n != 0) {
            return;
        }
        this.dirBox.setSelectedItem(reportDirChooser.getSelectedFile().getAbsolutePath());
    }

    private ReportDirChooser getReportDirChooser() {
        if (this.reportDirChooser == null) {
            this.reportDirChooser = new ReportDirChooser();
        }
        return this.reportDirChooser;
    }

    void showReportBrowser(File file) {
        File file2 = new File(file, Report.getReportFilename());
        this.reportBrowser.show(file2);
    }

    private void runReport() throws IOException {
        Report report;
        if (this.interviewParams != null) {
            report = null;
            if (this.interviewParams.getWorkDirectory() == null) {
                throw new IOException(this.uif.getI18NString("nrd.noWorkDir.err"));
            }
        } else {
            throw new IOException(this.uif.getI18NString("nrd.nullParams.err"));
        }
        report = this.filterHandler != null ? new Report(this.interviewParams, this.reportDir, this.filterHandler.getActiveFilter()) : new Report(this.interviewParams, this.reportDir);
        report.writeReport();
    }

    private boolean isEmptyDirectory(File file) {
        return file.isDirectory() && file.list().length == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$1300(NewReportDialog newReportDialog) throws IOException {
        newReportDialog.runReport();
    }

    static /* synthetic */ UIFactory access$1600(NewReportDialog newReportDialog) {
        return newReportDialog.uif;
    }

    static /* synthetic */ UIFactory access$1700(NewReportDialog newReportDialog) {
        return newReportDialog.uif;
    }

    static interface Observer {
        public void update(Map var1);
    }
}

