/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.DynamicArray;
import java.awt.EventQueue;
import java.util.Vector;

class MonitorState {
    private Harness harness;
    private boolean running;
    private Observer[] obs = new Observer[0];
    private volatile int[] stats;
    private Vector runningTests = new Vector(1, 2);
    private final Object vLock = new Object();
    private long startTime;
    private long finishTime;
    private Dispatcher dispatcher = new Dispatcher();

    MonitorState(Harness harness) {
        harness.addObserver(this.dispatcher);
        this.harness = harness;
        this.startTime = -1L;
        this.finishTime = -1L;
        this.stats = new int[4];
    }

    void addObserver(Observer observer) {
        this.obs = (Observer[])DynamicArray.append(this.obs, observer);
    }

    void removeObserver(Observer observer) {
        this.obs = (Observer[])DynamicArray.remove((Object[])this.obs, observer);
    }

    boolean isRunning() {
        return this.running;
    }

    long getElapsedTime() {
        return this.harness.getElapsedTime();
    }

    synchronized long getEstimatedTime() {
        return this.harness.getEstimatedTime();
    }

    synchronized int getEstimatedTotalTests() {
        WorkDirectory workDirectory = this.harness.getResultTable().getWorkDir();
        if (workDirectory == null) {
            return -1;
        }
        int n = workDirectory.getTestSuiteTestCount();
        if (n == -1) {
            n = workDirectory.getTestSuite().getEstimatedTestCount();
        }
        return n < 0 ? -1 : n;
    }

    synchronized int getTestsFoundCount() {
        return this.harness.getTestsFoundCount();
    }

    synchronized int getTestsDoneCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.stats.length) {
            n += this.stats[n2];
            ++n2;
        }
        return n;
    }

    synchronized int getTestsRemainingCount() {
        return this.getTestsFoundCount() - this.getTestsDoneCount();
    }

    synchronized int[] getStats() {
        int[] nArray = new int[this.stats.length];
        System.arraycopy(this.stats, 0, nArray, 0, this.stats.length);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TestResult[] getRunningTests() {
        Object[] objectArray = null;
        Object object = this.vLock;
        synchronized (object) {
            objectArray = new TestResult[this.runningTests.size()];
            this.runningTests.copyInto(objectArray);
        }
        return objectArray;
    }

    private synchronized void incrementStat(int n) {
        int n2 = n;
        this.stats[n2] = this.stats[n2] + 1;
    }

    private synchronized void resetStats() {
        this.stats = new int[4];
    }

    class Dispatcher
    implements Harness.Observer {
        Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startingTestRun(Parameters parameters) {
            MonitorState.this.running = true;
            MonitorState.this.startTime = System.currentTimeMillis();
            MonitorState.this.finishTime = -1L;
            MonitorState.this.resetStats();
            Object object = MonitorState.this.vLock;
            synchronized (object) {
                MonitorState.this.runningTests.clear();
            }
            this.notifySimple(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startingTest(TestResult testResult) {
            Object object = MonitorState.this.vLock;
            synchronized (object) {
                MonitorState.this.runningTests.add(testResult);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishedTest(TestResult testResult) {
            Object object = MonitorState.this.vLock;
            synchronized (object) {
                MonitorState.this.runningTests.remove(testResult);
            }
            MonitorState.this.incrementStat(testResult.getStatus().getType());
        }

        public void stoppingTestRun() {
            this.notifySimple(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishedTesting() {
            MonitorState.this.finishTime = System.currentTimeMillis();
            Object object = MonitorState.this.vLock;
            synchronized (object) {
                MonitorState.this.runningTests.clear();
            }
            this.notifySimple(2);
        }

        public void finishedTestRun(boolean bl) {
            MonitorState.this.running = false;
            this.notifyComplete(bl);
        }

        public void error(String string) {
        }

        private void notifySimple(int n) {
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, n){
                    private final /* synthetic */ int val$which;
                    private final /* synthetic */ Dispatcher this$1;
                    {
                        this.this$1 = dispatcher;
                        this.val$which = n;
                    }

                    public void run() {
                        Dispatcher.access$700(this.this$1, this.val$which);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                int n2 = 0;
                while (n2 < MonitorState.this.obs.length) {
                    switch (n) {
                        case 0: {
                            MonitorState.this.obs[n2].starting();
                            break;
                        }
                        case 1: {
                            MonitorState.this.obs[n2].stopping();
                            break;
                        }
                        case 2: {
                            MonitorState.this.obs[n2].postProcessing();
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    ++n2;
                }
            }
        }

        private void notifyComplete(boolean bl) {
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, bl){
                    private final /* synthetic */ boolean val$allOk;
                    private final /* synthetic */ Dispatcher this$1;
                    {
                        this.this$1 = dispatcher;
                        this.val$allOk = bl;
                    }

                    public void run() {
                        Dispatcher.access$900(this.this$1, this.val$allOk);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                int n = 0;
                while (n < MonitorState.this.obs.length) {
                    MonitorState.this.obs[n].finished(bl);
                    ++n;
                }
            }
        }

        static /* synthetic */ void access$700(Dispatcher dispatcher, int n) {
            dispatcher.notifySimple(n);
        }

        static /* synthetic */ void access$900(Dispatcher dispatcher, boolean bl) {
            dispatcher.notifyComplete(bl);
        }
    }

    static interface Observer {
        public void starting();

        public void postProcessing();

        public void stopping();

        public void finished(boolean var1);
    }
}

