/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;

class MessageStrip
extends JSplitPane
implements Harness.Observer,
ComponentListener {
    private JTextField leftField;
    private JPanel rightPanel;
    private JSplitPane sPane;
    private JButton selectButt;
    private JButton magButt;
    private JPopupMenu popMenu;
    private PopupListener popupListener = new PopupListener();
    private ActionListener zoomListener;
    private Monitor[] monitors;
    private MonitorState state;
    private int currMonitor;
    private UIFactory uif;
    private static final String MINI_PREF = "exec.monitorstrip.mini";

    MessageStrip(UIFactory uIFactory, Monitor[] monitorArray, MonitorState monitorState, ActionListener actionListener) {
        this.uif = uIFactory;
        this.monitors = monitorArray;
        this.state = monitorState;
        this.zoomListener = actionListener;
        this.sPane = new JSplitPane();
        this.setOrientation(1);
        this.leftField = uIFactory.createOutputField("strip.msg");
        this.leftField.setOpaque(false);
        this.setLeftComponent(this.leftField);
        this.setRightComponent(this.createRightPanel());
        this.setDividerLocation(0.7);
        this.setDividerSize(5);
        this.setEnabled(true);
        this.addComponentListener(this);
        uIFactory.setAccessibleInfo(this, "strip");
    }

    public void startingTestRun(Parameters parameters) {
        this.setText(this.leftField, this.uif.getI18NString("strip.start"));
    }

    public void startingTest(TestResult testResult) {
        this.setText(this.leftField, this.uif.getI18NString("strip.running", testResult.getTestName()));
    }

    public void finishedTest(TestResult testResult) {
    }

    public void stoppingTestRun() {
        this.setText(this.leftField, this.uif.getI18NString("strip.stop"));
    }

    public void finishedTesting() {
        this.setText(this.leftField, this.uif.getI18NString("strip.cleanup"));
    }

    public void finishedTestRun(boolean bl) {
        this.setText(this.leftField, this.uif.getI18NString("strip.finish"));
    }

    public void error(String string) {
    }

    void showMessage(ResourceBundle resourceBundle, String string) {
        this.setText(this.leftField, resourceBundle.getString(string));
    }

    private void setText(JTextComponent jTextComponent, String string) {
        if (EventQueue.isDispatchThread()) {
            jTextComponent.setText(string);
        } else {
            EventQueue.invokeLater(new BranchPanel.TextUpdater(jTextComponent, string, this.uif));
        }
    }

    private JPopupMenu createMenu() {
        JPopupMenu jPopupMenu = this.uif.createPopupMenu("strip.menu");
        int n = 0;
        while (n < this.monitors.length) {
            JMenuItem jMenuItem = this.uif.createLiteralMenuItem(this.monitors[n].getSmallMonitorName(), this.popupListener);
            jMenuItem.setActionCommand(Integer.toString(n));
            jPopupMenu.add(jMenuItem);
            ++n;
        }
        return jPopupMenu;
    }

    private JComponent createRightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.rightPanel = new JPanel(new BorderLayout());
        this.currMonitor = this.getDefaultSmallMonitor();
        this.rightPanel.add((Component)this.monitors[this.currMonitor].getSmallMonitor(), "Center");
        jPanel.add((Component)this.rightPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        this.selectButt = this.uif.createIconButton("strip.drop");
        this.selectButt.addMouseListener(this.popupListener);
        this.selectButt.addActionListener(this.popupListener);
        this.uif.setAccessibleName(this.selectButt, "strip.drop");
        gridBagConstraints.gridx = 2;
        this.magButt = this.uif.createIconButton("strip.magnify");
        this.magButt.addActionListener(this.popupListener);
        this.uif.setAccessibleName(this.magButt, "strip.magnify");
        JToolBar jToolBar = this.uif.createToolBar("strip.tb", new JButton[]{this.selectButt, this.magButt});
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(true);
        jPanel.add((Component)jToolBar, gridBagConstraints);
        jPanel.setEnabled(true);
        jPanel.setVisible(true);
        this.rightPanel.setEnabled(true);
        this.rightPanel.setVisible(true);
        return jPanel;
    }

    private int getDefaultSmallMonitor() {
        int n;
        block4: {
            Preferences preferences = Preferences.access();
            String string = preferences.getPreference(MINI_PREF, null);
            n = 0;
            if (string == null || this.monitors == null) break block4;
            try {
                int n2 = 0;
                while (n2 < this.monitors.length) {
                    if (this.monitors[n2].getClass().getName().equals(string)) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setDividerLocation(0.7);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    class PopupListener
    extends MouseAdapter
    implements ActionListener {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                Object object;
                block5: {
                    block3: {
                        object = actionEvent.getSource();
                        if (object != MessageStrip.this.magButt) break block3;
                        MessageStrip.this.zoomListener.actionPerformed(actionEvent);
                        break block4;
                    }
                    if (object != MessageStrip.this.selectButt) break block5;
                    this.showPopup(MessageStrip.this.selectButt, ((MessageStrip)MessageStrip.this).selectButt.getSize().width / 2, ((MessageStrip)MessageStrip.this).selectButt.getSize().height / 2);
                    break block4;
                }
                if (!(object instanceof JMenuItem)) break block4;
                try {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    if (MessageStrip.this.currMonitor == n || n >= MessageStrip.this.monitors.length) {
                        return;
                    }
                    MessageStrip.this.currMonitor = n;
                    MessageStrip.this.rightPanel.removeAll();
                    JComponent jComponent = MessageStrip.this.monitors[n].getSmallMonitor();
                    MessageStrip.this.rightPanel.add((Component)jComponent, "Center");
                    MessageStrip.this.validate();
                    Preferences preferences = Preferences.access();
                    preferences.setPreference(MessageStrip.MINI_PREF, MessageStrip.this.monitors[n].getClass().getName());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == MessageStrip.this.selectButt) {
                this.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void showPopup(Component component, int n, int n2) {
            if (MessageStrip.this.popMenu == null) {
                MessageStrip.this.popMenu = MessageStrip.this.createMenu();
            }
            MessageStrip.this.popMenu.show(component, n, n2);
        }
    }
}

