/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestFilter;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.RenderingUtilities;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.OrderedTwoWayTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;

class FilterSelectionHandler {
    private FilterConfig filterConfig;
    private UIFactory uif;
    private TestFilter activeFilter;
    private JComboBox selectBox;
    private JButton configButton;
    private JMenu editMenu;
    private ButtonGroup menuGroup;
    private Listener listener;
    private Observer[] obs = new Observer[0];
    private OrderedTwoWayTable filterMenuTable;
    private static boolean debug = Debug.getBoolean(class$com$sun$javatest$exec$FilterConfig == null ? (class$com$sun$javatest$exec$FilterConfig = FilterSelectionHandler.class$("com.sun.javatest.exec.FilterConfig")) : class$com$sun$javatest$exec$FilterConfig);
    static /* synthetic */ Class class$com$sun$javatest$exec$FilterConfig;

    FilterSelectionHandler(FilterConfig filterConfig, UIFactory uIFactory) {
        this.filterConfig = filterConfig;
        this.uif = uIFactory;
        this.listener = new Listener();
        this.filterConfig.addObserver(this.listener);
    }

    public void addObserver(Observer observer) {
        if (observer == null) {
            return;
        }
        if (this.obs == null) {
            this.obs = new Observer[0];
        }
        this.obs = (Observer[])DynamicArray.append(this.obs, observer);
    }

    public void removeObserver(Observer observer) {
        this.obs = (Observer[])DynamicArray.remove((Object[])this.obs, observer);
    }

    JComponent getFilterSelector() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.selectBox = this.uif.createLiteralChoice("fconfig.box", this.filterConfig.getFilters());
        this.selectBox.addActionListener(this.listener);
        this.selectBox.setRenderer(RenderingUtilities.createFilterListRenderer());
        this.uif.setAccessibleName(this.selectBox, "fconfig.box");
        jPanel.add((Component)this.selectBox, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        this.configButton = this.uif.createButton("fconfig.config");
        this.configButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.configButton.addActionListener(this.listener);
        this.uif.setAccessibleName(this.configButton, "fconfig.config");
        jPanel.add((Component)this.configButton, gridBagConstraints);
        if (this.activeFilter == null) {
            TestFilter[] testFilterArray = this.filterConfig.getFilters();
            if (testFilterArray != null && testFilterArray.length > 0) {
                this.setFilter(testFilterArray[0]);
            }
        } else {
            this.selectBox.setSelectedItem(this.activeFilter);
        }
        return jPanel;
    }

    synchronized JMenu getFilterMenu() {
        this.menuGroup = new ButtonGroup();
        this.filterMenuTable = new OrderedTwoWayTable();
        ToolAction toolAction = new ToolAction(this.uif, "fconfig.submenu.edit"){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterSelectionHandler.this.filterConfig.showEditorDialog();
            }
        };
        this.editMenu = this.uif.createMenu("fconfig.submenu");
        TestFilter[] testFilterArray = this.filterConfig.getFilters();
        int n = 0;
        while (n < testFilterArray.length) {
            this.addToMenu(testFilterArray[n], -1);
            ++n;
        }
        if (this.activeFilter == null && testFilterArray != null && testFilterArray.length > 0) {
            this.setFilter(testFilterArray[0]);
        }
        this.editMenu.addSeparator();
        this.editMenu.add(this.uif.createMenuItem(toolAction));
        this.updateMenu();
        return this.editMenu;
    }

    synchronized void setFilter(String string) {
        this.setFilter(this.filterConfig.getFilter(string));
    }

    synchronized void setFilter(TestFilter testFilter) {
        if (testFilter == null) {
            return;
        }
        if (this.filterConfig.contains(testFilter)) {
            this.activeFilter = testFilter;
            if (this.selectBox != null) {
                this.selectBox.setSelectedItem(this.activeFilter);
            }
            this.updateMenu();
            int n = 0;
            while (n < this.obs.length) {
                this.obs[n].filterSelected(testFilter);
                ++n;
            }
        }
    }

    synchronized TestFilter getActiveFilter() {
        return this.activeFilter;
    }

    void updateFilterMetaInfo(TestFilter testFilter) {
        int n;
        if (this.activeFilter == testFilter && this.selectBox != null) {
            this.selectBox.repaint();
        }
        if (this.editMenu != null && (n = this.filterMenuTable.getKeyIndex(testFilter)) >= 0) {
            JMenuItem jMenuItem = (JMenuItem)this.filterMenuTable.getValueAt(n);
            jMenuItem.setText(testFilter.getName());
        }
    }

    private synchronized void addToMenu(TestFilter testFilter, int n) {
        Object object;
        if (this.editMenu == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.editMenu.getItemCount()) {
            object = this.editMenu.getItem(n3);
            if (object != null) {
                n2 = Math.max(n2, ((AbstractButton)object).getMnemonic());
            }
            ++n3;
        }
        n2 = n2 == 0 ? 48 : (n2 < 57 ? ++n2 : 0);
        object = (char)(n2 == 0 ? 32 : (char)n2) + " " + testFilter.getName();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem((String)object);
        jRadioButtonMenuItem.setName(testFilter.getName());
        if (n2 != 0) {
            jRadioButtonMenuItem.setMnemonic(n2);
        }
        jRadioButtonMenuItem.getAccessibleContext().setAccessibleDescription(testFilter.getDescription());
        jRadioButtonMenuItem.addActionListener(this.listener);
        this.menuGroup.add(jRadioButtonMenuItem);
        this.filterMenuTable.put(testFilter, jRadioButtonMenuItem);
        if (n < 0) {
            this.editMenu.insert(jRadioButtonMenuItem, this.menuGroup.getButtonCount() - 1);
        } else {
            this.editMenu.insert(jRadioButtonMenuItem, n);
        }
        if (testFilter == this.activeFilter) {
            jRadioButtonMenuItem.setEnabled(true);
        }
    }

    private synchronized void removeFromMenu(TestFilter testFilter) {
        if (this.editMenu == null) {
            return;
        }
        int n = this.filterMenuTable.getKeyIndex(testFilter);
        if (n != -1) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.filterMenuTable.getValueAt(n);
            this.editMenu.remove(jRadioButtonMenuItem);
            this.filterMenuTable.remove(n);
            this.menuGroup.remove(jRadioButtonMenuItem);
        }
    }

    private void updateMenu() {
        if (this.editMenu == null) {
            return;
        }
        int n = this.filterMenuTable.getKeyIndex(this.activeFilter);
        if (n != -1) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.filterMenuTable.getValueAt(n);
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Listener
    implements ActionListener,
    FilterConfig.Observer {
        Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            if (object == FilterSelectionHandler.this.selectBox) {
                String string = actionEvent.getActionCommand();
                TestFilter testFilter = (TestFilter)FilterSelectionHandler.this.selectBox.getSelectedItem();
                if (testFilter == FilterSelectionHandler.this.getActiveFilter()) {
                    if (debug) {
                        Debug.println("FC - keeping filter");
                    }
                    return;
                }
                if (debug) {
                    Debug.println("FC - changing filter");
                }
                FilterSelectionHandler.this.setFilter(testFilter);
            } else if (object == FilterSelectionHandler.this.configButton) {
                FilterSelectionHandler.this.filterConfig.showEditorDialog();
            } else if (object instanceof JRadioButtonMenuItem && (n = FilterSelectionHandler.this.filterMenuTable.getValueIndex(object)) != -1) {
                TestFilter testFilter = (TestFilter)FilterSelectionHandler.this.filterMenuTable.getKeyAt(n);
                FilterSelectionHandler.this.setFilter(testFilter);
            }
        }

        public void filterUpdated(TestFilter testFilter) {
            if (FilterSelectionHandler.this.obs == null) {
                return;
            }
            if (FilterSelectionHandler.this.activeFilter == testFilter) {
                int n = 0;
                while (n < FilterSelectionHandler.this.obs.length) {
                    FilterSelectionHandler.this.obs[n].filterUpdated(testFilter);
                    ++n;
                }
            }
        }

        public void filterAdded(TestFilter testFilter) {
            if (FilterSelectionHandler.this.selectBox != null) {
                FilterSelectionHandler.this.selectBox.addItem(testFilter);
            }
            FilterSelectionHandler.this.addToMenu(testFilter, -1);
            int n = 0;
            while (n < FilterSelectionHandler.this.obs.length) {
                FilterSelectionHandler.this.obs[n].filterAdded(testFilter);
                ++n;
            }
        }

        public void filterRemoved(TestFilter testFilter) {
            if (FilterSelectionHandler.this.selectBox != null) {
                FilterSelectionHandler.this.selectBox.removeItem(testFilter);
            }
            FilterSelectionHandler.this.removeFromMenu(testFilter);
            int n = 0;
            while (n < FilterSelectionHandler.this.obs.length) {
                FilterSelectionHandler.this.obs[n].filterRemoved(testFilter);
                ++n;
            }
        }
    }

    public static interface Observer {
        public void filterUpdated(TestFilter var1);

        public void filterSelected(TestFilter var1);

        public void filterAdded(TestFilter var1);

        public void filterRemoved(TestFilter var1);
    }
}

