/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.ConfigurableTestFilter;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.RenderingUtilities;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FilterConfig {
    private TestFilter[] filters = new TestFilter[0];
    private UIFactory uif;
    private ExecModel execModel;
    private Listener listener = new Listener();
    private Observer[] obs = new Observer[0];
    private FilterSelectionHandler[] handlers;
    private FilterEditorPanel fep;
    private JComponent parentComponent;
    private static boolean debug = Debug.getBoolean(class$com$sun$javatest$exec$FilterConfig == null ? (class$com$sun$javatest$exec$FilterConfig = FilterConfig.class$("com.sun.javatest.exec.FilterConfig")) : class$com$sun$javatest$exec$FilterConfig);
    static /* synthetic */ Class class$com$sun$javatest$exec$FilterConfig;

    public FilterConfig(ExecModel execModel, JComponent jComponent) {
        this.uif = new UIFactory(this.getClass());
        this.execModel = execModel;
        this.parentComponent = jComponent;
    }

    synchronized void add(TestFilter testFilter) {
        if (testFilter == null) {
            return;
        }
        this.filters = (TestFilter[])DynamicArray.append(this.filters, testFilter);
        if (testFilter instanceof ObservableTestFilter) {
            ((ObservableTestFilter)testFilter).addObserver(this.listener);
        }
        if (testFilter instanceof ConfigurableTestFilter && this.fep != null) {
            this.fep.addConfigurableFilter((ConfigurableTestFilter)testFilter);
        }
        int n = 0;
        while (n < this.obs.length) {
            this.obs[n].filterAdded(testFilter);
            ++n;
        }
        if (this.fep != null) {
            this.fep.listModel.addElement(testFilter);
        }
    }

    synchronized void remove(TestFilter testFilter) {
        if (testFilter == null) {
            return;
        }
        this.filters = (TestFilter[])DynamicArray.remove((Object[])this.filters, testFilter);
        if (testFilter instanceof ObservableTestFilter) {
            ((ObservableTestFilter)testFilter).removeObserver(this.listener);
        }
        if (testFilter instanceof ConfigurableTestFilter && this.fep != null) {
            this.fep.removeConfigurableFilter((ConfigurableTestFilter)testFilter);
        }
        int n = 0;
        while (n < this.obs.length) {
            this.obs[n].filterRemoved(testFilter);
            ++n;
        }
        if (this.fep != null) {
            this.fep.listModel.removeElement(testFilter);
        }
    }

    synchronized String[] getFilterNames() {
        int n = this.filters.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.filters[n2].getName();
            ++n2;
        }
        return stringArray;
    }

    synchronized TestFilter[] getFilters() {
        int n = this.filters.length;
        TestFilter[] testFilterArray = new TestFilter[n];
        System.arraycopy(this.filters, 0, testFilterArray, 0, n);
        return testFilterArray;
    }

    synchronized TestFilter getFilter(String string) {
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this.filters[n2].getName())) {
                return this.filters[n2];
            }
            ++n2;
        }
        return null;
    }

    synchronized boolean contains(TestFilter testFilter) {
        int n = 0;
        while (n < this.filters.length) {
            if (this.filters[n] == testFilter) {
                return true;
            }
            ++n;
        }
        return false;
    }

    synchronized FilterSelectionHandler createFilterSelectionHandler() {
        FilterSelectionHandler filterSelectionHandler = new FilterSelectionHandler(this, this.uif);
        this.handlers = (FilterSelectionHandler[])DynamicArray.append(this.handlers, filterSelectionHandler);
        return filterSelectionHandler;
    }

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            return;
        }
        if (this.obs == null) {
            this.obs = new Observer[0];
        }
        this.obs = (Observer[])DynamicArray.append(this.obs, observer);
    }

    public synchronized void removeObserver(Observer observer) {
        this.obs = (Observer[])DynamicArray.remove((Object[])this.obs, observer);
    }

    synchronized void notifyUpdated(TestFilter testFilter) {
        if (this.obs == null) {
            return;
        }
        int n = 0;
        while (n < this.obs.length) {
            this.obs[n].filterUpdated(testFilter);
            ++n;
        }
    }

    synchronized void showEditorDialog() {
        if (this.fep == null) {
            this.fep = new FilterEditorPanel(this.parentComponent, this.uif);
        }
        this.fep.setVisible(true);
    }

    synchronized void hideEditorDialog(Frame frame) {
        this.fep.setVisible(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FilterEditorPanel
    extends ToolDialog
    implements ListSelectionListener,
    ActionListener {
        private JSplitPane split;
        private JList leftList;
        private DefaultListModel listModel;
        private int lastSelected = -1;
        private TestFilter selectedFilter;
        private int mode;
        private static final int EDITABLE = 0;
        private static final int UNEDITABLE = 1;
        private JButton applyBut;
        private JButton helpBut;
        private JButton doneBut;
        private JButton cancelBut;
        private JButton createBut;
        private JButton deleteBut;
        private JButton resetBut;
        private JTextArea infoDesc;
        private JTextField infoName;
        private CardLayout nameCards;
        private JPanel namePanel;
        private JTextField namingName;
        private CardLayout configCards;
        private JPanel configPanel;
        private Hashtable configPanelHash;
        private int configCounter;
        private JComponent EMPTY_CONFIG;
        private JComponent EMPTY_NAMING;
        private JComponent EMPTY_INFO;
        private int NUMBER;
        private static final String CONFIG_ACTIVE = "configa";
        private static final String CONFIG_EMPTY = "confige";
        private static final String NAMING_ACTIVE = "naminga";
        private static final String NAMING_EMPTY = "naminge";
        private static final String INFO_ACTIVE = "infoa";
        private static final String INFO_EMPTY = "infoe";

        FilterEditorPanel(Component component, UIFactory uIFactory) {
            super(component, uIFactory, "fconfig");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = null;
            if (object == this.doneBut) {
                if (this.mode == 0) {
                    string = this.doApply();
                }
                if (string == null) {
                    this.setVisible(false);
                }
            } else if (object == this.applyBut) {
                string = this.doApply();
            } else if (object == this.resetBut) {
                if (this.mode == 0) {
                    this.doReset();
                }
            } else if (object == this.cancelBut) {
                if (this.mode == 0) {
                    this.doReset();
                }
                this.setVisible(false);
            }
            if (string != null) {
                this.uif.showError("fconfig.commit", string);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.leftList.getSelectedIndex();
            if (n < 0) {
                this.selectIndex(0);
                this.lastSelected = 0;
            } else if (n != this.lastSelected) {
                this.selectIndex(n);
                this.lastSelected = n;
            }
        }

        private void selectIndex(int n) {
            this.leftList.setSelectedIndex(n);
            this.selectedFilter = (TestFilter)this.listModel.elementAt(n);
            if (this.selectedFilter instanceof ConfigurableTestFilter) {
                if (this.mode == -1 || this.mode == 1) {
                    this.nameCards.show(this.namePanel, NAMING_ACTIVE);
                    this.applyBut.setEnabled(true);
                    this.resetBut.setEnabled(true);
                    this.mode = 0;
                }
                ConfigurableTestFilter configurableTestFilter = (ConfigurableTestFilter)this.selectedFilter;
                this.namingName.setText(configurableTestFilter.getName());
                String string = (String)this.configPanelHash.get(configurableTestFilter);
                this.configCards.show(this.configPanel, string);
            } else if (this.selectedFilter instanceof TestFilter && (this.mode == -1 || this.mode == 0)) {
                this.nameCards.show(this.namePanel, NAMING_EMPTY);
                this.configCards.show(this.configPanel, CONFIG_EMPTY);
                this.applyBut.setEnabled(false);
                this.resetBut.setEnabled(false);
                this.mode = 1;
            }
            this.fillInfo(this.selectedFilter);
            this.leftList.requestFocus();
        }

        protected void initGUI() {
            this.setHelp("execFilters.dialog.csh");
            TestSuite testSuite = FilterConfig.this.execModel.getTestSuite();
            String string = testSuite == null ? this.uif.getI18NString("fconfig.dTitle.unknown") : testSuite.getName();
            this.setI18NTitle("fconfig.dTitle", string);
            JPanel jPanel = this.uif.createPanel("fe.body", false);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.leftList = this.uif.createList("fconfig.list");
            this.leftList.setModel(this.createListModel());
            this.leftList.setCellRenderer(RenderingUtilities.createFilterListRenderer());
            this.leftList.addListSelectionListener(this);
            this.leftList.setBorder(BorderFactory.createEtchedBorder());
            this.leftList.getInsets().left = 5;
            this.leftList.getInsets().right = 5;
            this.uif.setAccessibleInfo(this.leftList, "fconfig.list");
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(this.uif.createTitledBorder("fconfig.list"));
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this.leftList, "Center");
            jPanel.add((Component)jPanel2, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 1;
            JComponent jComponent = this.createRightPanel();
            jPanel.add((Component)jComponent, gridBagConstraints);
            int n = this.uif.getDotsPerInch();
            jPanel.setPreferredSize(new Dimension(7 * n, 5 * n));
            this.setBody(jPanel);
            this.initButtons();
            this.setComponentListener(FilterConfig.this.listener);
            this.mode = -1;
            this.selectIndex(0);
        }

        private ListModel createListModel() {
            this.listModel = new DefaultListModel();
            int n = 0;
            while (n < FilterConfig.this.filters.length) {
                this.listModel.addElement(FilterConfig.this.filters[n]);
                ++n;
            }
            return this.listModel;
        }

        private JComponent createRightPanel() {
            this.EMPTY_CONFIG = this.createEmptyItem("fconfig.empt.conf");
            this.EMPTY_NAMING = this.createEmptyItem("fconfig.empt.name");
            this.EMPTY_CONFIG.setName("config");
            this.EMPTY_NAMING.setName("naming");
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setName("rightFilter");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            JComponent jComponent = this.createInfoPanel();
            jComponent.setBorder(this.uif.createTitledBorder("fconfig.panel.info"));
            jPanel.add((Component)jComponent, gridBagConstraints);
            jComponent = this.createNamingPanel();
            jComponent.setBorder(this.uif.createTitledBorder("fconfig.panel.naming"));
            jPanel.add((Component)jComponent, gridBagConstraints);
            jComponent = this.createConfigPanel();
            jComponent.setBorder(this.uif.createTitledBorder("fconfig.panel.config"));
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)jComponent, gridBagConstraints);
            return jPanel;
        }

        private JComponent createEmptyItem(String string) {
            JTextField jTextField = this.uif.createHeading(string);
            this.uif.setAccessibleInfo(jTextField, string);
            jTextField.setHorizontalAlignment(0);
            return jTextField;
        }

        private JComponent createInfoPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setName("info");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 5.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.left = 15;
            gridBagConstraints.insets.right = 15;
            JLabel jLabel = this.uif.createLabel("fconfig.info.name");
            this.infoName = this.uif.createOutputField("fconfig.info.name", jLabel);
            this.infoName.setEditable(false);
            this.infoName.setBorder(BorderFactory.createEmptyBorder());
            jLabel.setDisplayedMnemonic(this.uif.getI18NString("fconfig.info.name.mne").charAt(0));
            jLabel.setHorizontalAlignment(4);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.infoName, gridBagConstraints);
            jLabel = this.uif.createLabel("fconfig.info.desc");
            jLabel.setHorizontalAlignment(4);
            this.infoDesc = this.uif.createTextArea("fconfig.info.desc", jLabel);
            this.infoDesc.setRows(3);
            this.infoDesc.setEditable(false);
            this.infoDesc.setBorder(BorderFactory.createEmptyBorder());
            this.infoDesc.setLineWrap(true);
            this.infoDesc.setWrapStyleWord(true);
            this.infoDesc.setOpaque(false);
            jLabel.setDisplayedMnemonic(this.uif.getI18NString("fconfig.info.desc.mne").charAt(0));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 12;
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.infoDesc, gridBagConstraints);
            return jPanel;
        }

        private JPanel createNamingPanel() {
            this.nameCards = new CardLayout();
            this.namePanel = new JPanel(this.nameCards);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 5.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.left = 15;
            gridBagConstraints.insets.right = 15;
            JLabel jLabel = this.uif.createLabel("fconfig.naming.name");
            this.namingName = this.uif.createOutputField("fconfig.naming.name", jLabel);
            this.namingName.setEditable(true);
            this.namingName.setEnabled(true);
            jLabel.setDisplayedMnemonic(this.uif.getI18NString("fconfig.naming.name.mne").charAt(0));
            jLabel.setHorizontalAlignment(4);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.namingName, gridBagConstraints);
            this.namePanel.add(NAMING_ACTIVE, jPanel);
            this.namePanel.add(NAMING_EMPTY, this.EMPTY_NAMING);
            this.nameCards.show(this.namePanel, NAMING_EMPTY);
            return this.namePanel;
        }

        private JPanel createConfigPanel() {
            this.configCards = new CardLayout();
            this.configPanel = new JPanel(this.configCards);
            this.configPanelHash = new Hashtable();
            this.configPanel.add(CONFIG_EMPTY, this.EMPTY_CONFIG);
            int n = 0;
            while (n < this.listModel.getSize()) {
                if (this.listModel.getElementAt(n) instanceof ConfigurableTestFilter) {
                    ConfigurableTestFilter configurableTestFilter = (ConfigurableTestFilter)this.listModel.getElementAt(n);
                    this.addConfigurableFilter(configurableTestFilter);
                }
                ++n;
            }
            return this.configPanel;
        }

        private void initButtons() {
            this.applyBut = this.uif.createButton("fconfig.edit.apply", this);
            this.resetBut = this.uif.createButton("fconfig.edit.reset", this);
            this.cancelBut = this.uif.createCancelButton("fconfig.edit.cancel", this);
            this.doneBut = this.uif.createButton("fconfig.edit.done", this);
            this.helpBut = this.uif.createHelpButton("fconfig.edit.help", "execFilters.dialog.csh");
            this.setButtons(new JButton[]{this.applyBut, this.resetBut, this.cancelBut, this.doneBut, this.helpBut}, this.doneBut);
        }

        private void addConfigurableFilter(ConfigurableTestFilter configurableTestFilter) {
            JComponent jComponent = configurableTestFilter.getEditorPane();
            String string = "ctf" + ++this.configCounter;
            if (jComponent != null) {
                this.configPanel.add(string, jComponent);
            } else {
                this.configPanel.add(string, this.EMPTY_CONFIG);
            }
            this.configPanelHash.put(configurableTestFilter, string);
        }

        private void removeConfigurableFilter(ConfigurableTestFilter configurableTestFilter) {
            this.configPanelHash.remove(configurableTestFilter);
        }

        private void fillInfo(TestFilter testFilter) {
            if (testFilter == null) {
                return;
            }
            if (testFilter instanceof ConfigurableTestFilter) {
                this.infoName.setText(((ConfigurableTestFilter)testFilter).getBaseName());
            } else {
                this.infoName.setText(testFilter.getName());
            }
            this.infoDesc.setText(testFilter.getDescription());
        }

        private void fillNaming(ConfigurableTestFilter configurableTestFilter) {
            this.namingName.setText(configurableTestFilter.getName());
        }

        private String doApply() {
            if (this.mode == 1) {
                throw new IllegalStateException("filter is uneditable, cannot apply changes");
            }
            ConfigurableTestFilter configurableTestFilter = (ConfigurableTestFilter)this.selectedFilter;
            String string = this.namingName.getText();
            if (string != null) {
                configurableTestFilter.setInstanceName(string);
            }
            String string2 = configurableTestFilter.commitEditorSettings();
            if (FilterConfig.this.handlers != null) {
                int n = 0;
                while (n < FilterConfig.this.handlers.length) {
                    FilterConfig.this.handlers[n].updateFilterMetaInfo(configurableTestFilter);
                    ++n;
                }
            }
            return string2;
        }

        void doReset() {
            int n = 0;
            while (n < this.listModel.getSize()) {
                if (this.listModel.elementAt(n) instanceof ConfigurableTestFilter) {
                    ConfigurableTestFilter configurableTestFilter = (ConfigurableTestFilter)this.listModel.elementAt(n);
                    configurableTestFilter.resetEditorSettings();
                }
                ++n;
            }
        }
    }

    private class Listener
    extends ComponentAdapter
    implements ObservableTestFilter.Observer {
        private Listener() {
        }

        public void filterUpdated(ObservableTestFilter observableTestFilter) {
            FilterConfig.this.notifyUpdated(observableTestFilter);
        }

        public void componentHidden(ComponentEvent componentEvent) {
            FilterConfig.this.fep.doReset();
        }
    }

    public static interface Observer {
        public void filterUpdated(TestFilter var1);

        public void filterAdded(TestFilter var1);

        public void filterRemoved(TestFilter var1);
    }
}

