/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.HTMLWriter;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class FilesPane
extends JPanel {
    private File baseDir;
    private URL homeURL;
    private File[] files;
    private JButton homeBtn;
    private JButton backBtn;
    private JButton forwardBtn;
    private JComboBox selectBox;
    private JPanel head;
    private JPanel body;
    private JTextField noteField;
    private HTMLEditorKit htmlKit;
    private JEditorPane textArea;
    private URL currURL;
    private History history;
    private DefaultComboBoxModel model;
    private Listener listener = new Listener();
    private JToolBar toolBar;
    private UIFactory uif;
    private Action homeAction;
    private Action backAction;
    private Action forwardAction;
    private static final int MAX_ROWS_DISPLAY = 20;
    protected static boolean debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$exec$FilesPane == null ? (class$com$sun$javatest$exec$FilesPane = FilesPane.class$("com.sun.javatest.exec.FilesPane")) : class$com$sun$javatest$exec$FilesPane).getName());
    static /* synthetic */ Class class$com$sun$javatest$exec$FilesPane;

    FilesPane(UIFactory uIFactory) {
        this.uif = uIFactory;
        this.history = new History();
        this.initGUI();
    }

    void setBaseDirectory(File file) {
        this.baseDir = file;
    }

    File getBaseDirectory() {
        return this.baseDir;
    }

    void setFile(URL uRL) {
        if (uRL != null) {
            this.setFiles(new URL[]{uRL});
        }
    }

    void setFiles(URL[] uRLArray) {
        this.clear();
        int n = 0;
        while (n < uRLArray.length) {
            if (n == 0) {
                this.homeURL = uRLArray[n];
                this.homeAction.setEnabled(true);
                this.loadPage(this.homeURL);
            }
            this.updateCombo(uRLArray[n]);
            ++n;
        }
    }

    private void initGUI() {
        this.setName("fp");
        this.setFocusable(false);
        this.htmlKit = new HTMLEditorKit();
        this.initActions();
        this.setLayout(new BorderLayout());
        this.initHead();
        this.initBody();
        this.add((Component)this.head, "North");
        this.add((Component)this.body, "Center");
        this.noteField = this.uif.createOutputField("fp.note");
        this.add((Component)this.noteField, "South");
    }

    private void initActions() {
        this.homeAction = new ToolAction(this.uif, "fp.home", true){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FilesPane.this.homeURL == null) {
                    FilesPane.this.textArea.setDocument(new HTMLDocument());
                } else {
                    FilesPane.this.loadPage(FilesPane.this.homeURL);
                }
            }
        };
        this.backAction = new ToolAction(this.uif, "fp.back", true){

            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = FilesPane.this.history.prev();
                if (uRL != null) {
                    FilesPane.this.loadPage(uRL);
                }
            }
        };
        this.forwardAction = new ToolAction(this.uif, "fp.forward", true){

            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = FilesPane.this.history.next();
                if (uRL != null) {
                    FilesPane.this.loadPage(uRL);
                }
            }
        };
    }

    private void initHead() {
        this.head = this.uif.createPanel("fp.head", false);
        this.head.setLayout(new GridBagLayout());
        this.head.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = this.uif.createLabel("fp.file", true);
        this.head.add((Component)jLabel, gridBagConstraints);
        this.selectBox = this.uif.createChoice("fp.choice", jLabel);
        this.selectBox.setRenderer(new Renderer());
        this.selectBox.setModel(this.createModel());
        this.selectBox.addItemListener(this.listener);
        this.selectBox.setMaximumRowCount(20);
        this.uif.setAccessibleName(this.selectBox, "fp.choice");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 2;
        this.head.add((Component)this.selectBox, gridBagConstraints);
        Action[] actionArray = new Action[]{this.backAction, this.forwardAction, null, this.homeAction};
        this.toolBar = this.uif.createToolBar("fp.toolbar", actionArray);
        this.toolBar.setFloatable(false);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets.left = 5;
        this.head.add((Component)this.toolBar, gridBagConstraints);
    }

    private void initBody() {
        this.body = this.uif.createPanel("fp.body", false);
        this.body.setLayout(new BorderLayout());
        this.textArea = new JEditorPane();
        this.textArea.setName("text");
        this.textArea.setEditable(false);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.textArea.addHyperlinkListener(this.listener);
        this.uif.setAccessibleInfo(this.textArea, "fp");
        this.body.add((Component)this.uif.createScrollPane(this.textArea, 20, 31), "Center");
    }

    private void clear() {
        if (this.model != null) {
            this.model.removeAllElements();
        }
        this.history.clear();
        this.backAction.setEnabled(false);
        this.forwardAction.setEnabled(false);
        this.homeAction.setEnabled(false);
        this.homeURL = null;
        this.currURL = null;
        this.textArea.setDocument(new HTMLDocument());
    }

    private void loadPage(URL uRL) {
        if (uRL.equals(this.currURL)) {
            return;
        }
        this.currURL = uRL;
        String string = uRL.getProtocol();
        File file = new File(uRL.getFile());
        if (string.equals("file") && file.isDirectory()) {
            String string2 = this.listLocalDirectory(file);
            HTMLDocument hTMLDocument = (HTMLDocument)this.htmlKit.createDefaultDocument();
            this.textArea.setDocument(hTMLDocument);
            hTMLDocument.setBase(uRL);
            this.textArea.setContentType("text/html");
            this.textArea.setText(string2);
        } else if (string.equals("file") && !uRL.getFile().endsWith(".htm") && !uRL.getFile().endsWith(".html")) {
            this.textArea.setContentType("text/plain");
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                this.textArea.read(bufferedReader, (Object)uRL);
                ((Reader)bufferedReader).close();
            }
            catch (IOException iOException) {
                this.uif.showError("fp.load.error", new Object[]{uRL, iOException});
            }
        } else {
            try {
                URL uRL2 = this.textArea.getPage();
                if (uRL2 == null || !uRL2.sameFile(uRL)) {
                    HTMLDocument hTMLDocument = (HTMLDocument)this.htmlKit.createDefaultDocument();
                    this.textArea.setDocument(hTMLDocument);
                }
                this.textArea.setPage(uRL);
            }
            catch (IOException iOException) {
                this.uif.showError("fp.load.error", new Object[]{uRL, iOException});
            }
        }
        this.history.add(uRL);
        this.backAction.setEnabled(this.history.hasPrev());
        this.forwardAction.setEnabled(this.history.hasNext());
        this.updateCombo(uRL);
    }

    private String listLocalDirectory(File file) {
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        String string = file.getPath();
        if (this.baseDir != null && string.startsWith(this.baseDir.getParent()) && string.length() > this.baseDir.getParent().length()) {
            string = string.substring(this.baseDir.getParent().length() + 1);
        }
        String[] stringArray = file.list();
        StringWriter stringWriter = new StringWriter();
        try {
            HTMLWriter hTMLWriter = new HTMLWriter((Writer)stringWriter, this.uif.getI18NResourceBundle());
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("head");
            hTMLWriter.startTag("title");
            hTMLWriter.write(string);
            hTMLWriter.endTag("title");
            hTMLWriter.endTag("head");
            hTMLWriter.startTag("body");
            hTMLWriter.writeStyleAttr("font-family: SansSerif; font-size: 12pt");
            hTMLWriter.startTag("h3");
            hTMLWriter.writeI18N("fp.head", string);
            hTMLWriter.endTag("h3");
            hTMLWriter.startTag("ul");
            hTMLWriter.writeStyleAttr("margin-left:0");
            File file2 = file.getParentFile();
            if (file2 != null) {
                hTMLWriter.startTag("li");
                hTMLWriter.startTag("object");
                hTMLWriter.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                hTMLWriter.writeParam("type", "up");
                hTMLWriter.endTag("object");
                hTMLWriter.writeEntity("&nbsp;");
                try {
                    hTMLWriter.startTag("a");
                    hTMLWriter.writeAttr("href", file2.toURL().toString());
                    hTMLWriter.writeI18N("fp.parent");
                    hTMLWriter.endTag("a");
                }
                catch (MalformedURLException malformedURLException) {
                    hTMLWriter.writeI18N("fp.parent");
                }
            }
            int n = 0;
            while (n < stringArray.length) {
                File file3 = new File(file, stringArray[n]);
                hTMLWriter.startTag("li");
                hTMLWriter.startTag("object");
                hTMLWriter.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                hTMLWriter.writeParam("type", file3.isDirectory() ? "folder" : "file");
                hTMLWriter.endTag("object");
                hTMLWriter.writeEntity("&nbsp;");
                try {
                    hTMLWriter.writeLink(file3.toURL(), file3.getName());
                }
                catch (MalformedURLException malformedURLException) {
                    hTMLWriter.write(file3.getName());
                }
                ++n;
            }
            hTMLWriter.endTag("ul");
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
            hTMLWriter.close();
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    private void updateCombo(URL uRL) {
        URL uRL2;
        if (this.model.getIndexOf(uRL) < 0) {
            this.model.addElement(uRL);
        }
        if (!(uRL2 = (URL)this.selectBox.getSelectedItem()).equals(uRL)) {
            this.selectBox.setSelectedItem(uRL);
        }
    }

    private DefaultComboBoxModel createModel() {
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
        }
        return this.model;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            if (object instanceof URL) {
                URL uRL = (URL)object;
                if (!uRL.getProtocol().equals("file")) {
                    string = uRL.toString();
                } else {
                    string = this.extractPrefix(uRL.toString(), "file:");
                    if (FilesPane.this.baseDir != null && string.startsWith(FilesPane.this.baseDir.getParent()) && string.length() > FilesPane.this.baseDir.getParent().length()) {
                        string = string.substring(FilesPane.this.baseDir.getParent().length() + 1);
                    }
                }
            } else {
                string = String.valueOf(object);
            }
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }

        private String extractPrefix(String string, String string2) {
            return !string.startsWith(string2) ? string : string.substring(string2.length());
        }
    }

    private class Listener
    implements HyperlinkListener,
    ItemListener {
        private Listener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLDocument hTMLDocument = (HTMLDocument)((JEditorPane)hyperlinkEvent.getSource()).getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
                } else {
                    FilesPane.this.loadPage(hyperlinkEvent.getURL());
                }
            } else if (eventType == HyperlinkEvent.EventType.ENTERED) {
                URL uRL = hyperlinkEvent.getURL();
                if (uRL != null) {
                    FilesPane.this.textArea.setCursor(Cursor.getPredefinedCursor(12));
                    FilesPane.this.noteField.setText(uRL.toString());
                }
            } else if (eventType == HyperlinkEvent.EventType.EXITED) {
                FilesPane.this.textArea.setCursor(Cursor.getPredefinedCursor(0));
                FilesPane.this.noteField.setText("");
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                URL uRL = (URL)itemEvent.getItem();
                FilesPane.this.loadPage(uRL);
            }
        }
    }

    private class History {
        private Vector entries = new Vector();
        private int index;

        private History() {
        }

        boolean hasPrev() {
            return this.index > 0;
        }

        URL prev() {
            if (this.index == 0) {
                return null;
            }
            return (URL)this.entries.elementAt(--this.index);
        }

        boolean hasNext() {
            return this.index < this.entries.size() - 1;
        }

        URL next() {
            if (this.index == this.entries.size() - 1) {
                return null;
            }
            return (URL)this.entries.elementAt(++this.index);
        }

        void add(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.entries.size() && this.entries.elementAt(this.index).equals(uRL)) {
                return;
            }
            if (this.index < this.entries.size() - 1) {
                this.entries.setSize(this.index + 1);
            }
            this.entries.addElement(uRL);
            this.index = this.entries.size() - 1;
        }

        void clear() {
            this.entries.setSize(0);
            this.index = -1;
        }
    }

    static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }
    }
}

