/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.FileParameters;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ConfigHandler;
import com.sun.javatest.exec.ET_FilterHandler;
import com.sun.javatest.exec.ExecManager;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.MessageStrip;
import com.sun.javatest.exec.PropertiesBrowser;
import com.sun.javatest.exec.ReportHandler;
import com.sun.javatest.exec.RunTestsHandler;
import com.sun.javatest.exec.TestSuiteErrorsDialog;
import com.sun.javatest.exec.TestTreePanel;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WorkDirChooser;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ExecTool
extends Tool
implements ExecModel {
    static final String TOOLBAR_PREF = "exec.toolbar";
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters interviewParams;
    private Interview.Observer interviewObserver;
    private FilterConfig fConfig;
    private ConfigHandler configHandler;
    private RunTestsHandler runTestsHandler;
    private ReportHandler reportHandler;
    private ET_FilterHandler filterHandler;
    private JMenuBar menuBar;
    private JToolBar toolBar;
    private JPopupMenu filterMenu;
    private JCheckBoxMenuItem pauseCheckBox;
    private TestTreePanel testTreePanel;
    private TestSuiteErrorsDialog testSuiteErrorsDialog;
    private TestSuiteChooser testSuiteChooser;
    private WorkDirChooser workDirChooser;
    private Preferences.Observer prefsObserver;
    private static final File userDir = new File(System.getProperty("user.dir"));
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$exec$ExecTool == null ? (class$com$sun$javatest$exec$ExecTool = ExecTool.class$("com.sun.javatest.exec.ExecTool")) : class$com$sun$javatest$exec$ExecTool);
    private TestFinderErrorHandler testFinderErrorHandler = new TestFinderErrorHandler();
    private Action propertiesAction = new ToolAction(this.uif, "exec.view.props"){
        private PropertiesBrowser propertiesBrowser;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.propertiesBrowser == null) {
                this.propertiesBrowser = new PropertiesBrowser(ExecTool.this, ExecTool.this.uif);
            }
            this.propertiesBrowser.showDialog(ExecTool.this.testSuite, ExecTool.this.workDir, ExecTool.this.interviewParams);
        }
    };
    private Action testSuiteErrorsAction = new ToolAction(this.uif, "exec.view.testSuiteErrors"){

        public void actionPerformed(ActionEvent actionEvent) {
            if (ExecTool.this.testSuiteErrorsDialog == null) {
                ExecTool.this.testSuiteErrorsDialog = new TestSuiteErrorsDialog(ExecTool.this, ExecTool.this.uif);
            }
            ExecTool.this.testSuiteErrorsDialog.show(ExecTool.this.testSuite);
        }
    };
    private Action helpAction = new ToolAction(this.uif, "exec.help", true){

        public void actionPerformed(ActionEvent actionEvent) {
            HelpBroker helpBroker = ExecTool.this.getHelpBroker();
            helpBroker.setCurrentID("browse.window.csh");
            helpBroker.setDisplayed(true);
        }
    };
    static /* synthetic */ Class class$javax$swing$JOptionPane;
    static /* synthetic */ Class class$com$sun$javatest$exec$ExecTool;

    public ExecTool() {
        super("exec", "browse.window.csh");
        this.configHandler = new ConfigHandler(this, this, this.uif);
        this.runTestsHandler = new RunTestsHandler(this, this, this.configHandler, this.uif);
        this.reportHandler = new ReportHandler(this, this, this.uif);
        this.filterHandler = new ET_FilterHandler(this, this, this.uif);
        this.initGUI();
    }

    public ExecTool(TestSuite testSuite) throws Interview.Fault, TestSuite.Fault {
        this(testSuite.createInterview());
    }

    public ExecTool(WorkDirectory workDirectory) throws Interview.Fault, TestSuite.Fault {
        this(ExecTool.getInterview(workDirectory));
    }

    private static InterviewParameters getInterview(WorkDirectory workDirectory) throws Interview.Fault, TestSuite.Fault {
        InterviewParameters interviewParameters;
        block2: {
            TestSuite testSuite = workDirectory.getTestSuite();
            interviewParameters = testSuite.createInterview();
            interviewParameters.setWorkDirectory(workDirectory);
            FileHistory fileHistory = FileHistory.getFileHistory(workDirectory, "configHistory.jtl");
            File file = fileHistory.getLatestEntry();
            if (file == null) break block2;
            try {
                interviewParameters.load(file);
            }
            catch (IOException iOException) {}
        }
        return interviewParameters;
    }

    public ExecTool(InterviewParameters interviewParameters) {
        super("exec", "browse.window.csh");
        this.interviewParams = interviewParameters;
        this.testSuite = interviewParameters.getTestSuite();
        this.workDir = interviewParameters.getWorkDirectory();
        this.configHandler = new ConfigHandler(this, this, this.uif);
        this.runTestsHandler = new RunTestsHandler(this, this, this.configHandler, this.uif);
        this.reportHandler = new ReportHandler(this, this, this.uif);
        this.filterHandler = new ET_FilterHandler(this, this, this.uif);
        this.initGUI();
    }

    public ExecTool(FileParameters fileParameters) throws TestSuite.Fault {
        this(ExecTool.getInterview(fileParameters));
    }

    private static InterviewParameters getInterview(FileParameters fileParameters) throws TestSuite.Fault {
        TestSuite testSuite = fileParameters.getTestSuite();
        if (testSuite == null) {
            throw new TestSuite.Fault(i18n, "exec.open.noTestSuite");
        }
        WorkDirectory workDirectory = fileParameters.getWorkDirectory();
        InterviewParameters interviewParameters = testSuite.createInterview();
        if (workDirectory != null) {
            interviewParameters.setWorkDirectory(workDirectory);
        }
        interviewParameters.load(fileParameters);
        return interviewParameters;
    }

    public void dispose() {
        TestFinder testFinder;
        super.dispose();
        this.configHandler.dispose();
        this.runTestsHandler.dispose();
        this.testTreePanel.dispose();
        Preferences preferences = Preferences.access();
        preferences.removeObserver(TOOLBAR_PREF, this.prefsObserver);
        if (this.testSuite != null && (testFinder = this.testSuite.getTestFinder()).getErrorHandler() == this.testFinderErrorHandler) {
            testFinder.setErrorHandler(null);
        }
    }

    protected String[] getCloseAlerts() {
        Vector<String> vector = null;
        String string = null;
        if (this.workDir == null) {
            return null;
        }
        if (this.configHandler.isConfigEdited()) {
            if (vector == null) {
                vector = new Vector<String>();
            }
            if (string == null) {
                string = this.getConfigName();
            }
            vector.add(this.uif.getI18NString("exec.alert.unsavedData", new Object[]{string, this.workDir.getPath()}));
        }
        if (this.runTestsHandler.getHarness().isRunning()) {
            if (vector == null) {
                vector = new Vector();
            }
            if (string == null) {
                string = this.getConfigName();
            }
            vector.add(this.uif.getI18NString("exec.alert.taskRunning", new Object[]{string, this.workDir.getPath()}));
        }
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private String getConfigName() {
        TestEnvironment testEnvironment;
        if (this.interviewParams != null && (testEnvironment = this.interviewParams.getEnv()) != null) {
            return testEnvironment.getName();
        }
        return this.uif.getI18NString("exec.unknownConfig");
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = this.uif.getDotsPerInch();
        dimension.width = Math.max(dimension.width, 6 * n);
        dimension.height = Math.max(dimension.height, 3 * n);
        return dimension;
    }

    public boolean isEmpty() {
        return this.testSuite == null;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public TestSuite[] getLoadedTestSuites() {
        TestSuite[] testSuiteArray;
        if (this.testSuite == null) {
            testSuiteArray = null;
        } else {
            TestSuite[] testSuiteArray2 = new TestSuite[1];
            testSuiteArray = testSuiteArray2;
            testSuiteArray2[0] = this.testSuite;
        }
        return testSuiteArray;
    }

    public boolean containsTestSuite(TestSuite testSuite) {
        return this.testSuite != null && this.testSuite.getRoot().equals(testSuite.getRoot());
    }

    public boolean containsTestSuite(File file) {
        return this.testSuite != null && this.testSuite.getRoot().equals(file);
    }

    void setTestSuite(TestSuite testSuite) throws Interview.Fault, TestSuite.Fault {
        this.init(testSuite, null);
    }

    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    public WorkDirectory[] getLoadedWorkDirectories() {
        WorkDirectory[] workDirectoryArray;
        if (this.workDir == null) {
            workDirectoryArray = null;
        } else {
            WorkDirectory[] workDirectoryArray2 = new WorkDirectory[1];
            workDirectoryArray = workDirectoryArray2;
            workDirectoryArray2[0] = this.workDir;
        }
        return workDirectoryArray;
    }

    public boolean containsWorkDirectory(File file) {
        return this.workDir != null && this.workDir.getRoot().equals(file);
    }

    void setWorkDirectory(WorkDirectory workDirectory) throws Interview.Fault, TestSuite.Fault {
        this.init(null, workDirectory);
    }

    public InterviewParameters getInterviewParameters() {
        return this.interviewParams;
    }

    public FilterConfig getFilterConfig() {
        return this.filterHandler.getFilterConfig();
    }

    public void showInitialDialog() {
        if (this.workDir != null) {
            throw new IllegalStateException();
        }
        final InitialDialog initialDialog = new InitialDialog(this, this.uif);
        if (this.isShowing()) {
            initialDialog.setVisible(true);
        } else {
            this.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    if (ExecTool.this.isShowing()) {
                        initialDialog.setVisible(true);
                        ExecTool.this.removeHierarchyListener(this);
                    }
                }
            });
        }
    }

    public void runTests(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        try {
            this.runTestsHandler.executeImmediate(stringArray);
        }
        catch (Interview.Fault fault) {
            fault.printStackTrace();
        }
        catch (TestSuite.Fault fault) {
            fault.printStackTrace();
        }
    }

    public void save(Map map) {
        if (this.testSuite != null && this.testSuite.getRoot() != null) {
            map.put("testSuite", this.testSuite.getRoot().getPath());
        }
        if (this.workDir != null) {
            map.put("workDir", this.workDir.getPath());
        }
        if (this.interviewParams != null && this.interviewParams.getFile() != null) {
            map.put("config", this.interviewParams.getFile().getPath());
        }
        this.reportHandler.save(map);
        this.testTreePanel.save(map);
        this.filterHandler.save();
    }

    public static ExecTool restore(Map map) {
        return new ExecTool(map);
    }

    private ExecTool(Map map) {
        this();
        String string = (String)map.get("testSuite");
        String string2 = (String)map.get("workDir");
        String string3 = (String)map.get("config");
        if (ExecTool.isEmpty(string) && ExecTool.isEmpty(string2) && ExecTool.isEmpty(string3)) {
            return;
        }
        try {
            this.interviewParams = InterviewParameters.open(string, string2, string3);
            if (this.interviewParams != null) {
                this.testSuite = this.interviewParams.getTestSuite();
                this.workDir = this.interviewParams.getWorkDirectory();
                this.reportHandler.restore(map);
            }
            this.updateGUI();
        }
        catch (Interview.Fault fault) {
            this.uif.showError("exec.cantRestore", fault.getMessage());
        }
    }

    private void init(TestSuite testSuite, WorkDirectory workDirectory) throws TestSuite.Fault, Interview.Fault {
        if (testSuite == null && workDirectory == null) {
            throw new IllegalArgumentException();
        }
        if (testSuite == null) {
            testSuite = workDirectory.getTestSuite();
        }
        if (this.testSuite != null && this.testSuite != testSuite) {
            throw new IllegalStateException();
        }
        if (this.workDir != null && this.workDir != workDirectory) {
            throw new IllegalStateException();
        }
        if (this.interviewParams != null && this.interviewParams.getTestSuite() != testSuite) {
            throw new IllegalStateException();
        }
        if (this.workDir != null || workDirectory != null) {
            // empty if block
        }
        this.testSuite = testSuite;
        this.workDir = workDirectory;
        if (this.interviewParams == null) {
            this.interviewParams = this.testSuite.createInterview();
        }
        if (this.workDir != null) {
            TestResultTable testResultTable = this.testTreePanel.getTestResultTable();
            if (testResultTable != null) {
                try {
                    this.workDir.setTestResultTable(testResultTable);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            this.interviewParams.setWorkDirectory(this.workDir);
            FileHistory fileHistory = FileHistory.getFileHistory(this.workDir, "configHistory.jtl");
            File file = fileHistory.getLatestEntry();
            if (file != null) {
                try {
                    this.interviewParams.load(file);
                }
                catch (IOException iOException) {
                    this.uif.showError("exec.cantLoadDefaultConfig", new Object[]{file, iOException});
                }
            }
        }
        this.updateGUI();
    }

    private void initGUI() {
        this.setShortTitle(this.uif.getI18NString("exec.shortTitle"));
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.configHandler.getMenu());
        this.menuBar.add(this.runTestsHandler.getMenu());
        this.menuBar.add(this.reportHandler.getMenu());
        Action[] actionArray = new Action[]{this.propertiesAction, this.testSuiteErrorsAction};
        JMenu jMenu = this.uif.createMenu("exec.view", actionArray);
        jMenu.insertSeparator(0);
        jMenu.insert(this.createFilterMenu(), 0);
        this.menuBar.add(jMenu);
        this.menuBar.add(this.uif.createHorizontalGlue("exec.pad"));
        JMenu jMenu2 = this.uif.createMenu("exec.help");
        jMenu2.add(this.uif.createHelpMenuItem("exec.help.window", "browse.window.csh"));
        this.menuBar.add(jMenu2);
        this.setLayout(new BorderLayout());
        Vector<Action> vector = new Vector<Action>();
        vector.addAll(Arrays.asList(this.configHandler.getToolBarActions()));
        vector.add(null);
        vector.addAll(Arrays.asList(this.runTestsHandler.getToolBarActions()));
        vector.add(null);
        vector.add(this.helpAction);
        Object[] objectArray = new Action[vector.size()];
        vector.copyInto(objectArray);
        Preferences preferences = Preferences.access();
        this.toolBar = this.uif.createToolBar(TOOLBAR_PREF, (Action[])objectArray);
        this.toolBar.setFloatable(false);
        this.toolBar.setVisible(preferences.getPreference(TOOLBAR_PREF, "true").equals("true"));
        this.add((Component)this.toolBar, "North");
        this.prefsObserver = new Preferences.Observer(){

            public void updated(String string, String string2) {
                if (string.equals(ExecTool.TOOLBAR_PREF)) {
                    ExecTool.this.toolBar.setVisible("true".equals(string2));
                }
            }
        };
        preferences.addObserver(TOOLBAR_PREF, this.prefsObserver);
        Harness harness = this.runTestsHandler.getHarness();
        this.testTreePanel = new TestTreePanel(this.uif, harness, this, this.filterHandler.getFilterSelectionHandler(), this);
        this.runTestsHandler.setTreePanelModel(this.testTreePanel.getTreePanelModel());
        this.add((Component)this.testTreePanel, "Center");
        MessageStrip messageStrip = this.runTestsHandler.getMessageStrip();
        this.add((Component)messageStrip, "South");
        this.updateGUI();
    }

    private JMenuItem createFilterMenu() {
        return this.filterHandler.getMenu();
    }

    private void updateGUI() {
        String string;
        this.configHandler.updateGUI();
        this.runTestsHandler.updateGUI();
        this.reportHandler.updateGUI();
        if (this.interviewParams != null && this.interviewObserver == null) {
            this.interviewObserver = new Interview.Observer(){

                public void currentQuestionChanged(Question question) {
                }

                public void pathUpdated() {
                    ExecTool.this.filterHandler.updateParameters();
                }
            };
            this.interviewParams.addObserver(this.interviewObserver);
        }
        String string2 = this.testSuite == null ? null : this.testSuite.getName();
        String string3 = string = this.workDir == null ? null : this.workDir.getRoot().getPath();
        if (this.testSuite == null) {
            this.setI18NTitle("exec.title.noTS.txt");
        } else if (string == null) {
            if (string2 == null) {
                this.setI18NTitle("exec.title.noWD.txt");
            } else {
                this.setI18NTitle("exec.title.tsName.txt", string2);
            }
        } else if (string2 == null) {
            this.setI18NTitle("exec.title.wd.txt", string);
        } else {
            this.setI18NTitle("exec.title.tsName_wd.txt", new Object[]{string2, string});
        }
        if (this.testSuite != null) {
            TestFinder testFinder = this.testSuite.getTestFinder();
            testFinder.setErrorHandler(this.testFinderErrorHandler);
            this.testSuiteErrorsAction.setEnabled(testFinder.getErrorCount() > 0);
        }
        this.testTreePanel.setParameters(this.interviewParams);
        this.filterHandler.updateParameters();
        this.testTreePanel.updateGUI();
    }

    private void setTestSuite(TestSuite testSuite, boolean bl) throws Interview.Fault, TestSuite.Fault {
        this.init(testSuite, null);
        if (bl) {
            ExecManager.access().addToFileHistory(testSuite);
        }
    }

    private void setWorkDir(WorkDirectory workDirectory, boolean bl) throws Interview.Fault, TestSuite.Fault {
        this.init(null, workDirectory);
        if (bl) {
            ExecManager.access().addToFileHistory(workDirectory);
        }
    }

    public void showWorkDirDialog() {
        int n;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                JOptionPane jOptionPane = (JOptionPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JOptionPane == null ? (class$javax$swing$JOptionPane = ExecTool.class$("javax.swing.JOptionPane")) : class$javax$swing$JOptionPane, component);
                jOptionPane.setValue(component);
                jOptionPane.setVisible(false);
            }
        };
        JTextArea jTextArea = this.uif.createMessageArea("exec.wd.need");
        String string = this.uif.getI18NString("exec.wd.need.title");
        Object[] objectArray = new JButton[]{this.uif.createButton("exec.wd.open", actionListener), this.uif.createButton("exec.wd.new", actionListener), this.uif.createCancelButton("exec.wd.cancel", actionListener)};
        int n2 = JOptionPane.showOptionDialog(this, jTextArea, string, 1, 3, null, objectArray, null);
        switch (n2) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            default: {
                return;
            }
        }
        WorkDirChooser workDirChooser = this.getWorkDirChooser();
        workDirChooser.setMode(n);
        workDirChooser.setTestSuite(this.testSuite);
        n2 = workDirChooser.showDialog(this);
        if (n2 != 0) {
            return;
        }
        try {
            this.setWorkDir(workDirChooser.getSelectedWorkDirectory(), true);
        }
        catch (Interview.Fault fault) {
            this.uif.showError("exec.wd.errorOpeningWD", fault);
        }
        catch (TestSuite.Fault fault) {
            this.uif.showError("exec.wd.errorOpeningWD", fault);
        }
    }

    public void showMessage(ResourceBundle resourceBundle, String string) {
        this.runTestsHandler.getMessageStrip().showMessage(resourceBundle, string);
    }

    public TestResultTable getActiveTestResultTable() {
        if (this.workDir != null) {
            return this.workDir.getTestResultTable();
        }
        if (this.testTreePanel != null) {
            return this.testTreePanel.getTestResultTable();
        }
        return null;
    }

    TestSuiteChooser getTestSuiteChooser() {
        if (this.testSuiteChooser == null) {
            this.testSuiteChooser = new TestSuiteChooser();
        }
        return this.testSuiteChooser;
    }

    WorkDirChooser getWorkDirChooser() {
        if (this.workDirChooser == null) {
            this.workDirChooser = new WorkDirChooser();
            this.workDirChooser.setTestSuiteChooser(this.getTestSuiteChooser());
        }
        return this.workDirChooser;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class InitialDialog
    extends ToolDialog
    implements ActionListener {
        private JButton openTestSuiteBtn;
        private JButton createWorkDirBtn;
        private JButton openWorkDirBtn;

        InitialDialog(Component component, UIFactory uIFactory) {
            super(component, uIFactory, "exec.init");
        }

        protected void initGUI() {
            JPanel jPanel = this.uif.createPanel("exec.init.body", new BorderLayout(), false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
            if (ExecTool.this.testSuite == null) {
                this.setI18NTitle("exec.init.title");
                JLabel jLabel = new JLabel(Desktop.access().getLogo());
                jLabel.setName("exec.init.jtlogo");
                this.uif.setAccessibleInfo(jLabel, "exec.init.jtlogo");
                jLabel.setFocusable(false);
                jPanel.add((Component)jLabel, "West");
                JTextArea jTextArea = this.uif.createMessageArea("exec.init.testsuite");
                jTextArea.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
                jPanel.add((Component)jTextArea, "Center");
                this.openTestSuiteBtn = this.uif.createButton("exec.init.openTestSuite", this);
                this.openWorkDirBtn = this.uif.createButton("exec.init.openWorkDir", this);
                JButton jButton = this.uif.createCancelButton("exec.init.cancel");
                JButton jButton2 = this.uif.createHelpButton("exec.init.help", "run.initTestSuite.csh");
                JButton[] jButtonArray = new JButton[]{this.openTestSuiteBtn, this.openWorkDirBtn, jButton, jButton2};
                this.setButtons(jButtonArray, null);
                this.setHelp("run.initTestSuite.csh");
            } else {
                JLabel jLabel;
                this.setI18NTitle("exec.init.title");
                URL uRL = ExecTool.this.testSuite.getLogo();
                if (uRL == null) {
                    jLabel = new JLabel(Desktop.access().getLogo());
                    jLabel.setName("exec.init.jtlogo");
                    this.uif.setAccessibleInfo(jLabel, "exec.init.jtlogo");
                } else {
                    jLabel = new JLabel(new ImageIcon(uRL));
                    jLabel.setName("exec.init.tslogo");
                    this.uif.setAccessibleInfo(jLabel, "exec.init.tslogo");
                }
                jLabel.setFocusable(false);
                jPanel.add((Component)jLabel, "West");
                JTextArea jTextArea = this.uif.createMessageArea("exec.init.workdir");
                jTextArea.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
                jPanel.add((Component)jTextArea, "Center");
                this.createWorkDirBtn = this.uif.createButton("exec.init.createWorkDir", this);
                this.openWorkDirBtn = this.uif.createButton("exec.init.openWorkDir", this);
                JButton jButton = this.uif.createCancelButton("exec.init.cancel");
                JButton jButton3 = this.uif.createHelpButton("exec.init.help", "run.initWorkDir.csh");
                JButton[] jButtonArray = new JButton[]{this.createWorkDirBtn, this.openWorkDirBtn, jButton, jButton3};
                this.setButtons(jButtonArray, null);
                this.setHelp("run.initWorkDir.csh");
            }
            this.setBody(jPanel);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block12: {
                try {
                    Object object = actionEvent.getSource();
                    if (object == this.openTestSuiteBtn) {
                        TestSuiteChooser testSuiteChooser = ExecTool.this.getTestSuiteChooser();
                        int n = testSuiteChooser.showDialog(this.parent);
                        if (n != 0) {
                            return;
                        }
                        ExecTool.this.setTestSuite(testSuiteChooser.getSelectedTestSuite(), true);
                        this.setVisible(false);
                        Desktop.access().setSelectedTool(ExecTool.this);
                        break block12;
                    }
                    if (object == this.createWorkDirBtn) {
                        if (ExecTool.this.testSuite == null) {
                            throw new IllegalStateException();
                        }
                        WorkDirChooser workDirChooser = ExecTool.this.getWorkDirChooser();
                        workDirChooser.setMode(0);
                        workDirChooser.setTestSuite(ExecTool.this.testSuite);
                        int n = workDirChooser.showDialog(this.parent);
                        if (n != 0) {
                            return;
                        }
                        ExecTool.this.setWorkDir(workDirChooser.getSelectedWorkDirectory(), true);
                        this.setVisible(false);
                        Desktop.access().setSelectedTool(ExecTool.this);
                        break block12;
                    }
                    if (object == this.openWorkDirBtn) {
                        WorkDirChooser workDirChooser = ExecTool.this.getWorkDirChooser();
                        if (ExecTool.this.testSuite == null) {
                            workDirChooser.setMode(1);
                        } else {
                            workDirChooser.setMode(2);
                        }
                        workDirChooser.setTestSuite(ExecTool.this.testSuite);
                        int n = workDirChooser.showDialog(this.parent);
                        if (n != 0) {
                            return;
                        }
                        ExecTool.this.setWorkDir(workDirChooser.getSelectedWorkDirectory(), true);
                        this.setVisible(false);
                        Desktop.access().setSelectedTool(ExecTool.this);
                        break block12;
                    }
                    throw new Error();
                }
                catch (Interview.Fault fault) {
                    this.uif.showError("exec.cantOpen.interviewFault", fault);
                }
                catch (TestSuite.Fault fault) {
                    this.uif.showError("exec.cantOpen.testSuiteFault", fault);
                }
            }
        }
    }

    private class TestFinderErrorHandler
    implements TestFinder.ErrorHandler {
        private boolean shownErrorDialog = false;

        private TestFinderErrorHandler() {
        }

        public void error(String string) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(this, string){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ TestFinderErrorHandler this$1;
                    {
                        this.this$1 = testFinderErrorHandler;
                        this.val$message = string;
                    }

                    public void run() {
                        this.this$1.error(this.val$message);
                    }
                });
                return;
            }
            if (ExecTool.this.testSuiteErrorsDialog != null && ExecTool.this.testSuiteErrorsDialog.isShowing()) {
                ExecTool.this.testSuiteErrorsDialog.show(ExecTool.this.testSuite);
            }
            ExecTool.this.testSuiteErrorsAction.setEnabled(true);
            if (!this.shownErrorDialog) {
                this.shownErrorDialog = true;
                ExecTool.this.uif.showError("exec.testFinderErr", string);
            }
        }
    }
}

