/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.FileParameters;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.PrefsPane;
import com.sun.javatest.tool.CommandLineHelp;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.Main;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WorkDirChooser;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ExecManager
extends ToolManager {
    private static final ExecManager theOne = new ExecManager();
    private Action openTestSuiteAction;
    private Action openWorkDirAction;
    private Action newWorkDirAction;
    private FileOpener testSuiteOpener;
    private FileOpener workDirOpener;
    private Object initialArg;
    private TestSuiteChooser testSuiteChooser;
    private WorkDirChooser workDirChooser;
    private PrefsPane prefsPane;
    private static final String EXEC = "exec";
    private static final File userDir = new File(System.getProperty("user.dir"));
    private FileOpener[] fileOpeners;
    private Action[] fileMenuActions;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public static ExecManager access() {
        return theOne;
    }

    private ExecManager() {
        this.openTestSuiteAction = new ToolAction(this.i18n, "mgr.openTestSuite"){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TestSuiteChooser testSuiteChooser = ExecManager.this.getTestSuiteChooser();
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ExecManager.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, jComponent);
                    int n = testSuiteChooser.showDialog(jFrame);
                    if (n != 0) {
                        return;
                    }
                    ExecManager.this.showTestSuite(testSuiteChooser.getSelectedTestSuite());
                    testSuiteChooser.setSelectedTestSuite(null);
                }
                catch (Interview.Fault fault) {
                    throw new JavaTestError("ExecManager.openTestSuiteAction " + fault);
                }
                catch (TestSuite.Fault fault) {
                    throw new JavaTestError("ExecManager.openTestSuiteAction " + fault);
                }
            }
        };
        this.openWorkDirAction = new ToolAction(this.i18n, "mgr.openWorkDir"){

            public void actionPerformed(ActionEvent actionEvent) {
                WeakReference weakReference = (WeakReference)this.getValue("testSuite");
                TestSuite testSuite = weakReference == null ? null : (TestSuite)weakReference.get();
                File file = (File)this.getValue("testSuitePath");
                File file2 = (File)this.getValue("workDirPath");
                try {
                    TestSuite testSuite2 = null;
                    try {
                        if (testSuite != null) {
                            testSuite2 = testSuite;
                        } else if (file != null) {
                            testSuite2 = TestSuite.open(file);
                        } else if (file2 != null) {
                            testSuite2 = WorkDirectory.open(file2).getTestSuite();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    WorkDirChooser workDirChooser = ExecManager.this.getWorkDirChooser();
                    workDirChooser.setMode(1);
                    workDirChooser.setTestSuite(testSuite2);
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ExecManager.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, jComponent);
                    int n = workDirChooser.showDialog(jFrame);
                    if (n != 0) {
                        return;
                    }
                    WorkDirectory workDirectory = workDirChooser.getSelectedWorkDirectory();
                    ExecManager.this.showWorkDirectory(workDirectory);
                    workDirChooser.setSelectedWorkDirectory(null);
                    workDirChooser.setTestSuite(null);
                }
                catch (Interview.Fault fault) {
                    throw new JavaTestError("ExecManager.openWorkDirAction " + fault);
                }
                catch (TestSuite.Fault fault) {
                    throw new JavaTestError("ExecManager.openWorkDirAction " + fault);
                }
            }
        };
        this.newWorkDirAction = new ToolAction(this.i18n, "mgr.newWorkDir"){

            public void actionPerformed(ActionEvent actionEvent) {
                WeakReference weakReference = (WeakReference)this.getValue("testSuite");
                TestSuite testSuite = (TestSuite)weakReference.get();
                File file = (File)this.getValue("testSuitePath");
                File file2 = (File)this.getValue("workDirPath");
                try {
                    TestSuite testSuite2;
                    if (testSuite != null) {
                        testSuite2 = testSuite;
                    } else if (file != null) {
                        testSuite2 = TestSuite.open(file);
                    } else if (file2 != null) {
                        testSuite2 = WorkDirectory.open(file2).getTestSuite();
                    } else {
                        throw new JavaTestError("ExecManager.newWorkDirAction");
                    }
                    WorkDirChooser workDirChooser = ExecManager.this.getWorkDirChooser();
                    workDirChooser.setMode(0);
                    workDirChooser.setTestSuite(testSuite2);
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ExecManager.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, jComponent);
                    int n = workDirChooser.showDialog(jFrame);
                    if (n != 0) {
                        return;
                    }
                    WorkDirectory workDirectory = workDirChooser.getSelectedWorkDirectory();
                    ExecManager.this.showWorkDirectory(workDirectory);
                    workDirChooser.setSelectedWorkDirectory(null);
                    workDirChooser.setTestSuite(null);
                }
                catch (Interview.Fault fault) {
                    throw new JavaTestError("ExecManager.newWorkDirAction " + fault);
                }
                catch (TestSuite.Fault fault) {
                    throw new JavaTestError("ExecManager.newWorkDirAction " + fault);
                }
                catch (WorkDirectory.Fault fault) {
                    throw new JavaTestError("ExecManager.newWorkDirAction " + fault);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new JavaTestError("ExecManager.newWorkDirAction " + fileNotFoundException);
                }
            }
        };
        this.testSuiteOpener = new FileOpener(){

            public String getFileType() {
                return "testSuite";
            }

            public void open(File file) throws FileNotFoundException, FileOpener.Fault {
                try {
                    ExecManager.this.showTestSuite(TestSuite.open(file));
                }
                catch (Interview.Fault fault) {
                    throw new FileOpener.Fault(ExecManager.this.i18n, "mgr.errorOpeningTestSuite", new Object[]{file, fault});
                }
                catch (TestSuite.Fault fault) {
                    throw new FileOpener.Fault(ExecManager.this.i18n, "mgr.errorOpeningTestSuite", new Object[]{file, fault});
                }
            }
        };
        this.workDirOpener = new FileOpener(){

            public String getFileType() {
                return "workDirectory";
            }

            public void open(File file) throws FileNotFoundException, FileOpener.Fault {
                try {
                    ExecManager.this.showWorkDirectory(WorkDirectory.open(file));
                }
                catch (Interview.Fault fault) {
                    throw new FileOpener.Fault(ExecManager.this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault.getMessage()});
                }
                catch (TestSuite.Fault fault) {
                    throw new FileOpener.Fault(ExecManager.this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault.getMessage()});
                }
                catch (WorkDirectory.Fault fault) {
                    throw new FileOpener.Fault(ExecManager.this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault.getMessage()});
                }
            }
        };
        this.fileOpeners = new FileOpener[]{this.testSuiteOpener, this.workDirOpener};
        this.fileMenuActions = new Action[]{this.newWorkDirAction, this.openWorkDirAction, this.openTestSuiteAction};
    }

    public CommandLineHelp getCommandLineHelp() {
        String[] stringArray = new String[]{"params"};
        String[] stringArray2 = new String[]{"workDir", "testSuite", "jtp", "jti"};
        return this.createCommandLineHelp("mgr.cmdLine", stringArray, stringArray2);
    }

    public FileOpener[] getFileOpeners() {
        return this.fileOpeners;
    }

    public Action[] getFileMenuActions() {
        Serializable serializable;
        Object object;
        boolean bl = false;
        Object var2_2 = null;
        Desktop desktop = Desktop.access();
        Tool tool = desktop.getSelectedTool();
        if (tool != null && tool instanceof ExecTool && (object = ((ExecTool)tool).getTestSuite()) != null) {
            this.newWorkDirAction.setEnabled(true);
            this.newWorkDirAction.putValue("testSuite", new WeakReference<Object>(object));
            this.openWorkDirAction.putValue("testSuite", new WeakReference<Object>(object));
            bl = true;
        }
        if (!bl) {
            Object object2;
            object = desktop.getTools();
            serializable = new HashSet();
            int n = 0;
            while (n < ((Tool[])object).length) {
                object2 = ((Tool)object[n]).getLoadedTestSuites();
                if (object2 != null) {
                    serializable.addAll(Arrays.asList(object2));
                }
                ++n;
            }
            if (serializable.size() == 1) {
                object2 = (TestSuite)serializable.toArray()[0];
                this.newWorkDirAction.setEnabled(true);
                this.newWorkDirAction.putValue("testSuite", new WeakReference<TestSuite[]>((TestSuite[])object2));
                this.openWorkDirAction.putValue("testSuite", new WeakReference<TestSuite[]>((TestSuite[])object2));
            } else {
                this.newWorkDirAction.setEnabled(false);
            }
            boolean bl2 = bl = serializable.size() > 0;
        }
        if (!bl) {
            try {
                if (TestSuite.isTestSuite(userDir)) {
                    this.newWorkDirAction.setEnabled(true);
                    this.newWorkDirAction.putValue("testSuitePath", userDir);
                    this.openWorkDirAction.putValue("testSuitePath", userDir);
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                if (WorkDirectory.isWorkDirectory(userDir)) {
                    this.newWorkDirAction.setEnabled(true);
                    this.newWorkDirAction.putValue("workDirPath", userDir);
                    this.openWorkDirAction.putValue("workDirPath", userDir);
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                File file;
                object = Harness.getClassDir();
                serializable = object == null ? null : ((File)object).getParentFile();
                File file2 = file = serializable == null ? null : ((File)serializable).getParentFile();
                if (serializable != null && TestSuite.isTestSuite((File)serializable)) {
                    this.newWorkDirAction.setEnabled(true);
                    this.newWorkDirAction.putValue("testSuitePath", serializable);
                    this.openWorkDirAction.putValue("testSuitePath", serializable);
                    bl = true;
                } else if (file != null && TestSuite.isTestSuite(file)) {
                    this.newWorkDirAction.setEnabled(true);
                    this.newWorkDirAction.putValue("testSuitePath", file);
                    this.openWorkDirAction.putValue("testSuitePath", file);
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.newWorkDirAction.setEnabled(false);
        }
        return this.fileMenuActions;
    }

    public Action[] getTaskMenuActions() {
        return null;
    }

    public Preferences.Pane getPrefsPane() {
        if (this.prefsPane == null) {
            this.prefsPane = new PrefsPane();
        }
        return this.prefsPane;
    }

    public int decodeArg(String[] stringArray, int n, boolean bl) throws Main.BadArgs, ToolManager.Fault {
        block17: {
            if (bl) {
                File file = new File(stringArray[n]);
                try {
                    if (FileParameters.isParameterFile(file)) {
                        this.checkInitialArgUnset();
                        FileParameters fileParameters = new FileParameters(file);
                        this.initialArg = fileParameters;
                        return 1;
                    }
                    if (InterviewParameters.isInterviewFile(file)) {
                        this.checkInitialArgUnset();
                        this.initialArg = InterviewParameters.open(file);
                        return 1;
                    }
                    if (TestSuite.isTestSuite(file)) {
                        this.checkInitialArgUnset();
                        this.initialArg = TestSuite.open(file);
                        return 1;
                    }
                    if (WorkDirectory.isWorkDirectory(file)) {
                        this.checkInitialArgUnset();
                        this.initialArg = WorkDirectory.open(file);
                        return 1;
                    }
                    break block17;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new ToolManager.Fault(this.i18n, "mgr.cannotFindFile", file);
                }
                catch (IOException iOException) {
                    throw new ToolManager.Fault(this.i18n, "mgr.cannotReadFile", new Object[]{file, iOException});
                }
                catch (Interview.Fault fault) {
                    throw new ToolManager.Fault(this.i18n, "mgr.errorOpeningConfigurationFile", new Object[]{file, fault});
                }
                catch (TestSuite.Fault fault) {
                    throw new ToolManager.Fault(this.i18n, "mgr.errorOpeningTestSuite", new Object[]{file, fault});
                }
                catch (WorkDirectory.Fault fault) {
                    throw new ToolManager.Fault(this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault});
                }
            }
            if ("-open".equalsIgnoreCase(stringArray[n]) && n + 1 < stringArray.length) {
                if (this.open(new File(stringArray[n + 1]))) {
                    return 2;
                }
            } else if ("-params".equalsIgnoreCase(stringArray[n])) {
                this.checkInitialArgUnset();
                try {
                    String[] stringArray2 = new String[stringArray.length - n - 1];
                    System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray2.length);
                    FileParameters fileParameters = new FileParameters(stringArray2);
                    this.initialArg = fileParameters;
                    return stringArray2.length + 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Main.BadArgs(this.i18n, "mgr.badParamArg", illegalArgumentException.getMessage());
                }
            }
        }
        return 0;
    }

    private boolean open(File file) throws Main.BadArgs, ToolManager.Fault {
        try {
            if (TestSuite.isTestSuite(file)) {
                this.openTestSuite(file);
                return true;
            }
            if (WorkDirectory.isWorkDirectory(file) || WorkDirectory.isEmptyDirectory(file)) {
                this.openWorkDirectory(file);
                return true;
            }
            if (InterviewParameters.isInterviewFile(file)) {
                this.openInterviewFile(file);
                return true;
            }
            if (FileParameters.isParameterFile(file)) {
                this.openParameterFile(file);
                return true;
            }
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ToolManager.Fault(this.i18n, "mgr.cannotFindFile", file);
        }
        catch (IOException iOException) {
            throw new ToolManager.Fault(this.i18n, "mgr.cannotReadFile", new Object[]{file, iOException});
        }
    }

    private void openTestSuite(File file) throws Main.BadArgs, ToolManager.Fault, FileNotFoundException {
        try {
            if (this.initialArg != null) {
                if (this.initialArg instanceof InterviewParameters) {
                    throw new Main.BadArgs(this.i18n, "mgr.testSuiteAlreadySet", file);
                }
                throw new Main.BadArgs(this.i18n, "mgr.cannotSetTestSuite", file);
            }
            TestSuite testSuite = TestSuite.open(file);
            this.initialArg = testSuite.createInterview();
        }
        catch (TestSuite.Fault fault) {
            throw new ToolManager.Fault(this.i18n, "mgr.errorOpeningTestSuite", new Object[]{file, fault});
        }
    }

    private void openWorkDirectory(File file) throws Main.BadArgs, ToolManager.Fault, FileNotFoundException {
        block6: {
            try {
                if (this.initialArg == null) {
                    WorkDirectory workDirectory = WorkDirectory.open(file);
                    TestSuite testSuite = workDirectory.getTestSuite();
                    InterviewParameters interviewParameters = testSuite.createInterview();
                    interviewParameters.setWorkDirectory(workDirectory);
                    this.initialArg = interviewParameters;
                    break block6;
                }
                if (this.initialArg instanceof InterviewParameters) {
                    InterviewParameters interviewParameters = (InterviewParameters)this.initialArg;
                    if (interviewParameters.getWorkDirectory() != null) {
                        throw new Main.BadArgs(this.i18n, "mgr.workDirAlreadySet", file);
                    }
                    WorkDirectory workDirectory = WorkDirectory.isEmptyDirectory(file) ? WorkDirectory.create(file, interviewParameters.getTestSuite()) : WorkDirectory.open(file, interviewParameters.getTestSuite());
                    interviewParameters.setWorkDirectory(workDirectory);
                    break block6;
                }
                throw new Main.BadArgs(this.i18n, "mgr.cannotSetWorkDirectory", file);
            }
            catch (TestSuite.Fault fault) {
                throw new ToolManager.Fault(this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault});
            }
            catch (WorkDirectory.Fault fault) {
                throw new ToolManager.Fault(this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{file, fault});
            }
        }
    }

    private void openInterviewFile(File file) throws Main.BadArgs, ToolManager.Fault, FileNotFoundException, IOException {
        block4: {
            try {
                if (this.initialArg == null) {
                    this.initialArg = InterviewParameters.open(file);
                    break block4;
                }
                if (this.initialArg instanceof InterviewParameters) {
                    InterviewParameters interviewParameters = (InterviewParameters)this.initialArg;
                    interviewParameters.load(file);
                    break block4;
                }
                throw new Main.BadArgs(this.i18n, "mgr.cannotOpenInterviewFile", file);
            }
            catch (Interview.Fault fault) {
                throw new ToolManager.Fault(this.i18n, "mgr.errorOpeningConfigurationFile", new Object[]{file, fault});
            }
        }
    }

    private void openParameterFile(File file) throws Main.BadArgs, FileNotFoundException, IOException {
        if (this.initialArg != null) {
            throw new Main.BadArgs(this.i18n, "mgr.cannotOpenParameterFile", file);
        }
        this.initialArg = new FileParameters(file);
    }

    private void checkInitialArgUnset() throws Main.BadArgs {
        if (this.initialArg != null) {
            throw new Main.BadArgs(this.i18n, "mgr.onlyOneFileOrParams");
        }
    }

    public void validateArgs() throws Main.BadArgs {
    }

    public int getAcceptableModes() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setup(int n) throws ToolManager.Fault {
        if (this.initialArg == null) {
            try {
                ExecTool execTool = this.startTool();
                if (!Desktop.isFirstTime() || execTool.getWorkDirectory() != null) return;
                execTool.showInitialDialog();
                return;
            }
            catch (Interview.Fault fault) {
                throw new ToolManager.Fault(this.i18n, "mgr.errorStartingDefaultTool", new Object[]{fault});
            }
            catch (TestSuite.Fault fault) {
                throw new ToolManager.Fault(this.i18n, "mgr.errorStartingDefaultTool", new Object[]{fault});
            }
            catch (WorkDirectory.Fault fault) {
                throw new ToolManager.Fault(this.i18n, "mgr.errorStartingDefaultTool", new Object[]{fault});
            }
        }
        try {
            ExecTool execTool;
            Desktop desktop = Desktop.access();
            if (this.initialArg instanceof TestSuite) {
                execTool = new ExecTool((TestSuite)this.initialArg);
            } else if (this.initialArg instanceof WorkDirectory) {
                execTool = new ExecTool((WorkDirectory)this.initialArg);
            } else if (this.initialArg instanceof InterviewParameters) {
                execTool = new ExecTool((InterviewParameters)this.initialArg);
            } else {
                if (!(this.initialArg instanceof FileParameters)) throw new JavaTestError(this.i18n, "mgr.initialArgError");
                execTool = new ExecTool((FileParameters)this.initialArg);
            }
            desktop.addTool(execTool);
            desktop.setSelectedTool(execTool);
            if (!desktop.isFirstTime() || execTool.getWorkDirectory() != null) return;
            execTool.showInitialDialog();
            return;
        }
        catch (Interview.Fault fault) {
            throw new ToolManager.Fault(this.i18n, "mgr.errorStartingTool", new Object[]{fault});
        }
        catch (TestSuite.Fault fault) {
            throw new ToolManager.Fault(this.i18n, "mgr.errorStartingTool", new Object[]{fault});
        }
    }

    public boolean run() {
        return true;
    }

    public void cleanup() {
        this.initialArg = null;
    }

    public ExecTool startTool() throws Interview.Fault, TestSuite.Fault, WorkDirectory.Fault {
        ExecTool execTool;
        File file = new File(System.getProperty("user.dir"));
        File file2 = Harness.getClassDir();
        File file3 = file2 == null ? null : file2.getParentFile();
        File file4 = file3 == null ? null : file3.getParentFile();
        try {
            if (WorkDirectory.isWorkDirectory(file)) {
                return this.showWorkDirectory(WorkDirectory.open(file));
            }
            if (TestSuite.isTestSuite(file)) {
                return this.showTestSuite(TestSuite.open(file));
            }
            if (file3 != null && TestSuite.isTestSuite(file3)) {
                return this.showTestSuite(TestSuite.open(file3));
            }
            if (file4 != null && TestSuite.isTestSuite(file4)) {
                return this.showTestSuite(TestSuite.open(file4));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Desktop desktop = Desktop.access();
        ExecTool execTool2 = null;
        Tool[] toolArray = desktop.getTools();
        if (toolArray != null) {
            int n = 0;
            while (n < toolArray.length && execTool2 == null) {
                ExecTool execTool3;
                if (toolArray[n] instanceof ExecTool && (execTool3 = (ExecTool)toolArray[n]).isEmpty()) {
                    execTool2 = execTool3;
                }
                ++n;
            }
        }
        if (execTool2 != null) {
            execTool = execTool2;
        } else {
            execTool = new ExecTool();
            desktop.addTool(execTool);
        }
        desktop.setSelectedTool(execTool);
        return execTool;
    }

    public ExecTool startTool(FileParameters fileParameters) throws TestSuite.Fault {
        Desktop desktop = Desktop.access();
        ExecTool execTool = new ExecTool(fileParameters);
        desktop.addTool(execTool);
        desktop.setSelectedTool(execTool);
        return execTool;
    }

    public ExecTool startTool(InterviewParameters interviewParameters) {
        Desktop desktop = Desktop.access();
        ExecTool execTool = new ExecTool(interviewParameters);
        desktop.addTool(execTool);
        desktop.setSelectedTool(execTool);
        return execTool;
    }

    public ExecTool showTestSuite(TestSuite testSuite) throws Interview.Fault, TestSuite.Fault {
        ExecTool execTool;
        Desktop desktop = Desktop.access();
        ExecTool execTool2 = null;
        Tool[] toolArray = desktop.getTools();
        if (toolArray != null) {
            int n = 0;
            while (n < toolArray.length && execTool2 == null) {
                ExecTool execTool3;
                if (toolArray[n] instanceof ExecTool && (execTool3 = (ExecTool)toolArray[n]).isEmpty()) {
                    execTool2 = execTool3;
                }
                ++n;
            }
        }
        if (execTool2 != null) {
            execTool = execTool2;
            execTool.setTestSuite(testSuite);
        } else {
            execTool = new ExecTool(testSuite);
            desktop.addTool(execTool);
        }
        desktop.setSelectedTool(execTool);
        Desktop.addToFileHistory(testSuite.getRoot(), this.testSuiteOpener);
        return execTool;
    }

    private TestSuiteChooser getTestSuiteChooser() {
        if (this.testSuiteChooser == null) {
            this.testSuiteChooser = new TestSuiteChooser();
        }
        return this.testSuiteChooser;
    }

    void addToFileHistory(TestSuite testSuite) {
        Desktop.addToFileHistory(testSuite.getRoot(), this.testSuiteOpener);
    }

    public ExecTool showWorkDirectory(WorkDirectory workDirectory) throws Interview.Fault, TestSuite.Fault {
        ExecTool execTool;
        Object object;
        Desktop desktop = Desktop.access();
        Object object2 = null;
        Tool[] toolArray = desktop.getTools();
        if (toolArray != null) {
            int n = 0;
            while (n < toolArray.length) {
                if (toolArray[n] instanceof ExecTool) {
                    object = (ExecTool)toolArray[n];
                    if (((ExecTool)object).isEmpty() && object2 == null) {
                        object2 = object;
                    } else if (((ExecTool)object).getWorkDirectory() == null && ((ExecTool)object).containsTestSuite(workDirectory.getTestSuite())) {
                        object2 = object;
                        break;
                    }
                }
                ++n;
            }
        }
        if (object2 != null) {
            execTool = object2;
            execTool.setWorkDirectory(workDirectory);
        } else {
            object = workDirectory.getTestSuite();
            InterviewParameters interviewParameters = ((TestSuite)object).createInterview();
            interviewParameters.setWorkDirectory(workDirectory);
            FileHistory fileHistory = FileHistory.getFileHistory(workDirectory, "configHistory.jtl");
            File file = fileHistory.getLatestEntry();
            if (file != null) {
                try {
                    interviewParameters.load(file);
                }
                catch (IOException iOException) {
                    UIFactory uIFactory = new UIFactory(this.getClass(), Desktop.access().getDialogParent());
                    uIFactory.showError("exec.cantLoadDefaultConfig", new Object[]{file, iOException});
                }
                catch (Interview.Fault fault) {
                    UIFactory uIFactory = new UIFactory(this.getClass(), Desktop.access().getDialogParent());
                    uIFactory.showError("exec.cantLoadDefaultConfig", new Object[]{file, fault.getMessage()});
                }
            }
            execTool = new ExecTool(interviewParameters);
            desktop.addTool(execTool);
        }
        desktop.setSelectedTool(execTool);
        Desktop.addToFileHistory(workDirectory.getRoot(), this.workDirOpener);
        return execTool;
    }

    private WorkDirChooser getWorkDirChooser() {
        if (this.workDirChooser == null) {
            this.workDirChooser = new WorkDirChooser();
            this.workDirChooser.setTestSuiteChooser(this.getTestSuiteChooser());
        }
        return this.workDirChooser;
    }

    void addToFileHistory(WorkDirectory workDirectory) {
        Desktop.addToFileHistory(workDirectory.getRoot(), this.workDirOpener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

