/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ExcludeListBrowser
extends ToolDialog {
    private InterviewParameters params;
    private File[] files;
    private ExcludeList table;
    private JList list;
    private JTextField synopsisField;
    private JTextField kwField;
    private JTextField bugIdsField;
    private Listener listener;

    ExcludeListBrowser(Container container, UIFactory uIFactory) {
        super(container, uIFactory, "elb");
        this.params = this.params;
        this.listener = new Listener();
    }

    public void show(InterviewParameters interviewParameters) {
        this.params = interviewParameters;
        this.setVisible(true);
    }

    private void updateContent() {
        ExcludeList excludeList = this.params.getExcludeList();
        Parameters.ExcludeListParameters excludeListParameters = this.params.getExcludeListParameters();
        File[] fileArray = excludeListParameters instanceof Parameters.MutableExcludeListParameters ? ((Parameters.MutableExcludeListParameters)excludeListParameters).getExcludeFiles() : null;
        if (this.table != excludeList || this.files != fileArray) {
            this.setTable(fileArray, excludeList);
        }
    }

    private void setTable(File[] fileArray, ExcludeList excludeList) {
        this.table = excludeList;
        this.files = fileArray;
        TreeSet<ExcludeList.Entry> treeSet = new TreeSet<ExcludeList.Entry>(new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ExcludeListBrowser.this.entryToString((ExcludeList.Entry)object);
                String string2 = ExcludeListBrowser.this.entryToString((ExcludeList.Entry)object2);
                return string.compareTo(string2);
            }
        });
        if (excludeList != null) {
            Iterator iterator = excludeList.getIterator(false);
            while (iterator.hasNext()) {
                ExcludeList.Entry entry = (ExcludeList.Entry)iterator.next();
                treeSet.add(entry);
            }
        }
        if (this.list == null) {
            this.initGUI();
        }
        this.list.setListData(new Vector(treeSet));
        if (fileArray == null || fileArray.length == 0) {
            this.setI18NTitle("elb.title0");
        } else if (fileArray.length == 1) {
            this.setI18NTitle("elb.title1", fileArray[0].getPath());
        } else {
            this.setI18NTitle("elb.titlen", new Integer(fileArray.length));
        }
    }

    protected void initGUI() {
        this.setHelp("exclList.window.csh");
        JPanel jPanel = this.uif.createPanel("elb.body", new GridBagLayout(), false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int n = this.uif.getDotsPerInch();
        jPanel.setPreferredSize(new Dimension(5 * n, 2 * n));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 5;
        this.list = this.uif.createList("elb.list");
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ExcludeListBrowser.this.selectEntry((ExcludeList.Entry)ExcludeListBrowser.this.list.getSelectedValue());
            }
        });
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = ExcludeListBrowser.this.entryToString((ExcludeList.Entry)object);
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        this.list.setVisibleRowCount(3);
        jPanel.add((Component)this.uif.createScrollPane(this.list), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets.top = 2;
        gridBagConstraints2.insets.right = 5;
        gridBagConstraints2.anchor = 13;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets.top = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        JLabel jLabel = this.uif.createLabel("elb.synopsis", true);
        jPanel.add((Component)jLabel, gridBagConstraints2);
        this.synopsisField = this.uif.createOutputField("elb.synopsis", jLabel);
        jPanel.add((Component)this.synopsisField, gridBagConstraints3);
        JLabel jLabel2 = this.uif.createLabel("elb.kws", true);
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        this.kwField = this.uif.createOutputField("elb.kws", jLabel2);
        jPanel.add((Component)this.kwField, gridBagConstraints3);
        JLabel jLabel3 = this.uif.createLabel("elb.bugids", true);
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        this.bugIdsField = this.uif.createOutputField("elb.bugids", jLabel3);
        jPanel.add((Component)this.bugIdsField, gridBagConstraints3);
        this.setBody(jPanel);
        JButton jButton = this.uif.createHelpButton("elb.help", "exclList.window.csh");
        JButton jButton2 = this.uif.createCloseButton("elb.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
        this.setComponentListener(this.listener);
    }

    private void selectEntry(ExcludeList.Entry entry) {
        if (entry == null) {
            this.synopsisField.setText("");
            this.kwField.setText("");
            this.bugIdsField.setText("");
        } else {
            this.synopsisField.setText(entry.getSynopsis());
            String[] stringArray = entry.getPlatforms();
            String string = "";
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + stringArray[n];
                ++n;
            }
            this.kwField.setText(string);
            int[] nArray = entry.getBugIds();
            String string2 = "";
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n2 > 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + nArray[n2];
                ++n2;
            }
            this.bugIdsField.setText(string2);
        }
    }

    private String entryToString(ExcludeList.Entry entry) {
        String string = entry.getRelativeURL();
        String string2 = entry.getTestCases();
        return string2 == null ? string : string + "[" + string2 + "]";
    }

    private class Listener
    extends ComponentAdapter
    implements Interview.Observer {
        private Listener() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            ExcludeListBrowser.this.params.addObserver(this);
            ExcludeListBrowser.this.updateContent();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            ExcludeListBrowser.this.params.removeObserver(this);
        }

        public void currentQuestionChanged(Question question) {
        }

        public void pathUpdated() {
            ExcludeListBrowser.this.updateContent();
        }
    }
}

