/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

class EnvironmentBrowser
extends ToolDialog {
    private InterviewParameters params;
    private Listener listener = new Listener();
    private TestEnvironment env;
    private ElementsTableModel envTableModel = new ElementsTableModel();
    private static String[] headings;
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int DEFINED_IN_FILE = 2;
    private static final int DEFINED_IN_ENV = 3;
    static /* synthetic */ Class class$java$lang$String;

    EnvironmentBrowser(JComponent jComponent, UIFactory uIFactory) {
        super(jComponent, uIFactory, "env");
    }

    public void show(InterviewParameters interviewParameters) {
        this.params = interviewParameters;
        this.setVisible(true);
    }

    private void setEnv(TestEnvironment testEnvironment) {
        this.env = testEnvironment;
        if (testEnvironment == null || testEnvironment.getName().trim().length() == 0) {
            this.setI18NTitle("env.title.unset");
        } else {
            this.setI18NTitle("env.title.name", testEnvironment.getName());
        }
        this.envTableModel.setEnvironment(testEnvironment);
    }

    protected void initGUI() {
        this.setHelp("env.window.csh");
        JTable jTable = this.uif.createTable("env.data", this.envTableModel);
        jTable.setPreferredScrollableViewportSize(new Dimension(100, 100));
        jTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object object = mouseEvent.getSource();
                if (object instanceof JTableHeader) {
                    JTableHeader jTableHeader = (JTableHeader)object;
                    int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                    EnvironmentBrowser.this.envTableModel.sort(n);
                }
            }
        });
        JScrollPane jScrollPane = this.uif.createScrollPane(jTable);
        int n = this.uif.getDotsPerInch();
        jScrollPane.setPreferredSize(new Dimension(6 * n, 3 * n));
        this.setBody(jScrollPane);
        JButton jButton = this.uif.createHelpButton("env.help", "env.window.csh");
        JButton jButton2 = this.uif.createCloseButton("env.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
        this.setComponentListener(this.listener);
    }

    static /* synthetic */ String[] access$502(String[] stringArray) {
        headings = stringArray;
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ElementsTableModel
    extends AbstractTableModel {
        private TestEnvironment.Element[] elems;
        private TestEnvironment currEnv;

        ElementsTableModel() {
            if (headings == null) {
                EnvironmentBrowser.access$502(new String[4]);
                headings[0] = EnvironmentBrowser.this.uif.getI18NString("env.head.key");
                headings[1] = EnvironmentBrowser.this.uif.getI18NString("env.head.value");
                headings[2] = EnvironmentBrowser.this.uif.getI18NString("env.head.defInFile");
                headings[3] = EnvironmentBrowser.this.uif.getI18NString("env.head.defInEnv");
            }
        }

        public synchronized void setEnvironment(TestEnvironment testEnvironment) {
            this.currEnv = testEnvironment;
            if (this.currEnv == null) {
                this.elems = null;
            } else {
                Collection collection = this.currEnv.elements();
                this.elems = collection.toArray(new TestEnvironment.Element[collection.size()]);
                Arrays.sort(this.elems, new EnvEntryComparator(0, this.currEnv.getInherits()));
            }
            this.fireTableStructureChanged();
        }

        public void sort(int n) {
            if (this.elems != null) {
                Arrays.sort(this.elems, new EnvEntryComparator(n, this.currEnv.getInherits()));
                this.fireTableStructureChanged();
            }
        }

        private void update() {
        }

        public synchronized int getRowCount() {
            return this.elems == null ? 0 : this.elems.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            return headings[n];
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = EnvironmentBrowser.class$("java.lang.String")) : class$java$lang$String;
        }

        public synchronized Object getValueAt(int n, int n2) {
            if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
                throw new IllegalArgumentException();
            }
            TestEnvironment.Element element = this.elems[n];
            switch (n2) {
                case 0: {
                    return element.getKey();
                }
                case 3: {
                    return element.getDefinedInEnv();
                }
                case 2: {
                    return element.getDefinedInFile();
                }
                case 1: {
                    return element.getValue();
                }
            }
            throw new Error();
        }
    }

    private class EnvEntryComparator
    implements Comparator {
        private int sortMode;
        private String[] inherits;

        EnvEntryComparator(int n, String[] stringArray) {
            this.sortMode = n;
            this.inherits = stringArray;
        }

        public int compare(Object object, Object object2) {
            TestEnvironment.Element element = (TestEnvironment.Element)object;
            TestEnvironment.Element element2 = (TestEnvironment.Element)object2;
            if (this.sortMode == 0) {
                return element.getKey().compareTo(element2.getKey());
            }
            if (this.sortMode == 1) {
                int n = element.getValue().compareTo(element2.getValue());
                return n != 0 ? n : element.getKey().compareTo(element2.getKey());
            }
            if (this.sortMode == 3) {
                int n;
                int n2 = this.getInheritsIndex(element.getDefinedInEnv());
                return n2 < (n = this.getInheritsIndex(element2.getDefinedInEnv())) ? -1 : (n2 > n ? 1 : element.getKey().compareTo(element2.getKey()));
            }
            if (this.sortMode == 2) {
                int n = element.getDefinedInFile().compareTo(element2.getDefinedInFile());
                return n != 0 ? n : element.getKey().compareTo(element2.getKey());
            }
            return 0;
        }

        private int getInheritsIndex(String string) {
            int n = 0;
            while (n < this.inherits.length) {
                if (this.inherits[n].equals(string)) {
                    return n;
                }
                ++n;
            }
            return this.inherits.length;
        }
    }

    private class Listener
    extends ComponentAdapter
    implements Interview.Observer {
        private Listener() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            EnvironmentBrowser.this.params.addObserver(EnvironmentBrowser.this.listener);
            this.updateContent();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            EnvironmentBrowser.this.params.removeObserver(EnvironmentBrowser.this.listener);
        }

        public void currentQuestionChanged(Question question) {
        }

        public void pathUpdated() {
            this.updateContent();
        }

        private void updateContent() {
            EnvironmentBrowser.this.setEnv(EnvironmentBrowser.this.params.getEnv());
        }
    }
}

