/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.AllTestsFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.BasicCustomTestFilter;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.ParameterFilter;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenu;

class ET_FilterHandler {
    private FilterConfig fConfig;
    private FilterSelectionHandler fHandler;
    private ExecModel model;
    private UIFactory uif;
    private JComponent parentComponent;
    private BasicCustomTestFilter bctf;
    private ParameterFilter paramFilter;
    private TestFilter certFilter;
    private TestSuite lastTs;
    private static final String FILTER_PREFIX = "exec.vfilters";
    private static final String BTF_PREFIX = "exec.vfilters.btf";
    private static final String META_ID = "meta_tsid";
    private static final String META_NAME = "meta_tsn";
    private static final String META_CLASS = "meta_class";

    ET_FilterHandler(JComponent jComponent, ExecModel execModel, UIFactory uIFactory) {
        this.uif = uIFactory;
        this.model = execModel;
        this.parentComponent = jComponent;
    }

    FilterConfig loadFilters() {
        if (this.fConfig != null) {
            return this.fConfig;
        }
        this.fConfig = new FilterConfig(this.model, this.parentComponent);
        this.fHandler = this.fConfig.createFilterSelectionHandler();
        ParameterFilter parameterFilter = this.paramFilter = new ParameterFilter();
        this.fConfig.add(parameterFilter);
        AllTestsFilter allTestsFilter = new AllTestsFilter();
        this.fConfig.add(allTestsFilter);
        this.updateCustomFilter();
        this.fHandler.setFilter(this.paramFilter);
        return this.fConfig;
    }

    FilterSelectionHandler getFilterSelectionHandler() {
        return this.fHandler;
    }

    void updateParameters() {
        this.loadFilters();
        InterviewParameters interviewParameters = this.model.getInterviewParameters();
        if (interviewParameters == null) {
            return;
        }
        this.paramFilter.update(interviewParameters);
        this.updateCustomFilter();
        TestFilter testFilter = interviewParameters.getRelevantTestFilter();
        if (testFilter == null) {
            if (this.certFilter != null) {
                if (this.fHandler.getActiveFilter() == this.certFilter) {
                    this.fHandler.setFilter(this.paramFilter);
                }
                this.fConfig.remove(this.certFilter);
            }
        } else if (!testFilter.equals(this.certFilter)) {
            if (testFilter == this.certFilter) {
                this.fConfig.notifyUpdated(this.certFilter);
            } else {
                this.fConfig.add(testFilter);
                if (this.fHandler.getActiveFilter() == this.certFilter) {
                    this.fHandler.setFilter(testFilter);
                }
                this.fConfig.remove(this.certFilter);
                this.certFilter = testFilter;
            }
        }
    }

    JMenu getMenu() {
        this.loadFilters();
        return this.fHandler.getFilterMenu();
    }

    FilterConfig getFilterConfig() {
        return this.fConfig;
    }

    void save() {
        TestSuite testSuite = this.model.getTestSuite();
        String string = null;
        String string2 = null;
        if (testSuite != null) {
            string = testSuite.getID();
            string2 = testSuite.getName();
        }
        Preferences preferences = Preferences.access();
        int n = this.getPreferenceIndexForWrite(preferences, string);
        ConstrainedPreferenceMap constrainedPreferenceMap = new ConstrainedPreferenceMap(preferences);
        PrefixMap prefixMap = new PrefixMap(constrainedPreferenceMap, FILTER_PREFIX + n);
        if (string != null) {
            prefixMap.put(META_ID, string);
            prefixMap.put(META_NAME, string2);
        }
        prefixMap.put(META_CLASS, this.bctf.getClass().getName());
        this.bctf.save(prefixMap);
        preferences.save();
    }

    private void updateCustomFilter() {
        Preferences preferences;
        int n;
        if (this.lastTs != null) {
            return;
        }
        this.lastTs = this.model.getTestSuite();
        String string = null;
        String string2 = null;
        if (this.lastTs != null) {
            string = this.lastTs.getID();
            string2 = this.lastTs.getName();
        }
        if ((n = this.getPreferenceIndexForRead(preferences = Preferences.access(), string)) >= 0) {
            ConstrainedPreferenceMap constrainedPreferenceMap = new ConstrainedPreferenceMap(preferences);
            PrefixMap prefixMap = new PrefixMap(constrainedPreferenceMap, FILTER_PREFIX + n);
            if (this.bctf == null) {
                this.bctf = new BasicCustomTestFilter(prefixMap, this.model, this.uif);
                this.fConfig.add(this.bctf);
            } else {
                this.bctf.load(prefixMap);
                this.fHandler.updateFilterMetaInfo(this.bctf);
            }
        } else if (this.bctf == null) {
            this.bctf = new BasicCustomTestFilter(this.model, this.uif);
            this.fConfig.add(this.bctf);
        }
    }

    private int getPreferenceIndexForWrite(Preferences preferences, String string) {
        int n = 0;
        int n2 = this.getPreferenceCount(preferences);
        if (string != null && n2 != 0) {
            n = this.getPreferenceIndex(preferences, string, n2);
            if (n == -1) {
                n = ++n2;
                preferences.setPreference("exec.vfilters.count", Integer.toString(n2));
            }
        } else if (string != null && n2 == 0) {
            n = 1;
            n2 = 1;
            preferences.setPreference("exec.vfilters.count", Integer.toString(n2));
        }
        return n;
    }

    private int getPreferenceIndexForRead(Preferences preferences, String string) {
        int n = this.getPreferenceCount(preferences);
        int n2 = -1;
        n2 = n == 0 ? -1 : this.getPreferenceIndex(preferences, string, n);
        return n2;
    }

    private int getPreferenceIndex(Preferences preferences, String string, int n) {
        int n2 = -1;
        int n3 = 1;
        while (n3 <= n) {
            String string2 = preferences.getPreference(FILTER_PREFIX + n3 + "." + META_ID);
            if (string2.equals(string)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 > n) {
            return -1;
        }
        return n2;
    }

    private int getPreferenceCount(Preferences preferences) {
        int n = Integer.parseInt(preferences.getPreference("exec.vfilters.count", "0"));
        return n;
    }

    private class FilterWatcher
    implements FilterSelectionHandler.Observer {
        private FilterWatcher() {
        }

        public void filterUpdated(TestFilter testFilter) {
        }

        public void filterSelected(TestFilter testFilter) {
        }

        public void filterAdded(TestFilter testFilter) {
        }

        public void filterRemoved(TestFilter testFilter) {
        }
    }

    private static class ConstrainedPreferenceMap
    implements Map {
        private Preferences prefs;

        ConstrainedPreferenceMap(Preferences preferences) {
            this.prefs = preferences;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public Object get(Object object) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("key must be a string");
            }
            return this.prefs.getPreference((String)object);
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Object put(Object object, Object object2) {
            if (!(object instanceof String) || !(object2 instanceof String)) {
                throw new IllegalArgumentException("both args must be strings");
            }
            this.prefs.setPreference((String)object, (String)object2);
            return null;
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public void put(String string, String string2) {
            this.prefs.setPreference(string, string2);
        }

        public String get(String string) {
            return this.prefs.getPreference(string);
        }
    }
}

