/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeListUpdateHandler;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ChecklistBrowser;
import com.sun.javatest.exec.ConfigEditor;
import com.sun.javatest.exec.EnvironmentBrowser;
import com.sun.javatest.exec.ExcludeListBrowser;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.QuestionLogBrowser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ConfigHandler {
    private JComponent parent;
    private UIFactory uif;
    private ExecModel model;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters interviewParams;
    private Interview.Observer observer;
    private Action loadConfigAction;
    private Action newConfigAction;
    private Action showConfigAction;
    private Action showFullConfigAction;
    private Action showStdConfigAction;
    private Action showEnvironmentAction;
    private Action showExcludeListAction;
    private Action showChecklistAction;
    private Action showQuestionLogAction;
    private ConfigEditor configEditor;
    private FileHistory.Listener configHistoryListener;
    private ChecklistBrowser checkListBrowser;
    private EnvironmentBrowser environmentBrowser;
    private ExcludeListBrowser excludeListBrowser;
    private QuestionLogBrowser questionLogBrowser;

    ConfigHandler(JComponent jComponent, ExecModel execModel, UIFactory uIFactory) {
        this.parent = jComponent;
        this.model = execModel;
        this.uif = uIFactory;
        this.initActions();
    }

    void dispose() {
        if (this.configEditor != null) {
            this.configEditor.dispose();
        }
        if (this.checkListBrowser != null) {
            this.checkListBrowser.dispose();
        }
        if (this.environmentBrowser != null) {
            this.environmentBrowser.dispose();
        }
        if (this.excludeListBrowser != null) {
            this.excludeListBrowser.dispose();
        }
        if (this.questionLogBrowser != null) {
            this.questionLogBrowser.dispose();
        }
    }

    JMenu getMenu() {
        Action[] actionArray = new Action[]{this.newConfigAction, this.loadConfigAction, this.showConfigAction, null, this.showChecklistAction, this.showExcludeListAction, this.showEnvironmentAction, this.showQuestionLogAction, null};
        JMenu jMenu = this.uif.createMenu("ch", actionArray);
        this.configHistoryListener = new FileHistory.Listener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                File file = (File)jMenuItem.getClientProperty(FileHistory.FILE);
                if (file != null) {
                    ConfigHandler.this.ensureConfigEditorInitialized();
                    ConfigHandler.this.configEditor.load(file);
                }
            }
        });
        jMenu.addMenuListener(this.configHistoryListener);
        return jMenu;
    }

    Action[] getToolBarActions() {
        return new Action[]{this.showFullConfigAction, this.showStdConfigAction};
    }

    boolean isConfigEdited() {
        return this.configEditor != null && this.configEditor.isEdited();
    }

    void checkExcludeListUpdate(JComponent jComponent, boolean bl) {
        block5: {
            try {
                Parameters.ExcludeListParameters excludeListParameters = this.interviewParams.getExcludeListParameters();
                if (!(excludeListParameters instanceof Parameters.MutableExcludeListParameters)) {
                    return;
                }
                Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)excludeListParameters;
                URL uRL = this.testSuite.getLatestExcludeList();
                File file = this.workDir.getSystemFile("latest.jtx");
                ExcludeListUpdateHandler excludeListUpdateHandler = new ExcludeListUpdateHandler(uRL, file);
                if (bl && !excludeListUpdateHandler.isUpdateAvailable()) {
                    return;
                }
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 13;
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridwidth = 0;
                gridBagConstraints2.fill = 2;
                gridBagConstraints2.weightx = 1.0;
                JLabel jLabel = this.uif.createLabel("ch.elu.remote");
                JTextField jTextField = this.uif.createOutputField("ch.elu.remote");
                jTextField.setBorder(null);
                long l = excludeListUpdateHandler.getRemoteURLLastModified();
                String string = l <= 0L ? this.uif.getI18NString("ch.elu.notAvailable") : new Date(l).toString();
                jTextField.setText(string);
                jTextField.setColumns(string.length());
                jLabel.setLabelFor(jTextField);
                jPanel.add((Component)jLabel, gridBagConstraints);
                jPanel.add((Component)jTextField, gridBagConstraints2);
                JLabel jLabel2 = this.uif.createLabel("ch.elu.local");
                JTextField jTextField2 = this.uif.createOutputField("ch.elu.local");
                jTextField2.setBorder(null);
                long l2 = excludeListUpdateHandler.getLocalFileLastModified();
                String string2 = l2 <= 0L ? this.uif.getI18NString("ch.elu.notAvailable") : new Date(l2).toString();
                jTextField2.setText(string2);
                jTextField2.setColumns(string2.length());
                jLabel2.setLabelFor(jTextField2);
                jPanel.add((Component)jLabel2, gridBagConstraints);
                jPanel.add((Component)jTextField2, gridBagConstraints2);
                if (excludeListUpdateHandler.isUpdateAvailable()) {
                    String string3;
                    String string4 = this.uif.getI18NString("ch.elu.update.title");
                    String string5 = this.uif.getI18NString("ch.elu.update.head");
                    int n = JOptionPane.showConfirmDialog(jComponent, new Object[]{string5, jPanel, string3 = this.uif.getI18NString("ch.elu.update.foot")}, string4, 0);
                    if (n != 0) break block5;
                    excludeListUpdateHandler.update();
                    break block5;
                }
                String string6 = this.uif.getI18NString("ch.elu.noUpdate.title");
                String string7 = this.uif.getI18NString("ch.elu.noUpdate.head");
                JOptionPane.showMessageDialog(jComponent, new Object[]{string7, jPanel}, string6, 1);
            }
            catch (IOException iOException) {
                I18NResourceBundle i18NResourceBundle = this.uif.getI18NResourceBundle();
                this.workDir.log(i18NResourceBundle, "ch.elu.logError", iOException);
                this.uif.showError("ch.elu.error", iOException);
            }
        }
    }

    boolean ensureInterviewUpToDate() {
        try {
            if (this.interviewParams.isFileNewer()) {
                this.interviewParams.load();
            }
            return true;
        }
        catch (IOException iOException) {
            this.uif.showError("exec.loadInterview", iOException.toString());
            return false;
        }
        catch (Interview.Fault fault) {
            this.uif.showError("exec.loadInterview", fault.getMessage());
            return false;
        }
    }

    void ensureConfigEditorInitialized() {
        if (this.workDir == null) {
            throw new IllegalStateException();
        }
        if (this.configEditor == null) {
            this.configEditor = new ConfigEditor(this.parent, this.interviewParams, this.uif);
            this.configEditor.setCheckExcludeListListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    JComponent jComponent = object instanceof JComponent ? (JComponent)object : ConfigHandler.this.parent;
                    ConfigHandler.this.checkExcludeListUpdate(jComponent, false);
                }
            });
        }
    }

    void showConfigEditor(ActionListener actionListener) {
        this.ensureConfigEditorInitialized();
        this.configEditor.show(actionListener);
    }

    void updateGUI() {
        this.testSuite = this.model.getTestSuite();
        this.workDir = this.model.getWorkDirectory();
        this.interviewParams = this.model.getInterviewParameters();
        if (this.interviewParams != null) {
            this.ensureInterviewUpToDate();
        }
        boolean bl = this.testSuite != null;
        this.newConfigAction.setEnabled(bl);
        this.loadConfigAction.setEnabled(bl);
        this.showConfigAction.setEnabled(bl);
        this.showFullConfigAction.setEnabled(bl);
        this.showStdConfigAction.setEnabled(bl);
        this.showExcludeListAction.setEnabled(bl);
        this.showEnvironmentAction.setEnabled(bl);
        this.showQuestionLogAction.setEnabled(bl);
        this.showChecklistAction.setEnabled(bl && this.interviewParams != null && !this.interviewParams.isChecklistEmpty());
        if (this.workDir != null && this.configHistoryListener.getFileHistory() == null) {
            FileHistory fileHistory = FileHistory.getFileHistory(this.workDir, "configHistory.jtl");
            this.configHistoryListener.setFileHistory(fileHistory);
        }
        if (this.interviewParams != null && this.observer == null) {
            this.observer = new Interview.Observer(){

                public void currentQuestionChanged(Question question) {
                }

                public void pathUpdated() {
                    ConfigHandler.this.showChecklistAction.setEnabled(!ConfigHandler.this.interviewParams.isChecklistEmpty());
                }
            };
            this.interviewParams.addObserver(this.observer);
        }
    }

    void loadConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.load();
    }

    void newConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.clear();
    }

    void showConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show();
    }

    void showConfig(String string) {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(string);
    }

    void showEnvironment() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.environmentBrowser == null) {
            this.environmentBrowser = new EnvironmentBrowser(this.parent, this.uif);
        }
        this.environmentBrowser.show(this.interviewParams);
    }

    void showExcludeList() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.excludeListBrowser == null) {
            this.excludeListBrowser = new ExcludeListBrowser(this.parent, this.uif);
        }
        this.excludeListBrowser.show(this.interviewParams);
    }

    void showChecklist() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.checkListBrowser == null) {
            this.checkListBrowser = new ChecklistBrowser(this.parent, this.interviewParams, this.uif);
        }
        this.checkListBrowser.setVisible(true);
    }

    void showQuestionLog() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.questionLogBrowser == null) {
            this.questionLogBrowser = new QuestionLogBrowser(this.parent, this.interviewParams, this.uif);
        }
        this.questionLogBrowser.setVisible(true);
    }

    private boolean isOKToContinue() {
        int n = this.uif.showOKCancelDialog("ch.edited.warn");
        return n == 0;
    }

    private void initActions() {
        this.loadConfigAction = new ToolAction(this.uif, "ch.load"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.loadConfig();
            }
        };
        this.newConfigAction = new ToolAction(this.uif, "ch.new"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.newConfig();
            }
        };
        this.showConfigAction = new ToolAction(this.uif, "ch.edit"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showConfig();
            }
        };
        this.showFullConfigAction = new ToolAction(this.uif, "ch.full", true){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showConfig("full");
            }
        };
        this.showStdConfigAction = new ToolAction(this.uif, "ch.std", true){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showConfig("std");
            }
        };
        this.showEnvironmentAction = new ToolAction(this.uif, "ch.env"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showEnvironment();
            }
        };
        this.showExcludeListAction = new ToolAction(this.uif, "ch.excl"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showExcludeList();
            }
        };
        this.showChecklistAction = new ToolAction(this.uif, "ch.checkList"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showChecklist();
            }
        };
        this.showQuestionLogAction = new ToolAction(this.uif, "ch.quLog"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showQuestionLog();
            }
        };
    }
}

