/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Checklist;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class ChecklistBrowser
extends ToolDialog {
    private InterviewParameters params;
    private JScrollPane scrollPane;
    private JEditorPane body;
    private Listener listener;

    ChecklistBrowser(JComponent jComponent, InterviewParameters interviewParameters, UIFactory uIFactory) {
        super(jComponent, uIFactory, "cb");
        if (interviewParameters == null) {
            throw new NullPointerException();
        }
        this.params = interviewParameters;
        this.listener = new Listener();
    }

    protected void initGUI() {
        this.setHelp("checklist.window.csh");
        this.body = new JEditorPane();
        this.body.setContentType("text/html");
        this.body.setText("");
        this.body.setEditable(false);
        this.body.addHyperlinkListener(this.listener);
        this.body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.uif.setAccessibleName(this.body, "cb");
        this.uif.setToolTip(this.body, "cb");
        this.scrollPane = this.uif.createScrollPane(this.body);
        int n = this.uif.getDotsPerInch();
        this.scrollPane.setPreferredSize(new Dimension(6 * n, 8 * n));
        this.setBody(this.scrollPane);
        JButton jButton = this.uif.createHelpButton("cb.help", "checklist.window.csh");
        JButton jButton2 = this.uif.createCloseButton("cb.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
        this.setComponentListener(this.listener);
    }

    private void updateContent() {
        File file;
        if (this.body == null) {
            this.initGUI();
        }
        if ((file = this.params.getFile()) == null) {
            this.setI18NTitle("cb.title");
        } else {
            this.setI18NTitle("cb.titleWithFile", file);
        }
        try {
            Checklist checklist = this.params.createChecklist();
            StringWriter stringWriter = new StringWriter();
            this.writeChecklist(checklist, stringWriter);
        }
        catch (IOException iOException) {}
    }

    private void writeChecklist(Checklist checklist, Writer writer) throws IOException {
        writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n");
        writer.write("<html><body>\n");
        TestEnvironment testEnvironment = this.params.getEnv();
        if (testEnvironment != null) {
            writer.write("<h1>");
            writer.write(this.escape(this.uif.getI18NString("cb.html.title", testEnvironment.getName())));
            writer.write("</h1>\n");
        }
        if (checklist.isEmpty()) {
            writer.write(this.escape(this.uif.getI18NString("cb.html.noEntries")));
        } else {
            writer.write(this.escape(this.uif.getI18NString("cb.html.intro")));
            String[] stringArray = checklist.getSectionNames();
            int n = 0;
            while (n < stringArray.length) {
                this.writeSection(checklist, stringArray[n], writer);
                ++n;
            }
        }
        writer.write("</body></html>");
        writer.close();
        this.body.setText(writer.toString());
        this.body.getCaret().setDot(0);
    }

    private void writeSection(Checklist checklist, String string, Writer writer) throws IOException {
        writer.write("<h2>");
        writer.write(this.escape(string));
        writer.write("</h2>\n");
        writer.write("<ul>");
        String[] stringArray = checklist.getSectionMessages(string);
        int n = 0;
        while (n < stringArray.length) {
            writer.write("<li>");
            writer.write(this.escape(stringArray[n]));
            writer.write("\n");
            ++n;
        }
        writer.write("</ul>\n");
    }

    private String escape(String string) {
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '&': 
                case '<': 
                case '>': {
                    StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
                    int n2 = 0;
                    while (n2 < string.length()) {
                        char c = string.charAt(n2);
                        switch (c) {
                            case '<': {
                                stringBuffer.append("&lt;");
                                break;
                            }
                            case '>': {
                                stringBuffer.append("&gt;");
                                break;
                            }
                            case '&': {
                                stringBuffer.append("&amp;");
                                break;
                            }
                            default: {
                                stringBuffer.append(c);
                            }
                        }
                        ++n2;
                    }
                    return stringBuffer.toString();
                }
            }
            ++n;
        }
        return string;
    }

    private class Listener
    extends ComponentAdapter
    implements HyperlinkListener,
    Interview.Observer {
        private Listener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getDescription();
                if (!string.startsWith("#")) {
                    return;
                }
                ChecklistBrowser.this.body.scrollToReference(string.substring(1));
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            ChecklistBrowser.this.params.addObserver(this);
            ChecklistBrowser.this.updateContent();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            ChecklistBrowser.this.params.removeObserver(this);
        }

        public void currentQuestionChanged(Question question) {
        }

        public void pathUpdated() {
            ChecklistBrowser.this.updateContent();
        }
    }
}

