/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.TestTreeSelectionPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.help.CSH;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_TestsPane
extends CE_StdPane {
    private Parameters.TestsParameters testsParameters;
    private Parameters.MutableTestsParameters mutableTestsParameters;
    private ButtonGroup btnGrp;
    private JRadioButton allTestsBtn;
    private JRadioButton selectTestsBtn;
    private TestTreeSelectionPane testsField;

    CE_TestsPane(UIFactory uIFactory, InterviewParameters interviewParameters) {
        super(uIFactory, interviewParameters, "tests");
        this.testsParameters = interviewParameters.getTestsParameters();
        this.mutableTestsParameters = this.testsParameters instanceof Parameters.MutableTestsParameters ? (Parameters.MutableTestsParameters)this.testsParameters : null;
        this.initGUI();
    }

    boolean isOKToClose() {
        if (this.mutableTestsParameters == null) {
            return true;
        }
        if (this.selectTestsBtn.isSelected() && this.testsField.isSelectionEmpty()) {
            this.uif.showError("ce.tests.noTests");
            return false;
        }
        return true;
    }

    void load() {
        if (this.mutableTestsParameters != null) {
            int n = this.mutableTestsParameters.getTestsMode();
            if (n == 1) {
                this.allTestsBtn.setSelected(true);
            } else {
                this.selectTestsBtn.setSelected(true);
            }
            this.testsField.setSelection(this.mutableTestsParameters.getSpecifiedTests());
            this.testsField.setEnabled(this.selectTestsBtn.isSelected());
        } else {
            this.mutableTestsParameters = null;
            String[] stringArray = this.testsParameters.getTests();
            if (stringArray == null || stringArray.length == 0) {
                this.allTestsBtn.setSelected(true);
                this.testsField.clear();
            } else {
                this.selectTestsBtn.setSelected(true);
                this.testsField.setSelection(stringArray);
            }
            this.allTestsBtn.setEnabled(false);
            this.selectTestsBtn.setEnabled(false);
            this.testsField.setEnabled(false);
        }
    }

    void save() {
        if (this.mutableTestsParameters != null) {
            if (this.allTestsBtn.isSelected()) {
                this.mutableTestsParameters.setTestsMode(1);
            } else if (this.selectTestsBtn.isSelected()) {
                this.mutableTestsParameters.setTestsMode(2);
            }
            this.mutableTestsParameters.setSpecifiedTests(this.testsField.getSelection());
        }
    }

    private void initGUI() {
        CSH.setHelpIDString(this, "confEdit.testsTab.csh");
        JPanel jPanel = this.uif.createPanel("ce.tests", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.btnGrp = new ButtonGroup();
        this.allTestsBtn = this.uif.createRadioButton("ce.tests.all", this.btnGrp);
        jPanel.add((Component)this.allTestsBtn, gridBagConstraints);
        this.selectTestsBtn = this.uif.createRadioButton("ce.tests.select", this.btnGrp);
        this.selectTestsBtn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CE_TestsPane.this.testsField.setEnabled(CE_TestsPane.this.selectTestsBtn.isSelected());
            }
        });
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.selectTestsBtn, gridBagConstraints);
        this.testsField = new TestTreeSelectionPane(this.config.getWorkDirectory().getTestResultTable());
        this.testsField.setEnabled(this.selectTestsBtn.isSelected());
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.testsField, gridBagConstraints);
        this.addBody(jPanel);
    }
}

