/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.CE_EnvironmentPane;
import com.sun.javatest.exec.CE_ExcludeListPane;
import com.sun.javatest.exec.CE_ExecutionPane;
import com.sun.javatest.exec.CE_KeywordsPane;
import com.sun.javatest.exec.CE_PriorStatusPane;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.exec.CE_TestsPane;
import com.sun.javatest.exec.CE_View;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.help.CSH;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_StdView
extends CE_View {
    private JTabbedPane tabs;
    private CE_StdPane[] panes;
    private JTextField msgField;
    private Listener localListener = new Listener();

    CE_StdView(InterviewParameters interviewParameters, JHelpContentViewer jHelpContentViewer, UIFactory uIFactory, ActionListener actionListener) {
        super(interviewParameters, jHelpContentViewer, uIFactory, actionListener);
        this.initGUI();
    }

    public Dimension getPreferredSize() {
        Serializable serializable;
        Insets insets = this.tabs.getInsets();
        int n = insets == null ? 0 : insets.left + insets.right;
        Graphics graphics = this.tabs.getGraphics();
        if (graphics != null) {
            serializable = graphics.getFontMetrics();
            int n2 = 0;
            while (n2 < this.tabs.getTabCount()) {
                n += 15 + ((FontMetrics)serializable).stringWidth(this.tabs.getTitleAt(n2));
                ++n2;
            }
        }
        serializable = super.getPreferredSize();
        ((Dimension)serializable).width = Math.max(((Dimension)serializable).width, n);
        return serializable;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.load();
        }
        super.setVisible(bl);
    }

    boolean isOKToClose() {
        CE_StdPane cE_StdPane = (CE_StdPane)this.tabs.getSelectedComponent();
        if (cE_StdPane == null) {
            return true;
        }
        return cE_StdPane.isOKToClose();
    }

    void load() {
        int n = 0;
        while (n < this.panes.length) {
            this.panes[n].load();
            ++n;
        }
    }

    void save() {
        int n = 0;
        while (n < this.panes.length) {
            this.panes[n].save();
            ++n;
        }
    }

    void setCheckExcludeListListener(ActionListener actionListener) {
        int n = 0;
        while (n < this.panes.length) {
            CE_StdPane cE_StdPane = this.panes[n];
            if (cE_StdPane instanceof CE_ExcludeListPane) {
                ((CE_ExcludeListPane)cE_StdPane).setCheckExcludeListListener(actionListener);
            }
            ++n;
        }
    }

    private void initGUI() {
        this.setName("std");
        CSH.setHelpIDString(this, "confEdit.stdView.csh");
        this.setLayout(new BorderLayout());
        this.initBody();
        this.initButtons();
    }

    private void initBody() {
        this.panes = new CE_StdPane[]{new CE_TestsPane(this.uif, this.config), new CE_ExcludeListPane(this.uif, this.config), new CE_KeywordsPane(this.uif, this.config), new CE_PriorStatusPane(this.uif, this.config), new CE_EnvironmentPane(this.uif, this.config), new CE_ExecutionPane(this.uif, this.config)};
        this.tabs = new JTabbedPane(){

            public void setSelectedIndex(int n) {
                if (n == this.getSelectedIndex()) {
                    return;
                }
                CE_StdPane cE_StdPane = (CE_StdPane)this.getSelectedComponent();
                if (cE_StdPane != null && !cE_StdPane.isOKToClose()) {
                    return;
                }
                super.setSelectedIndex(n);
            }
        };
        this.tabs.setName("tabs");
        this.uif.setAccessibleName(this.tabs, "ce.tabs");
        this.uif.setToolTip(this.tabs, "ce.tabs");
        int n = 0;
        while (n < this.panes.length) {
            if (this.panes[n].isEnabled()) {
                this.uif.addTab(this.tabs, "ce." + this.panes[n].getName(), this.panes[n]);
            }
            ++n;
        }
        this.tabs.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tabs.addChangeListener(this.localListener);
        this.add((Component)this.tabs, "Center");
        this.addAncestorListener(this.localListener);
    }

    private void initButtons() {
        JPanel jPanel = this.uif.createPanel("ce.std.btns", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 11;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.left = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.msgField = this.uif.createOutputField("ce.msgs");
        this.msgField.setBorder(null);
        this.msgField.setEnabled(false);
        jPanel.add((Component)this.msgField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 11;
        JButton jButton = this.uif.createButton("ce.done", this.listener, "done");
        jPanel.add((Component)jButton, gridBagConstraints);
        this.add((Component)jPanel, "South");
    }

    private void showInfoForTab(CE_StdPane cE_StdPane) {
        Map.ID iD = (Map.ID)cE_StdPane.getClientProperty(this);
        if (iD == null) {
            Map map;
            String string = "ConfigEditor.stdValues." + cE_StdPane.getName();
            HelpSet helpSet = this.config.getHelpSet();
            if (helpSet != null && (map = helpSet.getCombinedMap()).isValidID(string, helpSet)) {
                iD = Map.ID.create(string, helpSet);
                cE_StdPane.putClientProperty(this, iD);
            }
        }
        if (iD == null) {
            System.err.println("CESV: no help for " + cE_StdPane);
        } else {
            this.showInfo(iD);
        }
    }

    private class Listener
    implements AncestorListener,
    ChangeListener {
        private Listener() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.updateCSHAndInfo();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateCSHAndInfo();
        }

        private void updateCSHAndInfo() {
            CE_StdPane cE_StdPane = (CE_StdPane)CE_StdView.this.tabs.getSelectedComponent();
            CSH.setHelpIDString(CE_StdView.this.tabs, CSH.getHelpIDString(cE_StdPane));
            CE_StdView.this.showInfoForTab(cE_StdPane);
        }
    }
}

