/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Keywords;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.Caret;

class CE_KeywordsPane
extends CE_StdPane {
    private Parameters.KeywordsParameters keywordsParameters;
    private Parameters.MutableKeywordsParameters mutableKeywordsParameters;
    private JCheckBox selectCheck;
    private JComboBox keywordsChoice;
    private JTextField keywordsField;
    private JButton keywordBtn;
    private JPopupMenu keywordPopup;
    private JButton opBtn;
    private JPopupMenu opPopup;
    private Listener listener = new Listener();
    private static final String ALL_OF = "allOf";
    private static final String ANY_OF = "anyOf";
    private static final String EXPR = "expr";
    private static final String IGNORE = "ignore";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String NOT = "not";
    private static final String PARENS = "parens";

    CE_KeywordsPane(UIFactory uIFactory, InterviewParameters interviewParameters) {
        super(uIFactory, interviewParameters, "keywords");
        this.keywordsParameters = interviewParameters.getKeywordsParameters();
        this.mutableKeywordsParameters = this.keywordsParameters instanceof Parameters.MutableKeywordsParameters ? (Parameters.MutableKeywordsParameters)this.keywordsParameters : null;
        this.initGUI();
    }

    boolean isOKToClose() {
        if (this.mutableKeywordsParameters == null) {
            return true;
        }
        if (!this.selectCheck.isSelected()) {
            return true;
        }
        try {
            TestSuite testSuite = this.config.getTestSuite();
            String[] stringArray = testSuite.getKeywords();
            HashSet<String> hashSet = stringArray == null ? null : new HashSet<String>(Arrays.asList(stringArray));
            String string = (String)this.keywordsChoice.getSelectedItem();
            String string2 = string.equals(ANY_OF) ? "any of" : (string.equals(ALL_OF) ? "all of" : EXPR);
            Keywords keywords = Keywords.create(string2, this.keywordsField.getText(), hashSet);
            return true;
        }
        catch (Keywords.Fault fault) {
            this.uif.showError("ce.keywords.invalid", fault.getMessage());
            return false;
        }
    }

    void load() {
        if (this.mutableKeywordsParameters != null) {
            this.setEnabled(true);
            int n = this.mutableKeywordsParameters.getKeywordsMode();
            this.selectCheck.setSelected(n == 2);
            int n2 = this.mutableKeywordsParameters.getMatchKeywordsMode();
            switch (n2) {
                case 1: {
                    this.keywordsChoice.setSelectedItem(ANY_OF);
                    break;
                }
                case 2: {
                    this.keywordsChoice.setSelectedItem(ALL_OF);
                    break;
                }
                case 3: {
                    this.keywordsChoice.setSelectedItem(EXPR);
                }
            }
            String string = this.mutableKeywordsParameters.getMatchKeywordsValue();
            this.keywordsField.setText(string == null ? "" : string);
        } else if (this.keywordsParameters != null) {
            this.setEnabled(true);
            String string = this.keywordsParameters.getKeywords().toString();
            this.selectCheck.setSelected(string.length() == 0);
            this.selectCheck.setEnabled(false);
            this.keywordsChoice.setSelectedItem(EXPR);
            this.keywordsField.setText(string);
            this.keywordsChoice.setEnabled(false);
        } else {
            this.setEnabled(false);
            this.selectCheck.setEnabled(false);
            this.keywordsChoice.setSelectedItem(EXPR);
            this.keywordsField.setText("");
            this.keywordsChoice.setEnabled(false);
        }
        this.enableKeywordFields();
    }

    void save() {
        if (this.mutableKeywordsParameters != null) {
            int n = this.selectCheck.isSelected() ? 2 : 1;
            this.mutableKeywordsParameters.setKeywordsMode(n);
            String string = (String)this.keywordsChoice.getSelectedItem();
            int n2 = string.equals(ANY_OF) ? 1 : (string.equals(ALL_OF) ? 2 : 3);
            this.mutableKeywordsParameters.setMatchKeywords(n2, this.keywordsField.getText());
        }
    }

    private void initGUI() {
        CSH.setHelpIDString(this, "confEdit.keywordsTab.csh");
        JPanel jPanel = this.uif.createPanel("ce.keywords", new BorderLayout(), false);
        JPanel jPanel2 = this.uif.createPanel("ce.keywords.body", new GridBagLayout(), false);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.selectCheck = this.uif.createCheckBox("ce.keywords.select");
        this.selectCheck.addChangeListener(this.listener);
        jPanel2.add((Component)this.selectCheck, gridBagConstraints);
        String[] stringArray = new String[]{ANY_OF, ALL_OF, EXPR};
        this.keywordsChoice = this.uif.createChoice("ce.keywords.choice", stringArray);
        this.keywordsChoice.addItemListener(this.listener);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 17;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.keywordsChoice, gridBagConstraints);
        this.keywordsField = this.uif.createInputField("ce.keywords.field", 20);
        this.uif.setAccessibleName(this.keywordsField, "ce.keywords.field");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.keywordsField, gridBagConstraints);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.uif.createPanel("ce.keywords.foot", new GridBagLayout(), false);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        DropDownIcon dropDownIcon = new DropDownIcon();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 1;
        this.keywordBtn = this.uif.createButton("ce.keywords.keyword", this.listener);
        this.keywordBtn.setIcon(dropDownIcon);
        this.keywordBtn.setHorizontalTextPosition(10);
        jPanel3.add((Component)this.keywordBtn, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.opBtn = this.uif.createButton("ce.keywords.op", this.listener);
        this.opBtn.setIcon(dropDownIcon);
        this.opBtn.setHorizontalTextPosition(10);
        jPanel3.add((Component)this.opBtn, gridBagConstraints);
        jPanel.add((Component)jPanel3, "South");
        this.addBody(jPanel);
        String[] stringArray2 = new String[]{AND, OR, NOT, PARENS};
        this.opPopup = this.uif.createPopupMenu("ce.keywords.op", stringArray2, this.listener);
        String[] stringArray3 = this.config.getTestSuite().getKeywords();
        if (stringArray3 != null) {
            if (stringArray3.length == 0) {
                this.setEnabled(false);
            } else {
                this.keywordPopup = this.uif.createPopupMenu("ce.keywords.keyword");
                int n = 0;
                while (n < stringArray3.length) {
                    this.keywordPopup.add(this.uif.createLiteralMenuItem(stringArray3[n], this.listener));
                    ++n;
                }
            }
        }
    }

    private void enableKeywordFields() {
        boolean bl = this.selectCheck.isEnabled() && this.selectCheck.isSelected();
        this.keywordsChoice.setEnabled(bl);
        this.keywordsField.setEnabled(bl);
        this.opBtn.setEnabled(bl && this.keywordsChoice.getSelectedItem().equals(EXPR));
        this.keywordBtn.setEnabled(bl && this.keywordPopup != null);
    }

    private static class DropDownIcon
    implements Icon {
        private DropDownIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JComponent jComponent = (JComponent)component;
            int n3 = this.getIconWidth();
            graphics.translate(n, n2);
            graphics.setColor(jComponent.isEnabled() ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlShadow());
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(1, 1, 1 + (n3 - 3), 1);
            graphics.drawLine(2, 2, 2 + (n3 - 5), 2);
            graphics.drawLine(3, 3, 3 + (n3 - 7), 3);
            graphics.drawLine(4, 4, 4 + (n3 - 9), 4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 5;
        }
    }

    private class Listener
    implements ActionListener,
    ChangeListener,
    ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (component == CE_KeywordsPane.this.keywordBtn) {
                this.show(CE_KeywordsPane.this.keywordBtn, CE_KeywordsPane.this.keywordPopup);
            } else if (component == CE_KeywordsPane.this.opBtn) {
                this.show(CE_KeywordsPane.this.opBtn, CE_KeywordsPane.this.opPopup);
            } else if (string.equals(CE_KeywordsPane.AND)) {
                this.insert("&");
            } else if (string.equals(CE_KeywordsPane.OR)) {
                this.insert("|");
            } else if (string.equals(CE_KeywordsPane.NOT)) {
                this.insert("!");
            } else if (string.equals(CE_KeywordsPane.PARENS)) {
                this.insert("()");
                CE_KeywordsPane.this.keywordsField.setCaretPosition(CE_KeywordsPane.this.keywordsField.getCaretPosition() - 1);
            } else if (component.getParent() == CE_KeywordsPane.this.keywordPopup) {
                this.insert(string);
            }
        }

        private void show(Component component, JPopupMenu jPopupMenu) {
            jPopupMenu.show(component, 0, component.getHeight());
        }

        private void insert(String string) {
            boolean bl;
            boolean bl2;
            if (string.length() == 0) {
                return;
            }
            String string2 = CE_KeywordsPane.this.keywordsField.getText();
            Caret caret = CE_KeywordsPane.this.keywordsField.getCaret();
            int n = Math.min(caret.getDot(), caret.getMark());
            int n2 = Math.max(caret.getDot(), caret.getMark());
            boolean bl3 = bl2 = Character.isLetterOrDigit(string.charAt(0)) && n > 0 && Character.isLetterOrDigit(string2.charAt(n - 1));
            if (bl2) {
                string = " " + string;
            }
            boolean bl4 = bl = Character.isLetterOrDigit(string.charAt(string.length() - 1)) && n2 < string2.length() && Character.isLetterOrDigit(string2.charAt(n2));
            if (bl) {
                string = string + " ";
            }
            CE_KeywordsPane.this.keywordsField.replaceSelection(string);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CE_KeywordsPane.this.enableKeywordFields();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            CE_KeywordsPane.this.enableKeywordFields();
        }
    }
}

