/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.WizPane;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.CE_View;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.CSH;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class CE_FullView
extends CE_View {
    private JMenu searchMenu;
    private WizPane wizPane;
    private JTextField msgField;
    private String completeMsg;
    private String incompleteMsg;
    private JButton backBtn;
    private JButton nextBtn;
    private JButton lastBtn;
    private Listener localListener = new Listener();
    private static final String BACK = "back";
    private static final String NEXT = "next";
    private static final String LAST = "last";
    private static final String FIND = "find";
    private static final String FIND_NEXT = "findNext";

    CE_FullView(InterviewParameters interviewParameters, JHelpContentViewer jHelpContentViewer, UIFactory uIFactory, ActionListener actionListener) {
        super(interviewParameters, jHelpContentViewer, uIFactory, actionListener);
        this.initGUI();
    }

    JMenu getSearchMenu() {
        return this.searchMenu;
    }

    boolean isOKToClose() {
        return true;
    }

    void load() {
    }

    void save() {
        this.wizPane.save();
    }

    private void initGUI() {
        this.setName("full");
        CSH.setHelpIDString(this, "confEdit.fullView.csh");
        String[] stringArray = new String[]{FIND, FIND_NEXT};
        this.searchMenu = this.uif.createMenu("ce.search", stringArray, this.localListener);
        this.setLayout(new BorderLayout());
        this.initBody();
        this.initButtons();
    }

    private void initBody() {
        this.wizPane = new WizPane(this.config, false);
        this.wizPane.setHelpPrefix("confEdit.");
        this.wizPane.setHelpBroker(Desktop.access().getHelpBroker());
        this.wizPane.addAncestorListener(this.localListener);
        this.add((Component)this.wizPane, "Center");
    }

    private void initButtons() {
        JPanel jPanel = this.uif.createPanel("ce.full.btns", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 11;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.left = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.msgField = this.uif.createOutputField("ce.msgs");
        this.msgField.setBorder(null);
        this.msgField.setEnabled(false);
        this.completeMsg = this.uif.getI18NString("ce.msgs.complete");
        this.incompleteMsg = this.uif.getI18NString("ce.msgs.incomplete");
        jPanel.add((Component)this.msgField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        this.backBtn = this.uif.createButton("ce.full.back", this.localListener, BACK);
        this.backBtn.setIcon(this.uif.createIcon("ce.full.back"));
        this.backBtn.setHorizontalTextPosition(11);
        jPanel.add((Component)this.backBtn, gridBagConstraints);
        this.nextBtn = this.uif.createButton("ce.full.next", this.localListener, NEXT);
        this.nextBtn.setIcon(this.uif.createIcon("ce.full.next"));
        this.nextBtn.setHorizontalTextPosition(10);
        jPanel.add((Component)this.nextBtn, gridBagConstraints);
        this.lastBtn = this.uif.createButton("ce.full.last", this.localListener, LAST);
        this.lastBtn.setIcon(this.uif.createIcon("ce.full.last"));
        this.lastBtn.setHorizontalTextPosition(10);
        jPanel.add((Component)this.lastBtn, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        gridBagConstraints.insets.right = 11;
        JButton jButton = this.uif.createButton("ce.done", this.listener, "done");
        jPanel.add((Component)jButton, gridBagConstraints);
        this.add((Component)jPanel, "South");
    }

    private void showInfoForQuestion(Question question) {
        if (question instanceof ErrorQuestion) {
            return;
        }
        Map.ID iD = question.getHelpID();
        if (iD == null) {
            System.err.println("WARNING: no help for " + question.getKey());
        } else {
            this.showInfo(iD);
        }
    }

    private class Listener
    implements ActionListener,
    AncestorListener,
    Interview.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(CE_FullView.NEXT)) {
                CE_FullView.this.wizPane.next();
            } else if (string.equals(CE_FullView.BACK)) {
                CE_FullView.this.wizPane.prev();
            } else if (string.equals(CE_FullView.LAST)) {
                CE_FullView.this.wizPane.last();
            } else if (string.equals(CE_FullView.FIND)) {
                CE_FullView.this.wizPane.find();
            } else if (string.equals(CE_FullView.FIND_NEXT)) {
                CE_FullView.this.wizPane.findNext();
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            CE_FullView.this.config.addObserver(this);
            this.pathUpdated();
            this.currentQuestionChanged(CE_FullView.this.config.getCurrentQuestion());
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            CE_FullView.this.config.removeObserver(this);
        }

        public void pathUpdated() {
            String string;
            String string2 = string = CE_FullView.this.config.isFinishable() ? CE_FullView.this.completeMsg : CE_FullView.this.incompleteMsg;
            if (string == null || string.length() == 0) {
                CE_FullView.this.msgField.setEnabled(false);
                CE_FullView.this.msgField.setText("");
            } else {
                CE_FullView.this.msgField.setEnabled(true);
                CE_FullView.this.msgField.setText(string);
            }
        }

        public void currentQuestionChanged(Question question) {
            boolean bl = CE_FullView.this.config.isFirst(question);
            boolean bl2 = CE_FullView.this.config.isLast(question);
            CE_FullView.this.backBtn.setEnabled(!bl);
            CE_FullView.this.nextBtn.setEnabled(!bl2);
            CE_FullView.this.lastBtn.setEnabled(!bl2);
            CE_FullView.this.showInfoForQuestion(question);
        }
    }
}

