/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.help.CSH;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CE_ExecutionPane
extends CE_StdPane {
    private Parameters.ConcurrencyParameters concurrencyParameters;
    private Parameters.MutableConcurrencyParameters mutableConcurrencyParameters;
    private JLabel concurrencyLabel;
    private JTextField concurrencyField;
    private Parameters.TimeoutFactorParameters timeoutFactorParameters;
    private Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters;
    private JLabel timeoutFactorLabel;
    private JTextField timeoutFactorField;

    CE_ExecutionPane(UIFactory uIFactory, InterviewParameters interviewParameters) {
        super(uIFactory, interviewParameters, "exec");
        this.concurrencyParameters = interviewParameters.getConcurrencyParameters();
        this.mutableConcurrencyParameters = this.concurrencyParameters instanceof Parameters.MutableConcurrencyParameters ? (Parameters.MutableConcurrencyParameters)this.concurrencyParameters : null;
        this.timeoutFactorParameters = interviewParameters.getTimeoutFactorParameters();
        this.mutableTimeoutFactorParameters = this.timeoutFactorParameters instanceof Parameters.MutableTimeoutFactorParameters ? (Parameters.MutableTimeoutFactorParameters)this.timeoutFactorParameters : null;
        this.initGUI();
    }

    boolean isOKToClose() {
        Object object;
        if (this.mutableConcurrencyParameters == null && this.mutableTimeoutFactorParameters == null) {
            return true;
        }
        String string = this.concurrencyField.getText();
        if (string == null || string.length() == 0) {
            this.uif.showError("ce.exec.noConcurrency");
            return false;
        }
        Object object2 = NumberFormat.getIntegerInstance();
        Object object3 = ((NumberFormat)object2).parse(string, (ParsePosition)(object = new ParsePosition(0)));
        if (object3 != null && ((ParsePosition)object).getIndex() == string.length()) {
            int n = ((Number)object3).intValue();
            if (n < 1 || n > 50) {
                this.uif.showError("ce.exec.badRangeConcurrency", new Object[]{new Integer(1), new Integer(50)});
                return false;
            }
        } else {
            this.uif.showError("ce.exec.badConcurrency");
            return false;
        }
        object2 = this.timeoutFactorField.getText();
        if (object2 == null || ((String)object2).length() == 0) {
            this.uif.showError("ce.exec.noTimeoutFactor");
            return false;
        }
        object = NumberFormat.getNumberInstance();
        Number number = ((NumberFormat)object).parse((String)object2, (ParsePosition)(object3 = new ParsePosition(0)));
        if (number != null && ((ParsePosition)object3).getIndex() == ((String)object2).length()) {
            float f = number.floatValue();
            if (f < 0.1f || f > 100.0f) {
                this.uif.showError("ce.exec.badRangeTimeoutFactor", new Object[]{new Float(0.1f), new Float(100.0f)});
                return false;
            }
        } else {
            this.uif.showError("ce.exec.badTimeoutFactor");
            return false;
        }
        return true;
    }

    void load() {
        this.concurrencyField.setText(String.valueOf(this.config.getConcurrency()));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        this.timeoutFactorField.setText(numberFormat.format(new Double(this.config.getTimeoutFactor())));
    }

    void save() {
        if (this.mutableConcurrencyParameters != null) {
            int n = this.getInt(this.concurrencyField.getText(), 1);
            this.mutableConcurrencyParameters.setConcurrency(n);
        }
        if (this.mutableTimeoutFactorParameters != null) {
            float f = this.getFloat(this.timeoutFactorField.getText(), 1.0f);
            this.mutableTimeoutFactorParameters.setTimeoutFactor(f);
        }
    }

    private void initGUI() {
        CSH.setHelpIDString(this, "confEdit.execTab.csh");
        JPanel jPanel = this.uif.createPanel("ce.exec", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.weightx = 0.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 0;
        this.concurrencyLabel = this.uif.createLabel("ce.exec.concurrency", true);
        jPanel.add((Component)this.concurrencyLabel, gridBagConstraints);
        this.concurrencyField = this.uif.createInputField("ce.exec.concurrency", 5);
        this.concurrencyField.setEnabled(this.mutableConcurrencyParameters != null);
        this.concurrencyLabel.setLabelFor(this.concurrencyField);
        jPanel.add((Component)this.concurrencyField, gridBagConstraints2);
        this.timeoutFactorLabel = this.uif.createLabel("ce.exec.timeoutFactor", true);
        jPanel.add((Component)this.timeoutFactorLabel, gridBagConstraints);
        this.timeoutFactorField = this.uif.createInputField("ce.exec.timeoutFactor", 5);
        this.timeoutFactorField.setEnabled(this.mutableTimeoutFactorParameters != null);
        this.timeoutFactorLabel.setLabelFor(this.timeoutFactorField);
        jPanel.add((Component)this.timeoutFactorField, gridBagConstraints2);
        this.addBody(jPanel);
    }

    private int getInt(String string, int n) {
        ParsePosition parsePosition;
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        Number number = numberFormat.parse(string, parsePosition = new ParsePosition(0));
        return number != null && parsePosition.getIndex() == string.length() ? number.intValue() : n;
    }

    private float getFloat(String string, float f) {
        ParsePosition parsePosition;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = numberFormat.parse(string, parsePosition = new ParsePosition(0));
        return number != null && parsePosition.getIndex() == string.length() ? number.floatValue() : f;
    }
}

