/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvContext;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.exec.FileType;
import com.sun.javatest.tool.EditableFileList;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.help.CSH;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class CE_EnvironmentPane
extends CE_StdPane {
    private Parameters.EnvParameters envParameters;
    private Parameters.LegacyEnvParameters legacyEnvParameters;
    private TestSuite testSuite;
    private JLabel envFilesLabel;
    private EditableFileList envFilesField;
    private JFileChooser envFilesChooser;
    private JLabel envNameLabel;
    private JComboBox envNameField;

    CE_EnvironmentPane(UIFactory uIFactory, InterviewParameters interviewParameters) {
        super(uIFactory, interviewParameters, "env");
        CSH.setHelpIDString(this, "confEdit.envTab.csh");
        this.testSuite = interviewParameters.getTestSuite();
        this.envParameters = interviewParameters.getEnvParameters();
        this.legacyEnvParameters = this.envParameters instanceof Parameters.LegacyEnvParameters ? (Parameters.LegacyEnvParameters)this.envParameters : null;
        this.initGUI();
    }

    boolean isOKToClose() {
        return true;
    }

    void load() {
        if (this.legacyEnvParameters != null) {
            this.envFilesField.setItems(this.legacyEnvParameters.getEnvFiles());
            this.envNameField.setEditable(true);
            String string = this.legacyEnvParameters.getEnvName();
            if (string != null) {
                this.envNameField.setSelectedItem(string);
            }
        } else {
            String string;
            this.envFilesField.clear();
            this.envFilesField.setEnabled(false);
            this.envNameField.removeAllItems();
            TestEnvironment testEnvironment = this.envParameters.getEnv();
            String string2 = string = testEnvironment == null ? null : testEnvironment.getName();
            if (string == null) {
                string = this.uif.getI18NString("ce.env.noName");
            }
            this.envNameField.addItem(string);
            this.envNameField.setEnabled(false);
        }
    }

    void save() {
        if (this.legacyEnvParameters != null) {
            this.legacyEnvParameters.setEnvFiles(this.envFilesField.getFiles());
            if (this.envNameField.isEnabled()) {
                this.legacyEnvParameters.setEnvName((String)this.envNameField.getSelectedItem());
            }
        }
    }

    private void initGUI() {
        JPanel jPanel = this.uif.createPanel("ce.env", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.weightx = 0.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        this.envFilesLabel = this.uif.createLabel("ce.env.envFiles", true);
        jPanel.add((Component)this.envFilesLabel, gridBagConstraints);
        this.envFilesChooser = new JFileChooser();
        this.envFilesChooser.setAcceptAllFileFilterUsed(false);
        this.envFilesChooser.addChoosableFileFilter(FileType.jteFiles);
        this.envFilesChooser.setFileFilter(FileType.jteFiles);
        this.envFilesField = new EditableFileList(this.envFilesChooser){

            public Object getNewItem() {
                File file = (File)super.getNewItem();
                if (file != null) {
                    file = CE_EnvironmentPane.this.makeTestSuiteRelative(file);
                }
                return file;
            }
        };
        this.envFilesField.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                CE_EnvironmentPane.this.envFilesChanged();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                CE_EnvironmentPane.this.envFilesChanged();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                CE_EnvironmentPane.this.envFilesChanged();
            }
        });
        this.uif.setToolTip(this.envFilesField, "ce.env.envFiles");
        this.envFilesLabel.setLabelFor(this.envFilesField);
        jPanel.add((Component)this.envFilesField, gridBagConstraints2);
        this.envNameLabel = this.uif.createLabel("ce.env.envName", true);
        jPanel.add((Component)this.envNameLabel, gridBagConstraints);
        JPanel jPanel2 = this.uif.createPanel("ce.env.name", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        this.envNameField = this.uif.createChoice("ce.env.envName", this.envNameLabel);
        this.envNameField.addItem(this.uif.getI18NString("ce.env.noEnvs"));
        this.envNameField.setEditable(true);
        this.envNameField.setEnabled(false);
        this.envNameLabel.setLabelFor(this.envNameField);
        jPanel2.add((Component)this.envNameField, gridBagConstraints3);
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        this.addBody(jPanel);
        if (this.legacyEnvParameters == null) {
            this.setEnabled(false);
        }
    }

    private void envFilesChanged() {
        try {
            File file = this.testSuite.getRootDir();
            File[] fileArray = this.envFilesField.getFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (!fileArray[n].exists()) {
                    this.uif.showError("ce.env.cantFindEnvFile", fileArray[n]);
                } else if (!fileArray[n].isAbsolute()) {
                    fileArray[n] = new File(file, fileArray[n].getPath());
                }
                ++n;
            }
            TestEnvContext testEnvContext = new TestEnvContext(fileArray);
            String[] stringArray = testEnvContext.getEnvMenuNames();
            Object[] objectArray = new String[stringArray.length];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            Arrays.sort(objectArray);
            this.envNameField.removeAllItems();
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.envNameField.addItem(objectArray[n2]);
                ++n2;
            }
        }
        catch (TestEnvContext.Fault fault) {
            this.uif.showError("ce.env.cannotEvalEnvs", fault.getMessage());
        }
        if (this.envNameField.getItemCount() == 0) {
            this.envNameField.addItem(this.uif.getI18NString("ce.env.noEnvs"));
            this.envNameField.setEnabled(false);
        } else {
            this.envNameField.setEnabled(this.legacyEnvParameters != null);
        }
    }

    private File makeTestSuiteRelative(File file) {
        try {
            int n;
            if (file.isAbsolute()) {
                return file;
            }
            String string = file.getCanonicalPath();
            File file2 = this.testSuite.getRootDir();
            String string2 = file2.getCanonicalPath();
            if (string.length() > string2.length() + 1 && string.startsWith(string2) && string.charAt(string2.length()) == File.separatorChar) {
                return new File(string.substring(string2.length() + 1));
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = string2;
            while ((n = string3.lastIndexOf(File.separatorChar)) != -1) {
                string3 = string3.substring(0, n);
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(File.separator);
                }
                stringBuffer.append("..");
                if (string.length() <= string3.length() + 1 || !string.startsWith(string3) || string.charAt(string3.length()) != File.separatorChar) continue;
                File file3 = new File(stringBuffer.toString(), file.getPath());
                String string4 = new File(file2, file3.getPath()).getCanonicalPath();
                if (!string4.equals(string)) break;
                return file3;
            }
            return new File(string);
        }
        catch (IOException iOException) {
            this.uif.showError("ce.env.makeTSRelIOError", new Object[]{file, iOException});
            return null;
        }
    }
}

