/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InitialUrlFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.ConfigurableTestFilter;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.tool.TestTreeSelectionPane;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class BasicCustomTestFilter
extends ConfigurableTestFilter {
    private ObservableTestFilter.Observer[] obs = new ObservableTestFilter.Observer[0];
    private static int instanceCount;
    private TestResultTable lastTrt;
    private InterviewObserver intObs;
    private static int NUM_FILTERS;
    private SettingsSnapshot activeSettings;
    private TestFilter[] activeFilters;
    private KeywordsFilter keyFilter;
    private InitialUrlFilter urlFilter;
    private TestFilter jtxFilter;
    private StatusFilter statusFilter;
    private TestFilter tsfFilter;
    private UIFactory uif;
    private JTabbedPane editorPane;
    private ButtonGroup keyBtnGrp;
    private JRadioButton keyAllBtn;
    private JRadioButton keyMatchBtn;
    private JComboBox keywordsChoice;
    private JTextField keywordsField;
    private static final String ALL_OF = "allOf";
    private static final String ANY_OF = "anyOf";
    private static final String EXPR = "expr";
    private ButtonGroup statusBtnGrp;
    private JRadioButton statusAllBtn;
    private JRadioButton statusAnyOfBtn;
    private JCheckBox[] statusChecks = new JCheckBox[4];
    private ButtonGroup testsBtnGrp;
    private TestTreeSelectionPane testsField;
    private JCheckBox jtxCheckBox;
    private JCheckBox tsfCheckBox;
    private JTextField jtxMode;
    private JList jtxFileList;
    private DefaultListModel jtxFiles;
    private static String NAME;
    private static String REASON;
    private static String DESCRIPTION;

    BasicCustomTestFilter(String string, ExecModel execModel, UIFactory uIFactory) {
        super(string, execModel);
        this.uif = uIFactory;
        this.init(null);
    }

    BasicCustomTestFilter(Map map, ExecModel execModel, UIFactory uIFactory) {
        super(map, execModel);
        this.uif = uIFactory;
        this.init(map);
    }

    BasicCustomTestFilter(ExecModel execModel, UIFactory uIFactory) {
        super(uIFactory.getI18NString("basicTf.namePrefix"), execModel);
        this.uif = uIFactory;
        this.init(null);
    }

    ConfigurableTestFilter cloneInstance() {
        return new BasicCustomTestFilter(this.uif.getI18NString("basicTf.namePrefix") + instanceCount, this.execModel, this.uif);
    }

    public void addObserver(ObservableTestFilter.Observer observer) {
        this.obs = (ObservableTestFilter.Observer[])DynamicArray.append(this.obs, observer);
    }

    public void removeObserver(ObservableTestFilter.Observer observer) {
        this.obs = (ObservableTestFilter.Observer[])DynamicArray.remove((Object[])this.obs, observer);
    }

    protected void notifyUpdated(ObservableTestFilter observableTestFilter) {
        if (this.obs == null) {
            return;
        }
        int n = 0;
        while (n < this.obs.length) {
            this.obs[n].filterUpdated(observableTestFilter);
            ++n;
        }
    }

    boolean load(Map map) {
        boolean bl = super.load(map);
        this.activeSettings = new SettingsSnapshot(map);
        this.putSettings(this.activeSettings);
        this.activateSettings(this.activeSettings);
        this.notifyUpdated(this);
        return bl;
    }

    boolean save(Map map) {
        boolean bl = super.save(map);
        this.activeSettings.save(map);
        return bl;
    }

    synchronized JComponent getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = this.uif.createTabbedPane("basicTf.tabs", this.createTabPanels());
            this.editorPane.setTabPlacement(1);
            try {
                if (this.activeSettings == null) {
                    this.activeSettings = this.grabSettings();
                } else {
                    this.putSettings(this.activeSettings);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new IllegalStateException("Illegal state of BCTF GUI on startup.");
            }
        }
        return this.editorPane;
    }

    String commitEditorSettings() {
        SettingsSnapshot settingsSnapshot = null;
        try {
            settingsSnapshot = this.grabSettings();
        }
        catch (IllegalStateException illegalStateException) {
            return illegalStateException.getMessage();
        }
        if (!this.activeSettings.equals(settingsSnapshot)) {
            return this.activateSettings(settingsSnapshot);
        }
        return null;
    }

    void resetEditorSettings() {
        this.putSettings(this.activeSettings);
    }

    boolean isEditorChanged() {
        SettingsSnapshot settingsSnapshot = null;
        try {
            settingsSnapshot = this.grabSettings();
        }
        catch (IllegalStateException illegalStateException) {
            return true;
        }
        return !this.activeSettings.equals(settingsSnapshot);
    }

    public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
        return this.accepts(testDescription, null);
    }

    public boolean accepts(TestDescription testDescription, TestFilter.Observer observer) throws TestFilter.Fault {
        int n = 0;
        while (n < this.activeFilters.length) {
            if (this.activeFilters[n] != null && !this.activeFilters[n].accepts(testDescription)) {
                if (observer != null) {
                    observer.rejected(testDescription, this.activeFilters[n]);
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getBaseName() {
        return NAME;
    }

    public String getName() {
        return this.instanceName;
    }

    public String getReason() {
        return REASON;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    private void init(Map map) {
        if (NAME == null) {
            NAME = this.uif.getI18NString("basicTf.name");
        }
        if (REASON == null) {
            REASON = this.uif.getI18NString("basicTf.reason");
        }
        if (DESCRIPTION == null) {
            DESCRIPTION = this.uif.getI18NString("basicTf.description");
        }
        this.activeSettings = map != null ? new SettingsSnapshot(map) : new SettingsSnapshot();
        ++instanceCount;
        this.observers = null;
        this.activateSettings(this.activeSettings);
    }

    private String activateSettings(SettingsSnapshot settingsSnapshot) {
        Object object;
        KeywordsFilter keywordsFilter = null;
        InitialUrlFilter initialUrlFilter = null;
        TestFilter testFilter = null;
        StatusFilter statusFilter = null;
        TestFilter testFilter2 = null;
        InterviewParameters interviewParameters = this.execModel.getInterviewParameters();
        this.updateInterviewObserver(interviewParameters);
        if (settingsSnapshot.urlsEnabled && settingsSnapshot.initialUrls != null) {
            initialUrlFilter = new InitialUrlFilter(settingsSnapshot.initialUrls);
        }
        if (settingsSnapshot.keywordsEnabled) {
            try {
                object = Keywords.create(BasicCustomTestFilter.kwModeToType(settingsSnapshot.keyChoice), settingsSnapshot.keyString);
                keywordsFilter = new KeywordsFilter((Keywords)object);
            }
            catch (Keywords.Fault fault) {
                return fault.getMessage();
            }
        }
        if (settingsSnapshot.statusEnabled && (object = this.execModel.getActiveTestResultTable()) != null) {
            statusFilter = new StatusFilter(settingsSnapshot.statusFields, (TestResultTable)object);
        }
        if (settingsSnapshot.jtxEnabled && interviewParameters != null) {
            testFilter = interviewParameters.getExcludeListFilter();
        }
        if (settingsSnapshot.tsfEnabled) {
            object = this.execModel.getTestSuite();
            if (interviewParameters != null && object != null) {
                testFilter2 = ((TestSuite)object).createTestFilter(interviewParameters.getEnv());
            }
        }
        this.keyFilter = keywordsFilter;
        this.urlFilter = initialUrlFilter;
        this.jtxFilter = testFilter;
        this.statusFilter = statusFilter;
        this.tsfFilter = testFilter2;
        if (this.activeFilters == null) {
            this.activeFilters = new TestFilter[NUM_FILTERS];
        }
        this.activeFilters[0] = this.keyFilter;
        this.activeFilters[1] = this.urlFilter;
        this.activeFilters[2] = this.jtxFilter;
        this.activeFilters[3] = this.statusFilter;
        this.activeFilters[4] = this.tsfFilter;
        this.activeSettings = settingsSnapshot;
        this.updateExcludeInfo();
        this.notifyUpdated(this);
        return null;
    }

    private void updateInterviewObserver(InterviewParameters interviewParameters) {
        if (interviewParameters == null && this.intObs != null) {
            this.intObs.getInterview().removeObserver(this.intObs);
        } else if (this.intObs == null || this.intObs.getInterview() != interviewParameters) {
            if (this.intObs != null) {
                this.intObs.getInterview().removeObserver(this.intObs);
            }
            if (interviewParameters != null) {
                this.intObs = new InterviewObserver(interviewParameters);
                interviewParameters.addObserver(this.intObs);
            }
        }
    }

    private void updateExcludeInfo() {
        if (this.jtxMode == null) {
            return;
        }
        InterviewParameters interviewParameters = this.execModel.getInterviewParameters();
        if (interviewParameters == null) {
            return;
        }
        boolean bl = true;
        Parameters.ExcludeListParameters excludeListParameters = interviewParameters.getExcludeListParameters();
        if (interviewParameters != null && (excludeListParameters = interviewParameters.getExcludeListParameters()) instanceof Parameters.MutableExcludeListParameters) {
            Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)excludeListParameters;
            int n = mutableExcludeListParameters.getExcludeMode();
            switch (n) {
                case 1: {
                    this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.none"));
                    this.setExcludeFiles(null);
                    bl = false;
                    break;
                }
                case 2: {
                    this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.initial"));
                    this.setExcludeFiles(mutableExcludeListParameters.getExcludeFiles());
                    bl = false;
                    break;
                }
                case 3: {
                    this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.latest"));
                    this.setExcludeFiles(null);
                    bl = false;
                    break;
                }
                case 4: {
                    this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.custom"));
                    this.setExcludeFiles(mutableExcludeListParameters.getCustomExcludeFiles());
                    bl = false;
                }
            }
        }
        if (bl) {
            this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.unknown"));
            this.jtxFiles.removeAllElements();
        }
    }

    private void setExcludeFiles(File[] fileArray) {
        this.jtxFiles.removeAllElements();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            this.jtxFiles.addElement(fileArray[n].getPath());
            ++n;
        }
    }

    private JComponent[] createTabPanels() {
        JComponent[] jComponentArray = new JComponent[]{this.createTestsPanel(), this.createKeywordPanel(), this.createStatusPanel(), this.createExcludePanel(), this.createSpecialPanel()};
        return jComponentArray;
    }

    private JComponent createKeywordPanel() {
        JPanel jPanel = this.uif.createPanel("basicTf.keywords.mainPanel", new GridBagLayout(), false);
        jPanel.setName("keywords");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.keyBtnGrp = new ButtonGroup();
        this.keyAllBtn = this.uif.createRadioButton("basicTf.keywords.all", this.keyBtnGrp);
        this.keyAllBtn.setMnemonic(this.uif.getI18NString("basicTf.keywords.all.mne").charAt(0));
        jPanel.add((Component)this.keyAllBtn, gridBagConstraints);
        this.keyMatchBtn = this.uif.createRadioButton("basicTf.keywords.match", this.keyBtnGrp);
        this.keyMatchBtn.setMnemonic(this.uif.getI18NString("basicTf.keywords.match.mne").charAt(0));
        this.keyMatchBtn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BasicCustomTestFilter.this.enableKeywordFields();
            }
        });
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.keyMatchBtn, gridBagConstraints);
        String[] stringArray = new String[]{ANY_OF, ALL_OF, EXPR};
        this.keywordsChoice = this.uif.createChoice("basicTf.keywords.choice", stringArray);
        jPanel.add((Component)this.keywordsChoice, gridBagConstraints);
        this.keywordsField = this.uif.createInputField("basicTf.keywords.field", 20);
        this.keywordsField.setEditable(true);
        this.uif.setAccessibleInfo(this.keywordsField, "basicTf.keywords.field");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.keywordsField, gridBagConstraints);
        this.keyAllBtn.setSelected(true);
        this.enableKeywordFields();
        return jPanel;
    }

    private void enableKeywordFields() {
        boolean bl = this.keyMatchBtn.isSelected();
        this.keywordsChoice.setEnabled(bl);
        this.keywordsField.setEnabled(bl);
    }

    private JComponent createStatusPanel() {
        JPanel jPanel = this.uif.createPanel("basicTf.status.mainPanel", new GridBagLayout(), false);
        jPanel.setName("status");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.statusBtnGrp = new ButtonGroup();
        this.statusAllBtn = this.uif.createRadioButton("basicTf.status.all", this.statusBtnGrp);
        this.statusAllBtn.setMnemonic(this.uif.getI18NString("basicTf.status.all.mne").charAt(0));
        jPanel.add((Component)this.statusAllBtn, gridBagConstraints);
        this.statusAnyOfBtn = this.uif.createRadioButton("basicTf.status.anyOf", this.statusBtnGrp);
        this.statusAnyOfBtn.setMnemonic(this.uif.getI18NString("basicTf.status.anyOf.mne").charAt(0));
        this.statusAnyOfBtn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BasicCustomTestFilter.this.enableStatusFields();
            }
        });
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.statusAnyOfBtn, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets.left = 10;
        this.statusChecks[0] = this.uif.createCheckBox("basicTf.status.prev.passed", false);
        jPanel2.add((Component)this.statusChecks[0], gridBagConstraints2);
        this.statusChecks[1] = this.uif.createCheckBox("basicTf.status.prev.failed", true);
        jPanel2.add((Component)this.statusChecks[1], gridBagConstraints2);
        this.statusChecks[2] = this.uif.createCheckBox("basicTf.status.prev.error", true);
        jPanel2.add((Component)this.statusChecks[2], gridBagConstraints2);
        gridBagConstraints2.insets.right = 10;
        this.statusChecks[3] = this.uif.createCheckBox("basicTf.status.prev.notRun", true);
        jPanel2.add((Component)this.statusChecks[3], gridBagConstraints2);
        this.uif.setToolTip(jPanel2, "basicTf.status.prev");
        this.statusAllBtn.setSelected(true);
        this.enableStatusFields();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private void enableStatusFields() {
        boolean bl = this.statusAnyOfBtn.isEnabled() && this.statusAnyOfBtn.isSelected();
        int n = 0;
        while (n < this.statusChecks.length) {
            this.statusChecks[n].setEnabled(bl);
            ++n;
        }
    }

    private JComponent createTestsPanel() {
        final JPanel jPanel = this.uif.createPanel("basicTf.tests.mainPanel", new BorderLayout(), false);
        jPanel.setName("tests");
        this.lastTrt = this.execModel.getActiveTestResultTable();
        this.testsField = new TestTreeSelectionPane(this.lastTrt);
        jPanel.add((Component)this.testsField, "Center");
        jPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                TestResultTable testResultTable = BasicCustomTestFilter.this.execModel.getActiveTestResultTable();
                if (testResultTable != BasicCustomTestFilter.this.lastTrt) {
                    TestTreeSelectionPane testTreeSelectionPane = new TestTreeSelectionPane(testResultTable);
                    String[] stringArray = BasicCustomTestFilter.this.testsField.getSelection();
                    jPanel.remove(BasicCustomTestFilter.this.testsField);
                    BasicCustomTestFilter.this.testsField = testTreeSelectionPane;
                    BasicCustomTestFilter.this.testsField.setSelection(stringArray);
                    jPanel.add((Component)BasicCustomTestFilter.this.testsField, "Center");
                    BasicCustomTestFilter.this.lastTrt = testResultTable;
                }
            }
        });
        return jPanel;
    }

    private JComponent createExcludePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("exclude");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        this.jtxCheckBox = this.uif.createCheckBox("basicTf.exclude", false);
        this.jtxCheckBox.setMnemonic(this.uif.getI18NString("basicTf.exclude.mne").charAt(0));
        jPanel.add((Component)this.jtxCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        jPanel.add(Box.createHorizontalStrut(8), gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 2;
        JLabel jLabel = this.uif.createLabel("basicTf.exclude.mode");
        jLabel.setDisplayedMnemonic(this.uif.getI18NString("basicTf.exclude.mode.mne").charAt(0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        JLabel jLabel2 = this.uif.createLabel("basicTf.exclude.file");
        jLabel2.setDisplayedMnemonic(this.uif.getI18NString("basicTf.exclude.file.mne").charAt(0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 2;
        this.jtxMode = this.uif.createOutputField("basicTf.exclude.mode", jLabel);
        this.jtxMode.setBorder(BorderFactory.createEmptyBorder());
        this.jtxMode.setEditable(false);
        this.uif.setAccessibleInfo(this.jtxMode, "basicTf.exclude.mode");
        jPanel.add((Component)this.jtxMode, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 1;
        this.jtxFiles = new DefaultListModel();
        this.jtxFileList = this.uif.createList("basicTf.exclude.file", this.jtxFiles);
        this.uif.setAccessibleInfo(this.jtxFileList, "basicTf.exclude.file");
        jLabel2.setLabelFor(this.jtxFileList);
        jPanel.add((Component)this.uif.createScrollPane(this.jtxFileList, 20, 30), gridBagConstraints);
        return jPanel;
    }

    private JComponent createSpecialPanel() {
        String string = "basicTf.tsf";
        JPanel jPanel = this.uif.createPanel("basicTf.tsf", new BorderLayout(), false);
        jPanel.setName("special");
        this.tsfCheckBox = this.uif.createCheckBox("basicTf.tsf", false);
        this.tsfCheckBox.setMnemonic(this.uif.getI18NString("basicTf.tsf.mne").charAt(0));
        jPanel.add((Component)this.tsfCheckBox, "Center");
        return jPanel;
    }

    private SettingsSnapshot grabSettings() {
        SettingsSnapshot settingsSnapshot = new SettingsSnapshot();
        settingsSnapshot.keywordsEnabled = !this.keyAllBtn.isSelected();
        settingsSnapshot.urlsEnabled = true;
        settingsSnapshot.statusEnabled = this.statusAnyOfBtn.isSelected();
        settingsSnapshot.jtxEnabled = this.jtxCheckBox.isSelected();
        settingsSnapshot.tsfEnabled = this.tsfCheckBox.isSelected();
        boolean bl = false;
        settingsSnapshot.statusFields = new boolean[this.statusChecks.length];
        int n = 0;
        while (n < this.statusChecks.length) {
            settingsSnapshot.statusFields[n] = this.statusChecks[n].isSelected();
            bl = bl || settingsSnapshot.statusFields[n];
            ++n;
        }
        if (settingsSnapshot.statusEnabled && !bl) {
            throw new IllegalStateException(this.uif.getI18NString("basicTf.badStatus"));
        }
        settingsSnapshot.initialUrls = this.testsField.getSelection();
        if (settingsSnapshot.initialUrls != null && settingsSnapshot.initialUrls.length == 1 && settingsSnapshot.initialUrls[0].length() == 0) {
            settingsSnapshot.initialUrls = null;
        }
        settingsSnapshot.keyChoice = (String)this.keywordsChoice.getSelectedItem();
        settingsSnapshot.keyString = this.keywordsField.getText();
        return settingsSnapshot;
    }

    private void putSettings(SettingsSnapshot settingsSnapshot) {
        if (this.editorPane == null) {
            return;
        }
        this.keyAllBtn.setSelected(!settingsSnapshot.keywordsEnabled);
        this.keyMatchBtn.setSelected(settingsSnapshot.keywordsEnabled);
        this.statusAllBtn.setSelected(!settingsSnapshot.statusEnabled);
        this.statusAnyOfBtn.setSelected(settingsSnapshot.statusEnabled);
        this.jtxCheckBox.setSelected(settingsSnapshot.jtxEnabled);
        this.tsfCheckBox.setSelected(settingsSnapshot.tsfEnabled);
        int n = 0;
        while (n < this.statusChecks.length) {
            this.statusChecks[n].setSelected(settingsSnapshot.statusFields[n]);
            ++n;
        }
        this.testsField.setSelection(settingsSnapshot.initialUrls);
        this.keywordsChoice.setSelectedItem(settingsSnapshot.keyChoice);
        this.keywordsField.setText(settingsSnapshot.keyString);
        this.updateExcludeInfo();
    }

    private static String kwModeToType(String string) {
        if (string == ALL_OF) {
            return "all of";
        }
        if (string == ANY_OF) {
            return "any of";
        }
        return EXPR;
    }

    static {
        NUM_FILTERS = 5;
    }

    private class SettingsSnapshot {
        boolean urlsEnabled = true;
        boolean keywordsEnabled;
        boolean statusEnabled;
        boolean jtxEnabled;
        boolean tsfEnabled;
        boolean[] statusFields = new boolean[4];
        String[] initialUrls;
        String keyChoice = "expr";
        String keyString = "";
        private static final String MAP_URL_ENABLE = "urlsEnabled";
        private static final String MAP_KEY_ENABLE = "keyEnabled";
        private static final String MAP_STATUS_ENABLE = "statusEnable";
        private static final String MAP_JTX_ENABLE = "jtxEnable";
        private static final String MAP_TSF_ENABLE = "tsfEnable";
        private static final String MAP_URLS = "urls";
        private static final String MAP_KEY_CHOICE = "keyChoice";
        private static final String MAP_KEY_STRING = "keyString";
        private static final String MAP_STATUS_PREFIX = "status";

        SettingsSnapshot() {
        }

        SettingsSnapshot(Map map) {
            this();
            this.load(map);
        }

        public boolean equals(Object object) {
            SettingsSnapshot settingsSnapshot = (SettingsSnapshot)object;
            if (!Arrays.equals(this.initialUrls, settingsSnapshot.initialUrls)) {
                return false;
            }
            if (this.keywordsEnabled != settingsSnapshot.keywordsEnabled) {
                return false;
            }
            if (this.keyChoice != settingsSnapshot.keyChoice) {
                return false;
            }
            if (this.keyString == null ? this.keyString != settingsSnapshot.keyString : !this.keyString.equals(settingsSnapshot.keyString)) {
                return false;
            }
            if (this.statusEnabled != settingsSnapshot.statusEnabled) {
                return false;
            }
            if (!Arrays.equals(this.statusFields, settingsSnapshot.statusFields)) {
                return false;
            }
            if (this.jtxEnabled != settingsSnapshot.jtxEnabled) {
                return false;
            }
            return this.tsfEnabled == settingsSnapshot.tsfEnabled;
        }

        void save(Map map) {
            map.put(MAP_URL_ENABLE, this.booleanToInt(this.urlsEnabled));
            map.put(MAP_KEY_ENABLE, this.booleanToInt(this.keywordsEnabled));
            map.put(MAP_STATUS_ENABLE, this.booleanToInt(this.statusEnabled));
            map.put(MAP_JTX_ENABLE, this.booleanToInt(this.jtxEnabled));
            map.put(MAP_TSF_ENABLE, this.booleanToInt(this.tsfEnabled));
            int n = 0;
            while (n < this.statusFields.length) {
                map.put(MAP_STATUS_PREFIX + n, this.booleanToInt(this.statusFields[n]));
                ++n;
            }
            map.put(MAP_URLS, StringArray.join(this.initialUrls));
            map.put(MAP_KEY_CHOICE, this.keyChoice);
            map.put(MAP_KEY_STRING, this.keyString);
        }

        void load(Map map) {
            this.urlsEnabled = this.intToBoolean((String)map.get(MAP_URL_ENABLE));
            this.keywordsEnabled = this.intToBoolean((String)map.get(MAP_KEY_ENABLE));
            this.statusEnabled = this.intToBoolean((String)map.get(MAP_STATUS_ENABLE));
            this.jtxEnabled = this.intToBoolean((String)map.get(MAP_JTX_ENABLE));
            this.tsfEnabled = this.intToBoolean((String)map.get(MAP_TSF_ENABLE));
            int n = 0;
            while (n < 4) {
                this.statusFields[n] = this.intToBoolean((String)map.get(MAP_STATUS_PREFIX + n));
                ++n;
            }
            this.initialUrls = StringArray.split((String)map.get(MAP_URLS));
            this.keyChoice = (String)map.get(MAP_KEY_CHOICE);
            this.keyString = (String)map.get(MAP_KEY_STRING);
            this.validate();
        }

        private void validate() {
            this.keyChoice = this.keyChoice.equals(BasicCustomTestFilter.ALL_OF) ? BasicCustomTestFilter.ALL_OF : (this.keyChoice.equals(BasicCustomTestFilter.ANY_OF) ? BasicCustomTestFilter.ANY_OF : (this.keyChoice.equals(BasicCustomTestFilter.EXPR) ? BasicCustomTestFilter.EXPR : BasicCustomTestFilter.ALL_OF));
        }

        String booleanToInt(boolean bl) {
            if (bl) {
                return "1";
            }
            return "0";
        }

        boolean intToBoolean(String string) {
            if (string == null) {
                return false;
            }
            return string.equals("1");
        }
    }

    private class InterviewObserver
    implements Interview.Observer {
        private InterviewParameters interview;

        InterviewObserver(InterviewParameters interviewParameters) {
            this.interview = interviewParameters;
        }

        InterviewParameters getInterview() {
            return this.interview;
        }

        public void currentQuestionChanged(Question question) {
        }

        public void pathUpdated() {
            TestFilter testFilter;
            InterviewParameters interviewParameters;
            boolean bl = false;
            BasicCustomTestFilter.this.updateExcludeInfo();
            if (((BasicCustomTestFilter)BasicCustomTestFilter.this).activeSettings.jtxEnabled && (interviewParameters = BasicCustomTestFilter.this.execModel.getInterviewParameters()) != null) {
                testFilter = interviewParameters.getExcludeListFilter();
                if (!(testFilter == null || BasicCustomTestFilter.this.jtxFilter != null && testFilter.equals(BasicCustomTestFilter.this.jtxFilter))) {
                    bl = true;
                } else if (BasicCustomTestFilter.this.jtxFilter != null) {
                    bl = true;
                }
            }
            if (bl) {
                BasicCustomTestFilter.this.activateSettings(BasicCustomTestFilter.this.activeSettings);
                return;
            }
            if (((BasicCustomTestFilter)BasicCustomTestFilter.this).activeSettings.tsfEnabled) {
                interviewParameters = BasicCustomTestFilter.this.execModel.getInterviewParameters();
                TestSuite testSuite = BasicCustomTestFilter.this.execModel.getTestSuite();
                if (interviewParameters != null && testSuite != null) {
                    testFilter = testSuite.createTestFilter(interviewParameters.getEnv());
                    if (testFilter != null) {
                        if (BasicCustomTestFilter.this.tsfFilter == null || !testFilter.equals(BasicCustomTestFilter.this.tsfFilter)) {
                            bl = true;
                        }
                    } else if (BasicCustomTestFilter.this.tsfFilter != null) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                BasicCustomTestFilter.this.activateSettings(BasicCustomTestFilter.this.activeSettings);
                return;
            }
        }
    }
}

