/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.cof.COFEnvironment;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFTestSuite;
import com.sun.javatest.util.XMLWriter;
import java.io.IOException;
import java.util.Vector;

class Report
extends COFItem {
    private long date = System.currentTimeMillis();
    private Vector environments = new Vector();
    private Vector testSuites = new Vector();
    private static final String COF_SCHEMA = "http://vesta.sfbay.sun.com/projects/COF/2002/1_0/Schema";

    Report() {
    }

    Report(COFEnvironment cOFEnvironment, COFTestSuite cOFTestSuite) {
        this.environments.add(cOFEnvironment);
        this.testSuites.add(cOFTestSuite);
    }

    void addEnvironment(COFEnvironment cOFEnvironment) {
        this.environments.add(cOFEnvironment);
    }

    void addTestSuite(COFTestSuite cOFTestSuite) {
        this.testSuites.add(cOFTestSuite);
    }

    void write(XMLWriter xMLWriter) throws IOException {
        xMLWriter.startTag("cof:report");
        xMLWriter.writeAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xMLWriter.writeAttr("xmlns:cof", COF_SCHEMA);
        xMLWriter.writeAttr("xsi:schemaLocation", "http://vesta.sfbay.sun.com/projects/COF/2002/1_0/Schema COF1_0.xsd");
        xMLWriter.writeDate("date", this.date);
        xMLWriter.startTag("version");
        xMLWriter.write("1.0");
        xMLWriter.endTag("version");
        xMLWriter.startTag("environments");
        int n = 0;
        while (n < this.environments.size()) {
            COFEnvironment cOFEnvironment = (COFEnvironment)this.environments.elementAt(n);
            cOFEnvironment.write(xMLWriter);
            ++n;
        }
        xMLWriter.endTag("environments");
        xMLWriter.startTag("testsuites");
        int n2 = 0;
        while (n2 < this.testSuites.size()) {
            COFTestSuite cOFTestSuite = (COFTestSuite)this.testSuites.elementAt(n2);
            cOFTestSuite.write(xMLWriter);
            ++n2;
        }
        xMLWriter.endTag("testsuites");
        xMLWriter.endTag("cof:report");
    }
}

