/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.WorkDirectory;
import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFEnvironment;
import com.sun.javatest.cof.COFTestSuite;
import com.sun.javatest.cof.Report;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.XMLWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class Main {
    private static final String COF_SCHEMA = "COF1_0.xsd";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$cof$Main == null ? (class$com$sun$javatest$cof$Main = Main.class$("com.sun.javatest.cof.Main")) : class$com$sun$javatest$cof$Main);
    static /* synthetic */ Class class$com$sun$javatest$cof$Main;

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.err);
        try {
            Main main = new Main();
            main.run(stringArray, printWriter);
            printWriter.flush();
            Main.exit(0);
        }
        catch (BadArgs badArgs) {
            printWriter.println(badArgs.getMessage());
            printWriter.flush();
            Main.exit(1);
        }
        catch (Fault fault) {
            printWriter.println(fault.getMessage());
            printWriter.flush();
            Main.exit(2);
        }
    }

    void run(String[] stringArray, PrintWriter printWriter) throws BadArgs, Fault {
        Object object;
        COFTestSuite cOFTestSuite;
        COFEnvironment cOFEnvironment;
        Object object2;
        COFData cOFData;
        boolean bl = false;
        boolean bl2 = false;
        File file = null;
        File file2 = null;
        Vector<Object> vector = new Vector<Object>();
        if (stringArray.length == 0) {
            bl = true;
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-o") && n + 1 < stringArray.length) {
                    file = new File(stringArray[++n]);
                } else if (stringArray[n].equals("-f") && n + 1 < stringArray.length) {
                    vector.add(new File(stringArray[++n]));
                } else if (stringArray[n].equalsIgnoreCase("-help") || stringArray[n].equalsIgnoreCase("-usage") || stringArray[n].equalsIgnoreCase("/?")) {
                    bl = true;
                } else if (stringArray[n].equalsIgnoreCase("-xsd")) {
                    bl2 = true;
                } else {
                    if (stringArray[n].startsWith("-")) {
                        throw new BadArgs(i18n, "main.badOpt", stringArray[n]);
                    }
                    if (stringArray[n].indexOf("=") != -1) {
                        vector.add(stringArray[n]);
                    } else if (n == stringArray.length - 1) {
                        file2 = new File(stringArray[n]);
                    } else {
                        throw new BadArgs(i18n, "main.badArg", stringArray[n]);
                    }
                }
                ++n;
            }
        }
        if (bl) {
            Main.showCommandLineHelp(printWriter);
            if (file2 == null && file == null) {
                return;
            }
        }
        if (file == null) {
            throw new BadArgs(i18n, "main.noOutputFile");
        }
        if (file2 == null) {
            throw new BadArgs(i18n, "main.noResults");
        }
        if (!file2.exists()) {
            throw new BadArgs(i18n, "main.cantFindResults");
        }
        try {
            cOFData = new COFData(vector);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault(i18n, "main.badOpt", illegalArgumentException.toString());
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantReadFile", iOException);
        }
        if (WorkDirectory.isWorkDirectory(file2)) {
            try {
                object2 = WorkDirectory.open(file2);
                cOFEnvironment = new COFEnvironment(cOFData);
                cOFTestSuite = new COFTestSuite((WorkDirectory)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Fault(i18n, "main.cantFindWorkDir", file2);
            }
            catch (WorkDirectory.Fault fault) {
                throw new Fault(i18n, "main.cantOpenWorkDir", new Object[]{file2, fault});
            }
        } else {
            cOFEnvironment = new COFEnvironment(cOFData);
            cOFTestSuite = new COFTestSuite(file2, cOFData);
        }
        try {
            object2 = new Report(cOFEnvironment, cOFTestSuite);
            object = new XMLWriter(new FileWriter(file));
            ((Report)object2).write((XMLWriter)object);
            ((XMLWriter)object).close();
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantWriteFile", new Object[]{file, iOException});
        }
        if (bl2) {
            object2 = new File(file.getAbsoluteFile().getParent(), COF_SCHEMA);
            try {
                int n;
                object = new BufferedInputStream(this.getClass().getResourceAsStream(COF_SCHEMA));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object2));
                byte[] byArray = new byte[4096];
                while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                ((InputStream)object).close();
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantWriteFile", new Object[]{object2, iOException});
            }
        }
    }

    private static void showCommandLineHelp(PrintWriter printWriter) {
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$cof$Main == null ? (class$com$sun$javatest$cof$Main = Main.class$("com.sun.javatest.cof.Main")) : class$com$sun$javatest$cof$Main).getName());
        printWriter.println(i18n.getString("main.cmdLine.proto", string));
        printWriter.println();
        printWriter.println(i18n.getString("main.cmdLine.optHead"));
        printWriter.println(i18n.getString("main.cmdLine.file"));
        printWriter.println(i18n.getString("main.cmdLine.help"));
        printWriter.println(i18n.getString("main.cmdLine.out"));
        printWriter.println(i18n.getString("main.cmdLine.xsd"));
        printWriter.println(i18n.getString("main.cmdLine.data"));
        printWriter.println();
        printWriter.println(i18n.getString("main.cmdLine.filesHead"));
        printWriter.println(i18n.getString("main.cmdLine.dir"));
        printWriter.println();
        printWriter.println(i18n.getString("main.copyright.txt"));
    }

    private static void exit(int n) {
        System.exit(n);
        throw new Error();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        BadArgs(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        BadArgs(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

