/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.util.XMLWriter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

class COFTestSuite
extends COFItem {
    private String name;
    private TestResultTable trt;
    private int testIndex = 0;
    private static final Date badDate = new Date(0L);
    private static DateFormat[] dateFormats;
    private static final String[] cofStatus;

    COFTestSuite(TestResultTable testResultTable) {
        this.trt = testResultTable;
    }

    COFTestSuite(WorkDirectory workDirectory) {
        TestSuite testSuite = workDirectory.getTestSuite();
        this.name = testSuite.getID();
        this.trt = workDirectory.getTestResultTable();
    }

    COFTestSuite(File file) {
        this.trt = new TestResultTable();
        this.scan(file);
    }

    COFTestSuite(File file, COFData cOFData) {
        this.trt = new TestResultTable();
        this.name = cOFData.get("testsuites.testsuite.name");
        this.scan(file);
    }

    void scan(File file) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (file2.isDirectory()) {
                    this.scan(file2);
                } else if (TestResult.isResultFile(file2)) {
                    try {
                        TestResult testResult = new TestResult(file2);
                        this.trt.update(testResult);
                    }
                    catch (TestResult.Fault fault) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }

    void write(XMLWriter xMLWriter) throws IOException {
        if (dateFormats == null) {
            this.initDateFormats();
        }
        xMLWriter.startTag("testsuite");
        xMLWriter.writeAttr("id", "unknownTestSuite:0");
        xMLWriter.startTag("name");
        xMLWriter.write(this.name == null ? "unknown" : this.name);
        xMLWriter.endTag("name");
        xMLWriter.startTag("tests");
        TestResultTable.TreeIterator treeIterator = this.trt.getIterator();
        while (treeIterator.hasNext()) {
            TestResult testResult = (TestResult)treeIterator.next();
            xMLWriter.newLine();
            xMLWriter.startTag("test");
            xMLWriter.writeAttr("id", "test:" + this.testIndex++);
            xMLWriter.startTag("name");
            xMLWriter.write(testResult.getTestName());
            xMLWriter.endTag("name");
            xMLWriter.startTag("status");
            xMLWriter.writeAttr("value", cofStatus[testResult.getStatus().getType()]);
            String string = testResult.getStatus().getReason();
            if (string != null && string.length() > 0) {
                xMLWriter.startTag("actual");
                xMLWriter.write(string);
                xMLWriter.endTag("actual");
            }
            xMLWriter.endTag("status");
            xMLWriter.writeDate("starttime", this.parseDate(testResult, "start"));
            xMLWriter.writeDate("endtime", this.parseDate(testResult, "end"));
            xMLWriter.endTag("test");
        }
        xMLWriter.endTag("tests");
        xMLWriter.endTag("testsuite");
    }

    private Date parseDate(TestResult testResult, String string) {
        try {
            String string2 = testResult.getProperty(string);
            if (string2 != null && string2.length() > 0) {
                return this.parseDate(string2);
            }
        }
        catch (TestResult.Fault fault) {
            System.err.println(fault);
        }
        return badDate;
    }

    private Date parseDate(String string) {
        int n = 0;
        while (n < dateFormats.length) {
            try {
                Date date = dateFormats[n].parse(string);
                if (n > 0) {
                    DateFormat dateFormat = dateFormats[n];
                    System.arraycopy(dateFormats, 0, dateFormats, 1, n);
                    COFTestSuite.dateFormats[0] = dateFormat;
                }
                return date;
            }
            catch (ParseException parseException) {
                ++n;
            }
        }
        return badDate;
    }

    private void initDateFormats() {
        Vector<DateFormat> vector = new Vector<DateFormat>();
        vector.addElement(DateFormat.getDateTimeInstance());
        vector.addElement(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz"));
        vector.addElement(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"));
        vector.addElement(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS"));
        String string = System.getProperty("javatest.date.format");
        if (string != null) {
            vector.addElement(new SimpleDateFormat(string));
        }
        dateFormats = new DateFormat[vector.size()];
        vector.copyInto(dateFormats);
    }

    static {
        cofStatus = new String[4];
        COFTestSuite.cofStatus[0] = "pass";
        COFTestSuite.cofStatus[1] = "fail";
        COFTestSuite.cofStatus[2] = "error";
        COFTestSuite.cofStatus[3] = "did_not_run";
    }
}

