/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.util.XMLWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class COFEnvironment
extends COFItem {
    private String hostName;
    private String domainName;
    private String machineName;
    private String osName;
    private String osVersion;
    private String jdkName;

    public static void main(String[] stringArray) {
        COFEnvironment cOFEnvironment = new COFEnvironment();
        System.err.println("osName: " + cOFEnvironment.osName);
        System.err.println("osVersion: " + cOFEnvironment.osVersion);
    }

    COFEnvironment() {
        this.initDefaultHostInfo();
        this.initDefaultOSInfo();
    }

    COFEnvironment(COFData cOFData) {
        this();
        this.hostName = cOFData.get("environment.host", this.hostName);
        this.domainName = cOFData.get("environment.domain", this.domainName);
        this.machineName = cOFData.get("environment.machine", this.hostName + "." + this.domainName);
        this.osName = cOFData.get("environment.os.name", this.osName);
        this.osVersion = cOFData.get("environment.os.version", this.osVersion);
        this.jdkName = cOFData.get("environment.jdk", this.jdkName);
    }

    void write(XMLWriter xMLWriter) throws IOException {
        xMLWriter.startTag("environment");
        xMLWriter.writeAttr("id", "unknownEnv:0");
        xMLWriter.startTag("machine");
        xMLWriter.write(this.machineName);
        xMLWriter.endTag("machine");
        xMLWriter.startTag("os");
        xMLWriter.startTag("name");
        xMLWriter.write(this.osName);
        xMLWriter.endTag("name");
        xMLWriter.startTag("version");
        xMLWriter.write(this.osVersion);
        xMLWriter.endTag("version");
        xMLWriter.endTag("os");
        if (this.jdkName != null) {
            xMLWriter.startTag("jdk");
            xMLWriter.write(this.jdkName);
            xMLWriter.endTag("jdk");
        }
        xMLWriter.endTag("environment");
    }

    private void initDefaultHostInfo() {
        this.domainName = "unknown";
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.hostName = "unknown";
        }
    }

    private void initDefaultOSInfo() {
        this.osName = System.getProperty("os.name").toLowerCase();
        this.osVersion = System.getProperty("os.version");
        if (this.osName.equals("sunos") || this.osName.equals("solaris")) {
            this.osName = "solaris";
            if (this.osVersion.equals("5.6")) {
                this.osVersion = "2.6";
            } else if (this.osVersion.equals("5.7")) {
                this.osVersion = "2.7";
            } else if (this.osVersion.equals("5.8")) {
                this.osVersion = "8";
            } else if (this.osVersion.equals("5.9")) {
                this.osVersion = "9";
            }
        } else if (this.osName.startsWith("windows")) {
            this.osName = "windows";
            if (this.osName.indexOf("95") != -1) {
                this.osVersion = "95";
            } else if (this.osName.indexOf("98") != -1) {
                this.osVersion = "98";
            } else if (this.osName.indexOf("2000") != -1) {
                this.osVersion = "2000";
            } else if (this.osName.indexOf("me") != -1) {
                this.osVersion = "me";
            } else if (this.osName.indexOf("nt") != -1) {
                this.osVersion = "nt_4.0";
            } else if (this.osName.indexOf("xp") != -1) {
                this.osVersion = "xp";
            }
        } else if (this.osName.equals("linux")) {
            if (new File("/etc/turbolinux-release").exists()) {
                this.osName = "turbo_linux";
                this.osVersion = this.getGenericLinuxVersionInfo("/etc/turbolinux-release");
            } else if (new File("/etc/SuSE-release").exists()) {
                this.osName = "suse_linux";
                this.osVersion = this.getGenericLinuxVersionInfo("/etc/SuSE-release");
            } else if (new File("/etc/mandrake-release").exists()) {
                this.osName = "mandrake_linux";
                this.osVersion = this.getGenericLinuxVersionInfo("/etc/mandrake-release");
            } else if (new File("/etc/redhat-release").exists()) {
                this.osName = "redhat_linux";
                this.osVersion = this.getGenericLinuxVersionInfo("/etc/redhat-release");
            } else if (new File("/etc/lst.cnf").exists()) {
                this.osName = "caldera_linux";
                this.osVersion = this.getCalderaLinuxVersionInfo();
            } else {
                this.osName = "unknown_linux";
                this.osVersion = "N/A";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCalderaLinuxVersionInfo() {
        String string;
        String string2 = "N/A";
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = new RandomAccessFile("/etc/issue", "r");
        while ((string = randomAccessFile.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() < 2 || !stringTokenizer.nextToken().toUpperCase().equals("VERSION")) continue;
            string2 = stringTokenizer.nextToken();
            break;
        }
        Object var6_6 = null;
        if (randomAccessFile == null) return string2;
        try {
            randomAccessFile.close();
            return string2;
        }
        catch (Exception exception) {}
        return string2;
        {
            catch (Exception exception) {
                Object var6_7 = null;
                if (randomAccessFile == null) return string2;
                try {
                    randomAccessFile.close();
                    return string2;
                }
                catch (Exception exception2) {}
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (randomAccessFile == null) throw throwable;
            try {
                randomAccessFile.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getGenericLinuxVersionInfo(String string) {
        String string2 = "N/A";
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = new RandomAccessFile(string, "r");
        StringTokenizer stringTokenizer = new StringTokenizer(randomAccessFile.readLine(), " ");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (!Character.isDigit(string3.charAt(0))) continue;
            string2 = string3;
            break;
        }
        Object var7_7 = null;
        if (randomAccessFile == null) return string2;
        try {
            randomAccessFile.close();
            return string2;
        }
        catch (Exception exception) {}
        return string2;
        {
            catch (Exception exception) {
                Object var7_8 = null;
                if (randomAccessFile == null) return string2;
                try {
                    randomAccessFile.close();
                    return string2;
                }
                catch (Exception exception2) {}
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (randomAccessFile == null) throw throwable;
            try {
                randomAccessFile.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

