/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import com.sun.javatest.report.Report;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;

class WriteReportCommand
extends Command {
    private File path;
    private boolean createFlag;

    WriteReportCommand() {
    }

    WriteReportCommand(File file) {
        this.path = file;
    }

    String getName() {
        return "writeReport";
    }

    int init(String[] stringArray, int n) throws Fault {
        int n2 = n;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equals("-create")) {
                if (stringArray[n2].startsWith("-")) {
                    throw new Fault((ResourceBundle)Command.i18n, "writeReport.badArg", stringArray[n2]);
                }
                this.path = new File(stringArray[n2]);
                return n2 - n + 1;
            }
            this.createFlag = true;
            ++n2;
        }
        throw new Fault(Command.i18n, "writeReport.missingArg");
    }

    void run(BatchModel batchModel) throws Fault {
        batchModel.disableAutoRun();
        if (this.path.exists()) {
            if (!this.path.isDirectory()) {
                throw new Fault((ResourceBundle)Command.i18n, "writeReport.notADir", this.path);
            }
        } else {
            if (this.createFlag) {
                this.path.mkdirs();
            } else {
                this.path.mkdir();
            }
            if (!this.path.exists()) {
                throw new Fault((ResourceBundle)Command.i18n, "writeReport.cantCreate", this.path);
            }
        }
        InterviewParameters interviewParameters = batchModel.getInterviewParameters();
        try {
            File file;
            Report report = new Report(interviewParameters, this.path, new CompositeFilter(interviewParameters.getFilters()));
            report.writeReport();
            try {
                file = this.path.getCanonicalFile();
            }
            catch (IOException iOException) {
                file = this.path;
            }
            batchModel.printMessage(Command.i18n, "writeReport.done", file);
        }
        catch (IOException iOException) {
            batchModel.printMessage(Command.i18n, "writeReport.error", new Object[]{this.path, iOException});
        }
    }
}

