/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import java.io.File;
import java.util.ResourceBundle;

class WorkDirectoryCommand
extends Command {
    private File path;
    private boolean createFlag;
    private boolean overwriteFlag;

    WorkDirectoryCommand() {
    }

    WorkDirectoryCommand(File file) {
        this.path = file;
    }

    String getName() {
        return "workDirectory";
    }

    int init(String[] stringArray, int n) throws Fault {
        if (n >= stringArray.length) {
            throw new Fault(Command.i18n, "workDir.missingArg");
        }
        int n2 = n;
        n2 = n;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-create")) {
                this.createFlag = true;
            } else if (stringArray[n2].equalsIgnoreCase("-overwrite")) {
                this.createFlag = true;
                this.overwriteFlag = true;
            } else {
                if (stringArray[n2].startsWith("-")) {
                    throw new Fault((ResourceBundle)Command.i18n, "workDir.badArg", stringArray[n2]);
                }
                this.path = new File(stringArray[n2]);
                return n2 - n + 1;
            }
            ++n2;
        }
        throw new Fault(Command.i18n, "workDir.missingArg");
    }

    void run(BatchModel batchModel) throws Fault {
        if (this.createFlag) {
            batchModel.createWorkDirectory(this.path, this.overwriteFlag);
        } else {
            batchModel.openWorkDirectory(this.path);
        }
    }
}

