/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ResourceBundle;

class TimeoutFactorCommand
extends Command {
    private float arg;

    TimeoutFactorCommand() {
    }

    String getName() {
        return "timeoutFactor";
    }

    int init(String[] stringArray, int n) throws Fault {
        ParsePosition parsePosition;
        if (n >= stringArray.length) {
            throw new Fault(Command.i18n, "timeout.missingArg");
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = numberFormat.parse(stringArray[n], parsePosition = new ParsePosition(0));
        if (number != null && parsePosition.getIndex() == stringArray[n].length()) {
            this.arg = number.floatValue();
            if (this.arg < 0.1f || this.arg > 100.0f) {
                throw new Fault((ResourceBundle)Command.i18n, "timeout.badRange", new Object[]{stringArray[n], new Float(0.1f), new Float(100.0f)});
            }
            return 1;
        }
        throw new Fault((ResourceBundle)Command.i18n, "timeout.badValue", stringArray[n]);
    }

    void run(BatchModel batchModel) throws Fault {
        InterviewParameters interviewParameters = batchModel.getInterviewParameters();
        if (!(interviewParameters.getTimeoutFactorParameters() instanceof Parameters.MutableTimeoutFactorParameters)) {
            throw new Fault(Command.i18n, "timeout.notEditable");
        }
        Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters = (Parameters.MutableTimeoutFactorParameters)interviewParameters.getTimeoutFactorParameters();
        mutableTimeoutFactorParameters.setTimeoutFactor(this.arg);
    }
}

