/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import java.util.ResourceBundle;

class SetCommand
extends Command {
    private String tag;
    private String value;

    SetCommand() {
    }

    String getName() {
        return "set";
    }

    int init(String[] stringArray, int n) throws Fault {
        if (n + 2 > stringArray.length) {
            throw new Fault(Command.i18n, "set.insufficientArgs");
        }
        this.tag = stringArray[n];
        this.value = stringArray[n + 1];
        return 2;
    }

    void run(BatchModel batchModel) throws Fault {
        InterviewParameters interviewParameters = batchModel.getInterviewParameters();
        Question[] questionArray = interviewParameters.getPath();
        int n = 0;
        while (n < questionArray.length) {
            Question question = questionArray[n];
            if (question.getTag().equals(this.tag)) {
                try {
                    question.setValue(this.value);
                    return;
                }
                catch (Interview.Fault fault) {
                    throw new Fault((ResourceBundle)Command.i18n, "set.cantSetValue", new Object[]{this.tag, this.value, fault.getMessage()});
                }
            }
            ++n;
        }
        throw new Fault((ResourceBundle)Command.i18n, "set.tagNotFound", this.tag);
    }
}

