/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import java.util.ResourceBundle;

class RunTestsCommand
extends Command {
    private BatchModel model;

    RunTestsCommand() {
    }

    String getName() {
        return "runtests";
    }

    int init(String[] stringArray, int n) throws Fault {
        return 0;
    }

    void run(BatchModel batchModel) throws Fault {
        this.model = batchModel;
        batchModel.disableAutoRun();
        try {
            InterviewParameters interviewParameters = batchModel.getInterviewParameters();
            Harness harness = new Harness();
            Harness.Observer[] observerArray = batchModel.getHarnessObservers();
            int n = 0;
            while (n < observerArray.length) {
                harness.addObserver(observerArray[n]);
                ++n;
            }
            BatchObserver batchObserver = new BatchObserver();
            harness.addObserver(batchObserver);
            interviewParameters.getTestSuite().getTestFinder().setErrorHandler(batchObserver);
            boolean bl = harness.batch(interviewParameters);
            if (batchObserver.getFinderErrorCount() > 0) {
                batchModel.printErrorMessage(Command.i18n, "runTests.warnError");
            }
            this.showResultStats(batchObserver.getStats());
            int n2 = harness.getTestsFoundCount();
            if (n2 > 0) {
                batchModel.printMessage(Command.i18n, "runTests.resultsDone", interviewParameters.getWorkDirectory().getPath());
            }
            if (!bl && n2 > 0 && n2 != batchObserver.getStats()[0]) {
                batchModel.printErrorMessage(Command.i18n, "runTests.testsFailed");
            }
        }
        catch (Harness.Fault fault) {
            throw new Fault((ResourceBundle)Command.i18n, "runTests.harnessError", fault.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new Fault(Command.i18n, "runTests.interrupted");
        }
    }

    private void showResultStats(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        if (n + n2 + n3 + n4 == 0) {
            this.model.printMessage(Command.i18n, "runTests.noTests");
        } else {
            this.model.printMessage(Command.i18n, "runTests.tests", new Object[]{new Integer(n), new Integer(n > 0 && n2 + n3 + n4 > 0 ? 1 : 0), new Integer(n2), new Integer(n2 > 0 && n3 + n4 > 0 ? 1 : 0), new Integer(n3), new Integer(n3 > 0 && n4 > 0 ? 1 : 0), new Integer(n4)});
        }
    }

    private class BatchObserver
    implements Harness.Observer,
    TestFinder.ErrorHandler {
        private int[] stats;
        private int finderErrors;

        private BatchObserver() {
        }

        int[] getStats() {
            return this.stats;
        }

        int getFinderErrorCount() {
            return this.finderErrors;
        }

        public void startingTestRun(Parameters parameters) {
            this.stats = new int[4];
        }

        public void startingTest(TestResult testResult) {
        }

        public void finishedTest(TestResult testResult) {
            int n = testResult.getStatus().getType();
            this.stats[n] = this.stats[n] + 1;
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
        }

        public void error(String string) {
            RunTestsCommand.this.model.printMessage(Command.i18n, "runTests.error", string);
            ++this.finderErrors;
        }
    }
}

