/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.FileParameters;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import java.io.File;
import java.util.ResourceBundle;

class OpenCommand
extends Command {
    static final int TEST_SUITE = 1;
    static final int WORK_DIRECTORY = 2;
    static final int PARAMETER_FILE = 3;
    static final int INTERVIEW_FILE = 4;
    private int fileType;
    private File file;

    OpenCommand() {
    }

    OpenCommand(int n, File file) {
        this.fileType = n;
        this.file = file;
    }

    String getName() {
        return "open";
    }

    int init(String[] stringArray, int n) throws Fault {
        if (n == stringArray.length) {
            throw new Fault(Command.i18n, "open.missingArg");
        }
        this.file = new File(stringArray[n]);
        if (!this.file.exists()) {
            throw new Fault((ResourceBundle)Command.i18n, "open.cantFindFile", this.file);
        }
        if (TestSuite.isTestSuite(this.file)) {
            this.fileType = 1;
            return 1;
        }
        if (WorkDirectory.isWorkDirectory(this.file)) {
            this.fileType = 2;
            return 1;
        }
        if (FileParameters.isParameterFile(this.file)) {
            this.fileType = 3;
            return 1;
        }
        if (InterviewParameters.isInterviewFile(this.file)) {
            this.fileType = 4;
            return 1;
        }
        if (this.file.getPath().endsWith(".jte")) {
            throw new Fault((ResourceBundle)Command.i18n, "open.cantOpenJTE", this.file);
        }
        if (this.file.getPath().endsWith(".jtt")) {
            throw new Fault((ResourceBundle)Command.i18n, "open.cantOpenJTT", this.file);
        }
        if (this.file.getPath().endsWith(".jtx")) {
            throw new Fault((ResourceBundle)Command.i18n, "open.cantOpenJTX", this.file);
        }
        throw new Fault((ResourceBundle)Command.i18n, "open.unknownFileType", this.file);
    }

    void run(BatchModel batchModel) throws Fault {
        switch (this.fileType) {
            case 1: {
                batchModel.openTestSuite(this.file);
                return;
            }
            case 2: {
                batchModel.openWorkDirectory(this.file);
                return;
            }
            case 3: {
                batchModel.openParameterFile(this.file);
                return;
            }
            case 4: {
                batchModel.openInterviewFile(this.file);
                return;
            }
        }
        throw new IllegalStateException();
    }
}

