/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import java.io.File;
import java.util.Vector;

class EnvFilesCommand
extends Command {
    private File[] files;

    EnvFilesCommand() {
    }

    String getName() {
        return "envFile";
    }

    int init(String[] stringArray, int n) throws Fault {
        Vector<File> vector = new Vector<File>();
        int n2 = n;
        while (n2 < stringArray.length && !stringArray[n2].startsWith("-")) {
            vector.add(new File(stringArray[n2]));
            ++n2;
        }
        if (vector.size() == 0) {
            throw new Fault(Command.i18n, "envFiles.noFiles");
        }
        this.files = new File[vector.size()];
        vector.toArray(this.files);
        return n2 - n;
    }

    void run(BatchModel batchModel) throws Fault {
        InterviewParameters interviewParameters = batchModel.getInterviewParameters();
        if (!(interviewParameters.getEnvParameters() instanceof Parameters.LegacyEnvParameters)) {
            throw new Fault(Command.i18n, "envFiles.notEditable");
        }
        Parameters.LegacyEnvParameters legacyEnvParameters = (Parameters.LegacyEnvParameters)interviewParameters.getEnvParameters();
        legacyEnvParameters.setEnvFiles(this.files);
    }
}

