/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ResourceBundle;

class ConcurrencyCommand
extends Command {
    private int arg;

    ConcurrencyCommand() {
    }

    String getName() {
        return "concurrency";
    }

    int init(String[] stringArray, int n) throws Fault {
        ParsePosition parsePosition;
        if (n >= stringArray.length) {
            throw new Fault(Command.i18n, "conc.missingArg");
        }
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        Number number = numberFormat.parse(stringArray[n], parsePosition = new ParsePosition(0));
        if (number != null && parsePosition.getIndex() == stringArray[n].length()) {
            this.arg = number.intValue();
            if (this.arg < 1 || this.arg > 50) {
                throw new Fault((ResourceBundle)Command.i18n, "conc.badRange", new Object[]{stringArray[n], new Integer(1), new Integer(50)});
            }
            return 1;
        }
        throw new Fault((ResourceBundle)Command.i18n, "conc.badValue", stringArray[n]);
    }

    void run(BatchModel batchModel) throws Fault {
        InterviewParameters interviewParameters = batchModel.getInterviewParameters();
        if (!(interviewParameters.getConcurrencyParameters() instanceof Parameters.MutableConcurrencyParameters)) {
            throw new Fault(Command.i18n, "conc.notEditable");
        }
        Parameters.MutableConcurrencyParameters mutableConcurrencyParameters = (Parameters.MutableConcurrencyParameters)interviewParameters.getConcurrencyParameters();
        mutableConcurrencyParameters.setConcurrency(this.arg);
    }
}

