/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.interview.Interview;
import com.sun.javatest.FileParameters;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.batch.Fault;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;

class BatchModel {
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters parameters;
    private boolean errors;
    private boolean autoRunEnabled = true;
    private File autoRunReportDir;
    private PrintWriter out;
    private Harness.Observer[] harnessObservers = new Harness.Observer[0];
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$batch$BatchModel == null ? (class$com$sun$javatest$batch$BatchModel = BatchModel.class$("com.sun.javatest.batch.BatchModel")) : class$com$sun$javatest$batch$BatchModel);
    static /* synthetic */ Class class$com$sun$javatest$batch$BatchModel;

    BatchModel(PrintWriter printWriter) {
        this.out = printWriter;
    }

    boolean isAutoRunEnabled() {
        return this.autoRunEnabled;
    }

    void disableAutoRun() {
        this.autoRunEnabled = false;
    }

    File getAutoRunReportDir() {
        return this.autoRunReportDir;
    }

    void setAutoRunReportDir(File file) {
        this.autoRunReportDir = file;
    }

    boolean hasErrors() {
        return this.errors;
    }

    void addHarnessObserver(Harness.Observer observer) {
        this.harnessObservers = (Harness.Observer[])DynamicArray.append(this.harnessObservers, observer);
    }

    Harness.Observer[] getHarnessObservers() {
        return this.harnessObservers;
    }

    InterviewParameters getInterviewParameters() throws Fault {
        if (this.parameters == null) {
            if (this.testSuite == null) {
                throw new Fault(i18n, "model.testSuiteNotSet");
            }
            if (this.workDir == null) {
                throw new Fault(i18n, "model.workDirNotSet");
            }
            try {
                Parameters.PriorStatusParameters priorStatusParameters;
                Parameters.KeywordsParameters keywordsParameters;
                Parameters.ExcludeListParameters excludeListParameters;
                this.parameters = this.testSuite.createInterview();
                this.parameters.setWorkDirectory(this.workDir);
                this.parameters.load();
                this.autoRunReportDir = null;
                Parameters.TestsParameters testsParameters = this.parameters.getTestsParameters();
                if (testsParameters instanceof Parameters.MutableTestsParameters) {
                    ((Parameters.MutableTestsParameters)testsParameters).setTestsMode(1);
                }
                if ((excludeListParameters = this.parameters.getExcludeListParameters()) instanceof Parameters.MutableExcludeListParameters) {
                    ((Parameters.MutableExcludeListParameters)excludeListParameters).setExcludeMode(1);
                }
                if ((keywordsParameters = this.parameters.getKeywordsParameters()) instanceof Parameters.MutableKeywordsParameters) {
                    ((Parameters.MutableKeywordsParameters)keywordsParameters).setKeywordsMode(1);
                }
                if ((priorStatusParameters = this.parameters.getPriorStatusParameters()) instanceof Parameters.MutablePriorStatusParameters) {
                    ((Parameters.MutablePriorStatusParameters)priorStatusParameters).setPriorStatusMode(1);
                }
            }
            catch (Interview.Fault fault) {
                throw new Fault((ResourceBundle)i18n, "model.cantLoadInterview", new Object[]{this.parameters.getFile(), fault.getMessage()});
            }
            catch (TestSuite.Fault fault) {
                throw new Fault((ResourceBundle)i18n, "model.cantLoadInterview", new Object[]{this.testSuite.getPath(), fault.getMessage()});
            }
            catch (IOException iOException) {
                throw new Fault((ResourceBundle)i18n, "model.cantLoadInterview", new Object[]{this.parameters.getFile(), iOException});
            }
        }
        return this.parameters;
    }

    void openTestSuite(File file) throws Fault {
        if (this.testSuite != null) {
            throw new Fault(i18n, "model.testSuiteAlreadySet");
        }
        try {
            this.testSuite = TestSuite.open(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault((ResourceBundle)i18n, "model.cantFindTestSuite", file);
        }
        catch (TestSuite.Fault fault) {
            throw new Fault((ResourceBundle)i18n, "model.cantOpenTestSuite", fault.getMessage());
        }
    }

    void openWorkDirectory(File file) throws Fault {
        if (this.workDir != null) {
            throw new Fault(i18n, "model.workDirAlreadySet");
        }
        try {
            if (file.exists()) {
                if (WorkDirectory.isWorkDirectory(file)) {
                    if (this.testSuite == null) {
                        this.workDir = WorkDirectory.open(file);
                        this.testSuite = this.workDir.getTestSuite();
                    } else {
                        this.workDir = WorkDirectory.open(file, this.testSuite);
                    }
                } else if (WorkDirectory.isEmptyDirectory(file)) {
                    if (this.testSuite == null) {
                        throw new Fault((ResourceBundle)i18n, "model.cantCreateWorkDir_noTestSuite", file);
                    }
                    this.workDir = WorkDirectory.create(file, this.testSuite);
                }
            } else if (WorkDirectory.isEmptyDirectory(file)) {
                this.workDir = WorkDirectory.create(file, this.testSuite);
            } else {
                throw new Fault((ResourceBundle)i18n, "model.badWorkDir", file);
            }
            if (this.workDir.getTestSuite().getID() != this.testSuite.getID()) {
                throw new Fault((ResourceBundle)i18n, "model.incompatibleWorkDir", file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault((ResourceBundle)i18n, "model.cantFindWorkDir", file);
        }
        catch (WorkDirectory.Fault fault) {
            throw new Fault((ResourceBundle)i18n, "model.cantOpenWorkDir", fault.getMessage());
        }
    }

    void createWorkDirectory(File file) throws Fault {
        if (this.workDir != null) {
            throw new Fault(i18n, "model.workDirAlreadySet");
        }
        if (this.testSuite == null) {
            throw new Fault(i18n, "model.testSuiteNotSet");
        }
        try {
            this.workDir = WorkDirectory.create(file, this.testSuite);
        }
        catch (WorkDirectory.Fault fault) {
            throw new Fault((ResourceBundle)i18n, "model.cantCreateWorkDir", new Object[]{file, fault.getMessage()});
        }
    }

    void createWorkDirectory(File file, boolean bl) throws Fault {
        if (bl) {
            this.remove(file);
            if (file.exists()) {
                throw new Fault((ResourceBundle)i18n, "model.cantRemoveWorkDir", file);
            }
        }
        this.createWorkDirectory(file);
    }

    void openParameterFile(File file) throws Fault {
        if (this.testSuite != null) {
            throw new Fault(i18n, "model.testSuiteAlreadySet");
        }
        if (this.workDir != null) {
            throw new Fault(i18n, "model.workDirAlreadySet");
        }
        if (this.parameters != null) {
            throw new Fault(i18n, "model.parametersAlreadySet");
        }
        try {
            FileParameters fileParameters = new FileParameters(file);
            if (!fileParameters.isValid()) {
                throw new Fault((ResourceBundle)i18n, "model.badParameterFile", new Object[]{file, fileParameters.getErrorMessage()});
            }
            this.setParameters(fileParameters);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault((ResourceBundle)i18n, "model.cantFindFile", file);
        }
        catch (IOException iOException) {
            throw new Fault((ResourceBundle)i18n, "model.cantReadFile", new Object[]{file, iOException});
        }
    }

    void openInterviewFile(File file) throws Fault {
        if (this.parameters != null) {
            throw new Fault((ResourceBundle)i18n, "model.parametersAlreadySet", file);
        }
        try {
            if (this.workDir == null) {
                if (this.testSuite == null) {
                    this.parameters = InterviewParameters.open(file);
                    this.testSuite = this.parameters.getTestSuite();
                } else {
                    this.parameters = InterviewParameters.open(file, this.testSuite);
                }
                this.workDir = this.parameters.getWorkDirectory();
            } else {
                this.parameters = InterviewParameters.open(file, this.workDir);
            }
            this.autoRunReportDir = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault((ResourceBundle)i18n, "model.cantFindFile", file);
        }
        catch (IOException iOException) {
            throw new Fault((ResourceBundle)i18n, "model.cantReadFile", new Object[]{file, iOException});
        }
        catch (Interview.Fault fault) {
            throw new Fault((ResourceBundle)i18n, "model.cantOpenConfig", new Object[]{file, fault.getMessage()});
        }
    }

    void setParameters(FileParameters fileParameters) throws Fault {
        if (this.testSuite != null) {
            throw new Fault(i18n, "model.testSuiteAlreadySet");
        }
        if (this.workDir != null) {
            throw new Fault(i18n, "model.workDirAlreadySet");
        }
        if (this.parameters != null) {
            throw new Fault(i18n, "model.parametersAlreadySet");
        }
        if (!fileParameters.isValid()) {
            throw new Fault((ResourceBundle)i18n, "model.invalidParameters", fileParameters.getErrorMessage());
        }
        try {
            this.testSuite = fileParameters.getTestSuite();
            this.workDir = fileParameters.getWorkDirectory();
            this.parameters = this.testSuite.createInterview();
            this.parameters.setWorkDirectory(this.workDir);
            this.parameters.load(fileParameters);
            this.autoRunReportDir = fileParameters.getReportDir();
            if (this.autoRunReportDir == null) {
                File file = new File("reports", "report");
                this.autoRunReportDir = this.workDir.getFile(file.getPath());
            }
        }
        catch (TestSuite.Fault fault) {
            fault.printStackTrace();
            throw new Fault((ResourceBundle)i18n, "model.cantCreateInterview", new Object[]{this.testSuite.getRoot(), fault.getMessage()});
        }
    }

    void printMessage(I18NResourceBundle i18NResourceBundle, String string) {
        this.out.println(i18NResourceBundle.getString(string));
    }

    void printMessage(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.out.println(i18NResourceBundle.getString(string, object));
    }

    void printMessage(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.out.println(i18NResourceBundle.getString(string, objectArray));
    }

    void printErrorMessage(I18NResourceBundle i18NResourceBundle, String string) {
        this.out.println(i18NResourceBundle.getString(string));
        this.errors = true;
    }

    void printErrorMessage(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.out.println(i18NResourceBundle.getString(string, object));
        this.errors = true;
    }

    void printErrorMessage(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.out.println(i18NResourceBundle.getString(string, objectArray));
        this.errors = true;
    }

    private void remove(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    this.remove(fileArray[n]);
                    ++n;
                }
                String[] stringArray = file.list();
                if (stringArray != null && stringArray.length > 0) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string = stringArray[n2];
                        if (string.startsWith(".nfs")) {
                            File file2 = new File(file, string);
                            File file3 = new File(file.getParentFile(), string);
                            boolean bl = file2.renameTo(file3);
                        }
                        ++n2;
                    }
                }
            }
            file.delete();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

