/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.FileParameters;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;
import com.sun.javatest.batch.OpenCommand;
import com.sun.javatest.batch.RunTestsCommand;
import com.sun.javatest.batch.TestSuiteCommand;
import com.sun.javatest.batch.WorkDirectoryCommand;
import com.sun.javatest.batch.WriteReportCommand;
import com.sun.javatest.tool.CommandLineHelp;
import com.sun.javatest.tool.Main;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.LineParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BatchManager
extends ToolManager {
    private static final BatchManager theOne = new BatchManager();
    private Map cmdClasses;
    private Command[] cmds;
    private Harness.Observer[] harnessObservers = new Harness.Observer[0];
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$batch$BatchManager == null ? (class$com$sun$javatest$batch$BatchManager = BatchManager.class$("com.sun.javatest.batch.BatchManager")) : class$com$sun$javatest$batch$BatchManager);
    static /* synthetic */ Class class$com$sun$javatest$batch$AuditCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$ConcurrencyCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$EnvCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$EnvFilesCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$ExcludeListCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$KeywordsCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$ObserverCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$OpenCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$ParamsCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$StatusCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$ReportCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$RunTestsCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$SetCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$TestSuiteCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$TestsCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$TimeoutFactorCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$WorkDirectoryCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$WriteReportCommand;
    static /* synthetic */ Class class$com$sun$javatest$batch$BatchManager;

    public static BatchManager access() {
        return theOne;
    }

    private BatchManager() {
    }

    public CommandLineHelp getCommandLineHelp() {
        String[] stringArray = new String[]{"batch"};
        return this.createCommandLineHelp("mgr.cmdLine", stringArray, null);
    }

    public int decodeArg(String[] stringArray, int n, boolean bl) throws Main.BadArgs, ToolManager.Fault {
        if (bl) {
            return 0;
        }
        if (stringArray[n].equalsIgnoreCase("-batch")) {
            Vector vector = new Vector();
            int n2 = n + 1;
            while (n2 < stringArray.length) {
                int n3 = this.decodeArgCommand(stringArray, n2, vector);
                if (n3 == 0) {
                    throw new Main.BadArgs(i18n, "mgr.badArg", stringArray[n2]);
                }
                n2 += n3;
            }
            this.cmds = new Command[vector.size()];
            vector.toArray(this.cmds);
            return stringArray.length - n;
        }
        return 0;
    }

    public void validateArgs() throws Main.BadArgs {
    }

    public int getAcceptableModes() {
        return 1;
    }

    public void setup(int n) throws ToolManager.Fault {
        if (n != 1) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() throws ToolManager.Fault {
        PrintWriter printWriter = new PrintWriter(System.out);
        try {
            Command command;
            BatchModel batchModel = new BatchModel(printWriter);
            int n = 0;
            while (n < this.harnessObservers.length) {
                batchModel.addHarnessObserver(this.harnessObservers[n]);
                ++n;
            }
            boolean bl = true;
            int n2 = 0;
            while (n2 < this.cmds.length) {
                command = this.cmds[n2];
                try {
                    command.run(batchModel);
                }
                catch (Fault fault) {
                    throw new ToolManager.Fault(i18n, "mgr.cmdErr", new Object[]{new Integer(0), null, null, command.getName(), fault.getMessage()});
                }
                ++n2;
            }
            try {
                if (batchModel.isAutoRunEnabled()) {
                    command = new RunTestsCommand();
                    ((RunTestsCommand)command).run(batchModel);
                    File file = batchModel.getAutoRunReportDir();
                    if (file != null) {
                        WriteReportCommand writeReportCommand = new WriteReportCommand(file);
                        writeReportCommand.run(batchModel);
                    }
                }
            }
            catch (Fault fault) {
                throw new ToolManager.Fault(i18n, "mgr.error", fault.getMessage());
            }
            boolean bl2 = !batchModel.hasErrors();
            Object var10_12 = null;
            printWriter.flush();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            printWriter.flush();
            throw throwable;
        }
    }

    public void cleanup() {
        this.cmds = null;
        this.harnessObservers = new Harness.Observer[0];
    }

    public void addHarnessObserver(Harness.Observer observer) {
        this.harnessObservers = (Harness.Observer[])DynamicArray.append(this.harnessObservers, observer);
    }

    private int decodeArgCommand(String[] stringArray, int n, List list) throws Main.BadArgs, ToolManager.Fault {
        String string;
        if (this.cmdClasses == null) {
            this.initCmdClasses();
        }
        if ((string = stringArray[n]).startsWith("-")) {
            String string2 = string.substring(1);
            Class clazz = (Class)this.cmdClasses.get(string2.toLowerCase());
            if (clazz == null) {
                return 0;
            }
            try {
                Command command = (Command)clazz.newInstance();
                int n2 = command.init(stringArray, n + 1);
                list.add(command);
                return n2 + 1;
            }
            catch (Fault fault) {
                throw new Main.BadArgs(i18n, "mgr.cmdErr", new Object[]{new Integer(0), null, null, string2, fault.getMessage()});
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JavaTestError(i18n, "mgr.cantAccessClass", new Object[]{string2, illegalAccessException});
            }
            catch (InstantiationException instantiationException) {
                throw new JavaTestError(i18n, "mgr.cantCreateClass", new Object[]{string2, instantiationException});
            }
        }
        if (string.startsWith("@")) {
            File file = new File(string.substring(1));
            try {
                LineParser lineParser = new LineParser(file);
                this.read(lineParser, list);
                return 1;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ToolManager.Fault(i18n, "mgr.cantFindFile", file);
            }
            catch (IOException iOException) {
                throw new ToolManager.Fault(i18n, "mgr.ioError", new Object[]{file, iOException});
            }
        }
        if (string.indexOf(" ") > 0) {
            LineParser lineParser = new LineParser(new StringReader(string));
            this.read(lineParser, list);
            return 1;
        }
        File file = new File(string);
        if (WorkDirectory.isWorkDirectory(file)) {
            list.add(new WorkDirectoryCommand(file));
            return 1;
        }
        if (TestSuite.isTestSuite(file)) {
            list.add(new TestSuiteCommand(file));
            return 1;
        }
        if (FileParameters.isParameterFile(file)) {
            list.add(new OpenCommand(3, file));
            return 1;
        }
        if (InterviewParameters.isInterviewFile(file)) {
            list.add(new OpenCommand(4, file));
            return 1;
        }
        return 0;
    }

    private void read(LineParser lineParser, List list) throws Main.BadArgs {
        File file = lineParser.getFile();
        try {
            String[] stringArray;
            while ((stringArray = lineParser.readLine()) != null) {
                String string = stringArray[0];
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                Class clazz = (Class)this.cmdClasses.get(string.toLowerCase());
                if (clazz == null) {
                    throw new Main.BadArgs(i18n, "mgr.badCommand", new Object[]{new Integer(file == null ? 0 : 1), file, new Integer(lineParser.getLineNumber()), string});
                }
                try {
                    Command command = (Command)clazz.newInstance();
                    command.init(stringArray2);
                    list.add(command);
                }
                catch (Fault fault) {
                    throw new Main.BadArgs(i18n, "mgr.cmdErr", new Object[]{new Integer(file == null ? 0 : 1), file, new Integer(lineParser.getLineNumber()), string, fault.getMessage()});
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new Main.BadArgs(i18n, "mgr.cantAccessClass", new Object[]{string, illegalAccessException});
                }
                catch (InstantiationException instantiationException) {
                    throw new Main.BadArgs(i18n, "mgr.cantCreateClass", new Object[]{string, instantiationException});
                }
            }
        }
        catch (LineParser.Fault fault) {
            throw new Main.BadArgs(i18n, "mgr.errorInFile", fault.getMessage());
        }
    }

    private void initCmdClasses() {
        if (this.cmdClasses != null) {
            return;
        }
        this.cmdClasses = new HashMap();
        this.cmdClasses.put("audit", class$com$sun$javatest$batch$AuditCommand == null ? (class$com$sun$javatest$batch$AuditCommand = BatchManager.class$("com.sun.javatest.batch.AuditCommand")) : class$com$sun$javatest$batch$AuditCommand);
        this.cmdClasses.put("concurrency", class$com$sun$javatest$batch$ConcurrencyCommand == null ? (class$com$sun$javatest$batch$ConcurrencyCommand = BatchManager.class$("com.sun.javatest.batch.ConcurrencyCommand")) : class$com$sun$javatest$batch$ConcurrencyCommand);
        this.cmdClasses.put("env", class$com$sun$javatest$batch$EnvCommand == null ? (class$com$sun$javatest$batch$EnvCommand = BatchManager.class$("com.sun.javatest.batch.EnvCommand")) : class$com$sun$javatest$batch$EnvCommand);
        this.cmdClasses.put("envfile", class$com$sun$javatest$batch$EnvFilesCommand == null ? (class$com$sun$javatest$batch$EnvFilesCommand = BatchManager.class$("com.sun.javatest.batch.EnvFilesCommand")) : class$com$sun$javatest$batch$EnvFilesCommand);
        this.cmdClasses.put("envfiles", class$com$sun$javatest$batch$EnvFilesCommand == null ? (class$com$sun$javatest$batch$EnvFilesCommand = BatchManager.class$("com.sun.javatest.batch.EnvFilesCommand")) : class$com$sun$javatest$batch$EnvFilesCommand);
        this.cmdClasses.put("excludelist", class$com$sun$javatest$batch$ExcludeListCommand == null ? (class$com$sun$javatest$batch$ExcludeListCommand = BatchManager.class$("com.sun.javatest.batch.ExcludeListCommand")) : class$com$sun$javatest$batch$ExcludeListCommand);
        this.cmdClasses.put("keywords", class$com$sun$javatest$batch$KeywordsCommand == null ? (class$com$sun$javatest$batch$KeywordsCommand = BatchManager.class$("com.sun.javatest.batch.KeywordsCommand")) : class$com$sun$javatest$batch$KeywordsCommand);
        this.cmdClasses.put("observer", class$com$sun$javatest$batch$ObserverCommand == null ? (class$com$sun$javatest$batch$ObserverCommand = BatchManager.class$("com.sun.javatest.batch.ObserverCommand")) : class$com$sun$javatest$batch$ObserverCommand);
        this.cmdClasses.put("open", class$com$sun$javatest$batch$OpenCommand == null ? (class$com$sun$javatest$batch$OpenCommand = BatchManager.class$("com.sun.javatest.batch.OpenCommand")) : class$com$sun$javatest$batch$OpenCommand);
        this.cmdClasses.put("params", class$com$sun$javatest$batch$ParamsCommand == null ? (class$com$sun$javatest$batch$ParamsCommand = BatchManager.class$("com.sun.javatest.batch.ParamsCommand")) : class$com$sun$javatest$batch$ParamsCommand);
        this.cmdClasses.put("priorstatus", class$com$sun$javatest$batch$StatusCommand == null ? (class$com$sun$javatest$batch$StatusCommand = BatchManager.class$("com.sun.javatest.batch.StatusCommand")) : class$com$sun$javatest$batch$StatusCommand);
        this.cmdClasses.put("report", class$com$sun$javatest$batch$ReportCommand == null ? (class$com$sun$javatest$batch$ReportCommand = BatchManager.class$("com.sun.javatest.batch.ReportCommand")) : class$com$sun$javatest$batch$ReportCommand);
        this.cmdClasses.put("runtests", class$com$sun$javatest$batch$RunTestsCommand == null ? (class$com$sun$javatest$batch$RunTestsCommand = BatchManager.class$("com.sun.javatest.batch.RunTestsCommand")) : class$com$sun$javatest$batch$RunTestsCommand);
        this.cmdClasses.put("set", class$com$sun$javatest$batch$SetCommand == null ? (class$com$sun$javatest$batch$SetCommand = BatchManager.class$("com.sun.javatest.batch.SetCommand")) : class$com$sun$javatest$batch$SetCommand);
        this.cmdClasses.put("testsuite", class$com$sun$javatest$batch$TestSuiteCommand == null ? (class$com$sun$javatest$batch$TestSuiteCommand = BatchManager.class$("com.sun.javatest.batch.TestSuiteCommand")) : class$com$sun$javatest$batch$TestSuiteCommand);
        this.cmdClasses.put("tests", class$com$sun$javatest$batch$TestsCommand == null ? (class$com$sun$javatest$batch$TestsCommand = BatchManager.class$("com.sun.javatest.batch.TestsCommand")) : class$com$sun$javatest$batch$TestsCommand);
        this.cmdClasses.put("timeoutfactor", class$com$sun$javatest$batch$TimeoutFactorCommand == null ? (class$com$sun$javatest$batch$TimeoutFactorCommand = BatchManager.class$("com.sun.javatest.batch.TimeoutFactorCommand")) : class$com$sun$javatest$batch$TimeoutFactorCommand);
        this.cmdClasses.put("workdir", class$com$sun$javatest$batch$WorkDirectoryCommand == null ? (class$com$sun$javatest$batch$WorkDirectoryCommand = BatchManager.class$("com.sun.javatest.batch.WorkDirectoryCommand")) : class$com$sun$javatest$batch$WorkDirectoryCommand);
        this.cmdClasses.put("workdirectory", class$com$sun$javatest$batch$WorkDirectoryCommand == null ? (class$com$sun$javatest$batch$WorkDirectoryCommand = BatchManager.class$("com.sun.javatest.batch.WorkDirectoryCommand")) : class$com$sun$javatest$batch$WorkDirectoryCommand);
        this.cmdClasses.put("writereport", class$com$sun$javatest$batch$WriteReportCommand == null ? (class$com$sun$javatest$batch$WriteReportCommand = BatchManager.class$("com.sun.javatest.batch.WriteReportCommand")) : class$com$sun$javatest$batch$WriteReportCommand);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

