/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.audit.Audit;
import com.sun.javatest.batch.BatchModel;
import com.sun.javatest.batch.Command;
import com.sun.javatest.batch.Fault;

class AuditCommand
extends Command {
    private boolean showAllEnvValues;
    private boolean showMultipleEnvValues;

    AuditCommand() {
    }

    String getName() {
        return "audit";
    }

    int init(String[] stringArray, int n) throws Fault {
        int n2 = 0;
        int n3 = n;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equalsIgnoreCase("-showEnvValues")) {
                this.showAllEnvValues = true;
                ++n2;
            } else {
                if (!stringArray[n3].equalsIgnoreCase("-showMultipleEnvValues")) break;
                this.showMultipleEnvValues = true;
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    void run(BatchModel batchModel) throws Fault {
        batchModel.disableAutoRun();
        InterviewParameters interviewParameters = batchModel.getInterviewParameters();
        Audit audit = new Audit(interviewParameters);
        audit.report(System.out, this.showAllEnvValues, this.showMultipleEnvValues);
        if (audit.isOK()) {
            batchModel.printMessage(Command.i18n, "audit.ok");
        } else {
            batchModel.printErrorMessage(Command.i18n, "audit.failed");
        }
    }
}

