/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WorkDirChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.filechooser.FileFilter;

class OptionsDialog
extends ToolDialog {
    private ActionListener okListener;
    private JPanel body;
    private JComboBox tsField;
    private JButton tsBtn;
    private TestSuiteChooser testSuiteChooser;
    private JComboBox wdField;
    private JButton wdBtn;
    private WorkDirChooser workDirChooser;
    private JComboBox cfField;
    private JButton cfBtn;
    private JFileChooser configFileChooser;
    private Listener listener;
    static final String OK = "OK";

    OptionsDialog(Component component, ActionListener actionListener, UIFactory uIFactory) {
        super(component, uIFactory, "opts");
        this.setHelp("audit.options.csh");
        this.okListener = actionListener;
    }

    void setParameters(InterviewParameters interviewParameters) {
        if (this.body == null) {
            this.initGUI();
        }
        if (interviewParameters != null) {
            File file;
            WorkDirectory workDirectory;
            TestSuite testSuite = interviewParameters.getTestSuite();
            if (testSuite != null) {
                this.tsField.setSelectedItem(testSuite.getPath());
            }
            if ((workDirectory = interviewParameters.getWorkDirectory()) != null) {
                this.wdField.setSelectedItem(workDirectory.getPath());
            }
            if ((file = interviewParameters.getFile()) != null) {
                this.cfField.setSelectedItem(file.getPath());
            }
        }
    }

    String getTestSuitePath() {
        return (String)this.tsField.getSelectedItem();
    }

    String getWorkDirPath() {
        return (String)this.wdField.getSelectedItem();
    }

    String getConfigFilePath() {
        return (String)this.cfField.getSelectedItem();
    }

    protected void initGUI() {
        this.setI18NTitle("opts.title");
        this.listener = new Listener();
        this.body = this.uif.createPanel("opts.fields", new GridBagLayout(), false);
        this.body.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 10;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 3;
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3));
        JLabel jLabel = this.uif.createLabel("opts.ts", true);
        this.body.add((Component)jLabel, gridBagConstraints);
        this.tsField = this.uif.createChoice("opts.ts", true, jLabel);
        this.tsField.addItem("");
        this.tsField.addActionListener(this.listener);
        this.body.add((Component)this.tsField, gridBagConstraints2);
        this.tsBtn = this.uif.createIconButton("opts.ts.browse", this.listener);
        this.tsBtn.setBorder(compoundBorder);
        this.body.add((Component)this.tsBtn, gridBagConstraints3);
        JLabel jLabel2 = this.uif.createLabel("opts.wd", true);
        this.body.add((Component)jLabel2, gridBagConstraints);
        this.wdField = this.uif.createChoice("opts.wd", true, jLabel2);
        this.wdField.addItem("");
        this.wdField.addActionListener(this.listener);
        this.body.add((Component)this.wdField, gridBagConstraints2);
        this.wdBtn = this.uif.createIconButton("opts.wd.browse", this.listener);
        this.wdBtn.setBorder(compoundBorder);
        this.body.add((Component)this.wdBtn, gridBagConstraints3);
        JLabel jLabel3 = this.uif.createLabel("opts.config", true);
        this.body.add((Component)jLabel3, gridBagConstraints);
        this.cfField = this.uif.createChoice("opts.config", true, jLabel3);
        this.cfField.addItem("");
        this.cfField.setEditable(true);
        this.cfField.addActionListener(this.listener);
        this.body.add((Component)this.cfField, gridBagConstraints2);
        this.cfBtn = this.uif.createIconButton("opts.config.browse", this.listener);
        this.cfBtn.setBorder(compoundBorder);
        this.body.add((Component)this.cfBtn, gridBagConstraints3);
        Dimension dimension = this.body.getPreferredSize();
        int n = this.uif.getDotsPerInch();
        this.body.setPreferredSize(new Dimension(Math.max(dimension.width, 5 * n), dimension.height));
        this.setBody(this.body);
        JButton jButton = this.uif.createButton("opts.ok", this.okListener, OK);
        JButton jButton2 = this.uif.createCancelButton("opts.cancel");
        JButton jButton3 = this.uif.createHelpButton("opts.help", "audit.options.csh");
        this.setButtons(new JButton[]{jButton, jButton2, jButton3}, jButton);
        this.setComponentListener(this.listener);
    }

    private void updateFieldChoices() {
        this.updateTestSuiteChoices();
        this.updateWorkDirectoryChoices();
        this.updateConfigFileChoices();
    }

    private void chooseTestSuite() {
        int n;
        if (this.testSuiteChooser == null) {
            this.testSuiteChooser = new TestSuiteChooser();
        }
        if ((n = this.testSuiteChooser.showDialog(this.parent)) != 0) {
            return;
        }
        TestSuite testSuite = this.testSuiteChooser.getSelectedTestSuite();
        this.tsField.setSelectedItem(testSuite.getPath());
    }

    private void updateTestSuiteChoices() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Desktop desktop = Desktop.access();
        Tool[] toolArray = desktop.getTools();
        if (toolArray != null) {
            int n = 0;
            while (n < toolArray.length) {
                Tool tool = toolArray[n];
                TestSuite[] testSuiteArray = tool.getLoadedTestSuites();
                if (testSuiteArray != null) {
                    int n2 = 0;
                    while (n2 < testSuiteArray.length) {
                        treeSet.add(testSuiteArray[n2].getPath());
                        ++n2;
                    }
                }
                ++n;
            }
        }
        this.setItems(this.tsField, treeSet);
        this.updateWorkDirectoryChoices();
    }

    private void chooseWorkDirectory() {
        int n;
        if (this.workDirChooser == null) {
            this.workDirChooser = new WorkDirChooser();
            this.workDirChooser.setMode(1);
        }
        if ((n = this.workDirChooser.showDialog(this.parent)) != 0) {
            return;
        }
        WorkDirectory workDirectory = this.workDirChooser.getSelectedWorkDirectory();
        this.wdField.setSelectedItem(workDirectory.getPath());
    }

    private void updateWorkDirectoryChoices() {
        Object object;
        Object object2;
        String string = null;
        try {
            object2 = (String)this.tsField.getSelectedItem();
            if (object2 != null && ((String)object2).length() > 0) {
                object = TestSuite.open(new File((String)object2));
                string = ((TestSuite)object).getID();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = new TreeSet();
        object = Desktop.access();
        Tool[] toolArray = ((Desktop)object).getTools();
        if (toolArray != null) {
            int n = 0;
            while (n < toolArray.length) {
                Tool tool = toolArray[n];
                WorkDirectory[] workDirectoryArray = tool.getLoadedWorkDirectories();
                if (workDirectoryArray != null) {
                    int n2 = 0;
                    while (n2 < workDirectoryArray.length) {
                        WorkDirectory workDirectory = workDirectoryArray[n2];
                        if (string == null || string.equals(workDirectory.getTestSuite().getID())) {
                            object2.add(workDirectory.getPath());
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        this.setItems(this.wdField, (SortedSet)object2);
    }

    private void chooseConfigFile() {
        String string;
        int n;
        if (this.configFileChooser == null) {
            this.configFileChooser = new JFileChooser();
            String string2 = System.getProperty("user.dir");
            if (string2 != null) {
                this.configFileChooser.setCurrentDirectory(new File(string2));
            }
            this.configFileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getPath().endsWith(".jti");
                }

                public String getDescription() {
                    return OptionsDialog.this.uif.getI18NString("opts.jtiFiles");
                }
            });
        }
        if ((n = this.configFileChooser.showOpenDialog(this.parent)) != 0) {
            return;
        }
        File file = this.configFileChooser.getSelectedFile();
        if (file == null) {
            string = "";
        } else {
            string = file.getPath();
            if (!string.endsWith(".jti")) {
                string = string + ".jti";
            }
        }
        this.cfField.setSelectedItem(string);
    }

    private void updateConfigFileChoices() {
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = (String)this.wdField.getSelectedItem();
        try {
            WorkDirectory workDirectory = WorkDirectory.open(new File(string));
            FileHistory fileHistory = FileHistory.getFileHistory(workDirectory, "configHistory.jtl");
            File[] fileArray = fileHistory.getRecentEntries(10);
            int n = 0;
            while (n < fileArray.length) {
                treeSet.add(fileArray[n].getPath());
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setItems(this.cfField, treeSet);
    }

    private void setItems(JComboBox jComboBox, SortedSet sortedSet) {
        Object object;
        int n = jComboBox.getItemCount() - 1;
        while (n >= 0) {
            object = (String)jComboBox.getItemAt(n);
            if (sortedSet.contains(object)) {
                sortedSet.remove(object);
            } else if (((String)object).length() > 0 && !((String)object).equals(jComboBox.getSelectedItem())) {
                jComboBox.removeItemAt(n);
            }
            --n;
        }
        object = sortedSet.iterator();
        while (object.hasNext()) {
            jComboBox.addItem(object.next());
        }
    }

    private class Listener
    extends ComponentAdapter
    implements ActionListener {
        private Listener() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            OptionsDialog.this.updateFieldChoices();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == OptionsDialog.this.tsField) {
                OptionsDialog.this.updateWorkDirectoryChoices();
            } else if (object == OptionsDialog.this.tsBtn) {
                OptionsDialog.this.chooseTestSuite();
            } else if (object == OptionsDialog.this.wdField) {
                OptionsDialog.this.updateConfigFileChoices();
            } else if (object == OptionsDialog.this.wdBtn) {
                OptionsDialog.this.chooseWorkDirectory();
            } else if (object == OptionsDialog.this.cfBtn) {
                OptionsDialog.this.chooseConfigFile();
            }
        }
    }
}

